
#pragma used+
sfrb PINF=0;
sfrb PINE=1;
sfrb DDRE=2;
sfrb PORTE=3;
sfrb ADCL=4;
sfrb ADCH=5;
sfrw ADCW=4;      
sfrb ADCSRA=6;
sfrb ADMUX=7;
sfrb ACSR=8;
sfrb UBRR0L=9;
sfrb UCSR0B=0xa;
sfrb UCSR0A=0xb;
sfrb UDR0=0xc;
sfrb SPCR=0xd;
sfrb SPSR=0xe;
sfrb SPDR=0xf;
sfrb PIND=0x10;
sfrb DDRD=0x11;
sfrb PORTD=0x12;
sfrb PINC=0x13;
sfrb DDRC=0x14;
sfrb PORTC=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb PINA=0x19;
sfrb DDRA=0x1a;
sfrb PORTA=0x1b;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEARL=0x1e;
sfrb EEARH=0x1f;
sfrw EEAR=0x1e;   
sfrb SFIOR=0x20;
sfrb WDTCR=0x21;
sfrb OCDR=0x22;
sfrb OCR2=0x23;
sfrb TCNT2=0x24;
sfrb TCCR2=0x25;
sfrb ICR1L=0x26;
sfrb ICR1H=0x27;
sfrw ICR1=0x26;   
sfrb OCR1BL=0x28;
sfrb OCR1BH=0x29;
sfrw OCR1B=0x28;  
sfrb OCR1AL=0x2a;
sfrb OCR1AH=0x2b;
sfrw OCR1A=0x2a;  
sfrb TCNT1L=0x2c;
sfrb TCNT1H=0x2d;
sfrw TCNT1=0x2c;  
sfrb TCCR1B=0x2e;
sfrb TCCR1A=0x2f;
sfrb ASSR=0x30;
sfrb OCR0=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0=0x33;
sfrb MCUCSR=0x34;
sfrb MCUCR=0x35;
sfrb TIFR=0x36;
sfrb TIMSK=0x37;
sfrb EIFR=0x38;
sfrb EIMSK=0x39;
sfrb EICRB=0x3a;
sfrb RAMPZ=0x3b;
sfrb XDIV=0x3c;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

typedef char *va_list;

#pragma used+

char getchar(void);
void putchar(char c);
void puts(char *str);
void putsf(char flash *str);
int printf(char flash *fmtstr,...);
int sprintf(char *str, char flash *fmtstr,...);
int vprintf(char flash * fmtstr, va_list argptr);
int vsprintf(char *str, char flash * fmtstr, va_list argptr);

char *gets(char *str,unsigned int len);
int snprintf(char *str, unsigned int size, char flash *fmtstr,...);
int vsnprintf(char *str, unsigned int size, char flash * fmtstr, va_list argptr);

int scanf(char flash *fmtstr,...);
int sscanf(char *str, char flash *fmtstr,...);

#pragma used-

#pragma library stdio.lib

unsigned char screen[8][128];

bit dir;
char bf;
struct {
char bf, x, y, ty;
}  lcd;
bit lcd_pg, lcd_blk;

char buff[8]={0x01,0x03,0x07,0x0f,0x1f,0x3f,0x7f,0xff};
void dsp_str(char n)
{   
delay_us(30);
PORTD.0=1;
PORTD.1 = 0;
PORTA=n; 
PORTD.2=1;   
delay_us(1);    
#asm("nop");
PORTD.2=0;  
delay_us(72);
}

void dsp_cmd(char n)
{
delay_us(30);
PORTD.0=0; 
PORTD.1 = 0;
PORTA=n; 
PORTD.2=1;      
delay_us(1);   
#asm("nop");
PORTD.2=0;  
delay_us(72);
}

void set_page0() { lcd.y=0x40; lcd_pg=0; }
void set_page1() { lcd.y=0x40; lcd_pg=1; }

void dsp_addr()
{
if(lcd_pg) { PORTD.4=0; PORTD.5=1; } 
else       { PORTD.4=1; PORTD.5=0; } 
dsp_cmd(lcd.x);
dsp_cmd(lcd.y);
}

void dsp_nul(char n)
{
char i; dsp_addr();
for(i=0; i<n; ++i)
dsp_str(0);
}

void draw_data(unsigned char x, unsigned char y, unsigned int data)
{

dsp_cmd(0X80 | (y & 0x3F));
dsp_cmd(0X80 | (x & 0x0F));
dsp_str((data >> 8) & 0xFF);
dsp_str(data & 0xFF);

}
void lcd_clear()
{
int i,j = 0;      
for(i=0;i<8;i++)
{
for(j=0;j<16;j++)
{
draw_data(i,j,0);       
}
}        
for(i=0;i<8;i++)
{
for(j=16;j<32;j++)
{
draw_data(i,j,0);       
}
}        
for(i=8;i<16;i++)
{
for(j=0;j<16;j++)
{
draw_data(i,j,0);       
}
}        
for(i=8;i<16;i++)
{
for(j=16;j<32;j++)
{
draw_data(i,j,0);       
}
}        

}
void lcd_init()
{

PORTD.4=1;
PORTD.5=1;
PORTD.6 = 0;   
delay_ms(40);
PORTD.6 = 1; 
delay_ms(1);   
dsp_cmd(0x36);                      
delay_us(100);                          
dsp_cmd(0x36);                      
delay_us(40);  
dsp_cmd(0x04);                      
delay_us(100);     
dsp_cmd(0x01);                      
delay_ms(10);
dsp_cmd(0x04);                      
delay_ms(100);
lcd_clear();         

}

void main()
{ 
DDRD=0xFF; 
DDRA=0xFF; 
lcd_init();      
while(1)  
{           

*/                    
int i = 0;        
for(i=0;i<32;i++)
{
draw_data(0,i, 0X0001);   
} 
for(i=0;i<32;i++)
{
draw_data(8,i, 0X0001);   
}
}

}
