#define CUSTOM                              // Custom mode
#include "LK_CustomSlave_22_0811_LKN.h"     // This file has been created by the Easy Configurator 
#include <MsTimer2.h>
#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252
#include <SPI.h>                    // SPI library
EasyCAT EASYCAT;                    // EasyCAT istantiation
//---- pins declaration ------------------------------------------------------------------------------
int EN_TX_485 = 8;
unsigned long Millis = 0;
unsigned long PreviousMillis = 0;
unsigned long PreviousSaw = 0;
unsigned long PreviousCycle = 0;
static unsigned int cnt = 0;
static unsigned int cnt_fnd = 0;
static bool toggle = true;
void timerISR()
{
  static unsigned int cnt_timer = 0;
  toggle = !toggle;
}
void setup() {
  Serial.begin(9600); // serial line initialization
//  Serial.print ("\nEasyCAT - Generic EtherCAT slave\n");          // print the banner
  pinMode(EN_TX_485, OUTPUT);
  MsTimer2::set(10,timerISR);
  MsTimer2::start();
  //---- initialize the EasyCAT board -----
                                                                  
  if (EASYCAT.Init() == true)                                     // initialization
  {                                                               // succesfully completed
    Serial.print ("initialized");                                 //
  }                                                               //
  else                                                            // initialization failed   
  {                                                               // the EasyCAT board was not recognized
    Serial.print ("initialization failed");                       //     
  }
                                                                  // The most common reason is that the SPI 
}

void loop() {
  EASYCAT.MainTask();                                   // execute the EasyCAT task
  Application();                                        // user applications

}

void Application ()                                        
{
  uint16_t Analog0;
  uint16_t Analog1;
  static unsigned char Temp_TXD_VALUE_RS232 = 0;
  static unsigned char Temp_TXD_VALUE_RS485 = 0;    

  Millis = millis();                                    // As an example for this application 
  if (Millis - PreviousMillis >= 10)                    // we choose a cycle time of 10 mS 
  {                                                     // 
    PreviousMillis = Millis;                            //  
   
  }   
  if(Temp_TXD_VALUE_RS232 != EASYCAT.BufferOut.Cust.TXD_VALUE_RS232)
  {
    Temp_TXD_VALUE_RS232 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS232;
    Serial.print("The value that was sent by PC using RS232 com:");
    Serial.println(Temp_TXD_VALUE_RS232);
  }
  else Temp_TXD_VALUE_RS232 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS232;

  if(Temp_TXD_VALUE_RS485 != EASYCAT.BufferOut.Cust.TXD_VALUE_RS485)
  {
    Temp_TXD_VALUE_RS485 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS485;
    digitalWrite(EN_TX_485, HIGH);
    delay(50); 
    Serial.print("The value that was sent by PC using RS485 com:");
    Serial.println(Temp_TXD_VALUE_RS485);
    delay(50); 
    digitalWrite(EN_TX_485, LOW); 
  }
  else Temp_TXD_VALUE_RS485 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS485;
}
