#define CUSTOM                      // Custom mode
#include "LK_CustomSlave_22_0811_LKN.h"     // This file has been created by the Easy Configurator 
#include <MsTimer2.h>
//*********************************************************************************************
#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252
#include <SPI.h>                    // SPI library
EasyCAT EASYCAT;                    // EasyCAT istantiation
//---- pins declaration ------------------------------------------------------------------------------
const int BUZZ = 10;                // analog input 0
const int DIPSW0 = 7;                // analog input 0
const int DIPSW1 = 6;                // analog input 0

int LED0 = A2;  // 1번째 LED
int LED1 = A3;  // 2번째 LED
int FND_1 = A4;  // 1번째 LED
int FND_10 = A5;  // 2번째 LED
int FND_D0 = 2;  // FND Decoder Sig1
int FND_D1 = 3;  // FND Decoder Sig2
int FND_D2 = 4;  // FND Decoder Sig3
int FND_D3 = 5;  // FND Decoder Sig4
int EN_TX_485 = 8;
const int VR_10K = A0;            // digital input  bit 0
const int CDS = A1;               // digital input  bit 0
int val = 0;
uint16_t ContaUp;                 // used for sawthoot test generation
uint8_t  ContaDown;                  
unsigned long Millis = 0;
unsigned long PreviousMillis = 0;
unsigned long PreviousSaw = 0;
unsigned long PreviousCycle = 0;

static unsigned int cnt = 0;
static unsigned int cnt_fnd = 0;
static bool toggle = true;
void timerISR()
{
  static unsigned int cnt_timer = 0;
  toggle = !toggle;
}
void fnd_diplay(unsigned FndValue)
{
  
 static int i,j=0;
 j = FndValue % 10;
 i = FndValue/10;
 if(toggle == true)
 {
    digitalWrite(FND_1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_10, LOW);  // 1번째 LED ON
  switch(i){
    case 0: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 1: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 2: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 3: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 4: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 5: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 6: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 7: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 8: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
    case 9: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
  }
 }
 else if(toggle == false){
  digitalWrite(FND_1, LOW);  // 1번째 LED ON
  digitalWrite(FND_10, HIGH);  // 1번째 LED ON
    switch(j){
    case 0: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 1: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 2: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 3: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 4: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 5: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 6: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 7: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 8: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
    case 9: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
  }
 }
}
void setup() {
  Serial.begin(9600); // serial line initialization
//  Serial.print ("\nEasyCAT - Generic EtherCAT slave\n");          // print the banner
  pinMode(BUZZ, OUTPUT);
  pinMode(FND_1, OUTPUT);
  pinMode(FND_10, OUTPUT);
  pinMode(FND_D0, OUTPUT);
  pinMode(FND_D1, OUTPUT);
  pinMode(FND_D2, OUTPUT);
  pinMode(FND_D3, OUTPUT);
  pinMode(DIPSW0, INPUT_PULLUP); // digital input pins setting      
  pinMode(DIPSW1, INPUT_PULLUP); // digital input pins setting                   
  pinMode(LED0, OUTPUT);  // 1번째 LED 핀(Pin) 출력 포트 설정
  pinMode(LED1, OUTPUT);  // 2번째 LED 핀(Pin) 출력 포트 설정
  MsTimer2::set(10,timerISR);
  MsTimer2::start();
  //---- initialize the EasyCAT board -----
                                                                  
  if (EASYCAT.Init() == true)                                     // initialization
  {                                                               // succesfully completed
    Serial.print ("initialized");                                 //
  }                                                               //
  
  else                                                            // initialization failed   
  {                                                               // the EasyCAT board was not recognized
    Serial.print ("initialization failed");                       //     
  }
                                                                  // The most common reason is that the SPI 
  digitalWrite(BUZZ, LOW); // sets the digital pin 13 on
}

void loop() {
  
  EASYCAT.MainTask();                                   // execute the EasyCAT task
  Application();                                        // user applications

}

void Application ()                                        
{   

  Millis = millis();                                    // As an example for this application 
  if (Millis - PreviousMillis >= 10)                    // we choose a cycle time of 10 mS 
  {                                                     // 
    PreviousMillis = Millis;                            //  
   

  //Check input signal for PDO Input Data
  if (digitalRead(DIPSW0)==LOW)                          
  EASYCAT.BufferIn.Cust.DIPSW_INPUT |= (1<<0);      // lower nibble of input Byte 6
  else                              
  EASYCAT.BufferIn.Cust.DIPSW_INPUT &= ~(1<<0);     // we read each pin and write it 
  
  //Check Tacho Siganl
  if (digitalRead(DIPSW1)==LOW)                           
  EASYCAT.BufferIn.Cust.DIPSW_INPUT |= (1<<1);      // lower nibble of input Byte 6
  else                                                //
  EASYCAT.BufferIn.Cust.DIPSW_INPUT &= ~(1<<1);     // we read each pin and write it 


  
  //Check input signal for PDO Output Data                   
  if (EASYCAT.BufferOut.Cust.LED_Output & (1<<0))      
  digitalWrite(LED0, HIGH);                    // lower nibble of output Byte 0
  else                                        
  digitalWrite(LED0, LOW);                      // we read each bit and write it 
                      
  if (EASYCAT.BufferOut.Cust.LED_Output & (1<<1))  // the four output bits are mapped to the 
  digitalWrite(LED1, HIGH);                    // lower nibble of output Byte 0
  else                                         
  digitalWrite(LED1, LOW);                      // we read each bit and write it
  
  if (EASYCAT.BufferOut.Cust.BUZZ_Output & (1<<0))  // the four output bits are mapped to the 
  digitalWrite(BUZZ, HIGH);                    // lower nibble of output Byte 0
  else                                                // 
  digitalWrite(BUZZ, LOW);                      // we read each bit and write it
  }   

  fnd_diplay(EASYCAT.BufferOut.Cust.FND_Output);
}
