
//********************************************************************************************
//                                                                                           *
// AB&T Tecnologie Informatiche - Ivrea Italy                                                *
// http://www.bausano.net                                                                    *
// https://www.ethercat.org/en/products/791FFAA126AD43859920EA64384AD4FD.htm                 *
//                                                                                           *  
//********************************************************************************************    

//********************************************************************************************    
//                                                                                           *
// This software is distributed as an example, "AS IS", in the hope that it could            *
// be useful, WITHOUT ANY WARRANTY of any kind, express or implied, included, but            *
// not limited,  to the warranties of merchantability, fitness for a particular              *
// purpose, and non infringiment. In no event shall the authors be liable for any            *    
// claim, damages or other liability, arising from, or in connection with this software.     *
//                                                                                           *
//******************************************************************************************** 



//---- AB&T EasyCAT shield custom application example  ---------------------------------------  


// This is the legacy "TestEasyCAT" example but the variables have been 
// customized using the Easy Configuration tool. 
// To understand how to do this please see the Easy Configurator user manual.
//
//
// The input variables used in this example are:
//
//    uint16_t    Analog_0                The first analog input         
//    uint16_t    Analog_1                The second analog input
//    uint8_t     DipSwitches             The four dip switches
//    uint8_t     Bit8_FallingTestRamp    A falling test ramp
//    uint16_t    Bit16_RisingTestRamp    A rising test ramp
//
// And the output:
//
//    uint8_t     Leds;                   The four leds




//*********************************************************************************************

#define CUSTOM                      // Custom mode
#include "LK_CustomSlave_22_0811_LKN.h"     // This file has been created by the Easy Configurator 
#include <MsTimer2.h>
                                    // and must be located in the Arduino project folder
                                    //
                                    // There are two others files created by the Easy Configurator:
                                    // TestEasyCAT_Custom.bin that must be loaded into the EEPROM.
                                    // TestEasyCAT_Custom.xml that must be used by the EtherCAT master. 
                                    
//*********************************************************************************************




#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252
#include <SPI.h>                    // SPI library

 
EasyCAT EASYCAT;                    // EasyCAT istantiation

                                    // The constructor allow us to choose the pin used for the EasyCAT SPI chip select 
                                    // Without any parameter pin 9 will be used 
                   
                                    // We can choose between:
                                    // 8, 9, 10, A5, 6, 7                                    

                                    // On the EasyCAT board the SPI chip select is selected through a bank of jumpers                Millis = millis();                                    // For this application we choose a cycle time of 150 mS

                                    // (The EasyCAT board REV_A allows only pins 8, 9, 10 through 0 ohm resistors)

 //EasyCAT EASYCAT(8);              // example:                                  
                                    // pin 8 will be used as SPI chip select
                                    // The chip select chosen by the firmware must match the setting on the board  


//---- pins declaration ------------------------------------------------------------------------------
#include <LiquidCrystal_I2C.h>  // LiquidCrystal_I2C 헤더파일 호출
//LiquidCrystal_I2C lcd(0x27, 16, 2); // LCD의 address 주소 및 크기 입력


const int BUZZ = 10;                // analog input 0
const int DIPSW0 = 7;                // analog input 0
const int DIPSW1 = 6;                // analog input 0

int LED0 = A2;  // 1번째 LED
int LED1 = A3;  // 2번째 LED

int FND_1 = A4;  // 1번째 LED
int FND_10 = A5;  // 2번째 LED

int FND_D0 = 2;  // FND Decoder Sig1
int FND_D1 = 3;  // FND Decoder Sig2
int FND_D2 = 4;  // FND Decoder Sig3
int FND_D3 = 5;  // FND Decoder Sig4
int EN_TX_485 = 8;
const int VR_10K = A0;               // digital input  bit 0
const int CDS = A1;               // digital input  bit 0




const int in_Break = 8;
int val = 0;

uint16_t ContaUp;                      // used for sawthoot test generation
uint8_t  ContaDown;                    //

unsigned long Millis = 0;
unsigned long PreviousMillis = 0;
unsigned long PreviousSaw = 0;
unsigned long PreviousCycle = 0;

static unsigned int cnt = 0;
static unsigned int cnt_fnd = 0;
static bool toggle = true;
void timerISR()
{
  static unsigned int cnt_timer = 0;
  toggle = !toggle;
}
void fnd_diplay(unsigned FndValue)
{
  
 static int i,j=0;
 j = FndValue % 10;
 i = FndValue/10;
 if(toggle == true)
 {
    digitalWrite(FND_1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_10, LOW);  // 1번째 LED ON
  switch(i){
    case 0: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 1: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 2: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 3: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 4: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 5: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 6: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 7: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 8: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
    case 9: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
  }
 }
 else if(toggle == false){
  digitalWrite(FND_1, LOW);  // 1번째 LED ON
  digitalWrite(FND_10, HIGH);  // 1번째 LED ON
    switch(j){
    case 0: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 1: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 2: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 3: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 4: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 5: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 6: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 7: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D2, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D3, LOW);  // 1번째 LED ON
    break;
    case 8: 
    digitalWrite(FND_D0, LOW);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
    case 9: 
    digitalWrite(FND_D0, HIGH);  // 1번째 LED ON
    digitalWrite(FND_D1, LOW);  // 1번째 LED ON
    digitalWrite(FND_D2, LOW);  // 1번째 LED ON
    digitalWrite(FND_D3, HIGH);  // 1번째 LED ON
    break;
  }
 }
}
void setup() {
  Serial.begin(9600); // serial line initialization
//  Serial.print ("\nEasyCAT - Generic EtherCAT slave\n");          // print the banner
  pinMode(BUZZ, OUTPUT);
  pinMode(FND_1, OUTPUT);
  pinMode(FND_10, OUTPUT);
  pinMode(FND_D0, OUTPUT);
  pinMode(FND_D1, OUTPUT);
  pinMode(FND_D2, OUTPUT);
  pinMode(FND_D3, OUTPUT);
  pinMode(EN_TX_485, OUTPUT);
  
  pinMode(DIPSW0, INPUT_PULLUP); // digital input pins setting      
  pinMode(DIPSW1, INPUT_PULLUP); // digital input pins setting                   
  pinMode(VR_10K, INPUT);             
  pinMode(CDS, INPUT); 
  pinMode(LED0, OUTPUT);  // 1번째 LED 핀(Pin) 출력 포트 설정
  pinMode(LED1, OUTPUT);  // 2번째 LED 핀(Pin) 출력 포트 설정
  MsTimer2::set(10,timerISR);
  MsTimer2::start();
  //---- initialize the EasyCAT board -----
                                                                  
  if (EASYCAT.Init() == true)                                     // initialization
  {                                                               // succesfully completed
    Serial.print ("initialized");                                 //
  }                                                               //
  
  else                                                            // initialization failed   
  {                                                               // the EasyCAT board was not recognized
    Serial.print ("initialization failed");                       //     
  }
                                                                  // The most common reason is that the SPI 
  digitalWrite(BUZZ, LOW); // sets the digital pin 13 on

}

void loop() {
  
  EASYCAT.MainTask();                                   // execute the EasyCAT task
   Application();                                        // user applications

}

void Application ()                                        
{
  uint16_t Analog0;
  uint16_t Analog1;
  static unsigned char Temp_TXD_VALUE_RS232 = 0;
  static unsigned char Temp_TXD_VALUE_RS485 = 0;    

  Millis = millis();                                    // As an example for this application 
  if (Millis - PreviousMillis >= 10)                    // we choose a cycle time of 10 mS 
  {                                                     // 
    PreviousMillis = Millis;                            //  
   
  // --- analog inputs management ---
  Analog0 = analogRead(VR_10K);                         // read analog input 0, 가변저항
  EASYCAT.BufferIn.Cust.AnalogInput = Analog0;           // and put the result into

  Analog1 = analogRead(CDS);                         // read analog input 0, CDS 조도센서
  EASYCAT.BufferIn.Cust.AnalogInput2 = Analog1;           // and put the result into

  //Check Tacho Siganl
  if (digitalRead(DIPSW0)==LOW)                            // the four input pins are mapped to the
  EASYCAT.BufferIn.Cust.DIPSW_INPUT |= (1<<0);      // lower nibble of input Byte 6
  else                                                //
  EASYCAT.BufferIn.Cust.DIPSW_INPUT &= ~(1<<0);     // we read each pin and write it 
  
  //Check Tacho Siganl
  if (digitalRead(DIPSW1)==LOW)                            // the four input pins are mapped to the
  EASYCAT.BufferIn.Cust.DIPSW_INPUT |= (1<<1);      // lower nibble of input Byte 6
  else                                                //
  EASYCAT.BufferIn.Cust.DIPSW_INPUT &= ~(1<<1);     // we read each pin and write it 


  
  // --- four output bits management ----
  //Output Break Signal                                                    //                          
  if (EASYCAT.BufferOut.Cust.LED_Output & (1<<0))           // the four output bits are mapped to the 
  digitalWrite(LED0, HIGH);                    // lower nibble of output Byte 0
  else                                                // 
  digitalWrite(LED0, LOW);                      // we read each bit and write it 

  //Output Break Signal                                                    //                          
  if (EASYCAT.BufferOut.Cust.LED_Output & (1<<1))           // the four output bits are mapped to the 
  digitalWrite(LED1, HIGH);                    // lower nibble of output Byte 0
  else                                                // 
  digitalWrite(LED1, LOW);                      // we read each bit and write it
  
  if (EASYCAT.BufferOut.Cust.BUZZ_Output & (1<<0))           // the four output bits are mapped to the 
  digitalWrite(BUZZ, HIGH);                    // lower nibble of output Byte 0
  else                                                // 
  digitalWrite(BUZZ, LOW);                      // we read each bit and write it
  }   

  fnd_diplay(EASYCAT.BufferOut.Cust.FND_Output);

  if(Temp_TXD_VALUE_RS232 != EASYCAT.BufferOut.Cust.TXD_VALUE_RS232)
  {
    Temp_TXD_VALUE_RS232 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS232;
    Serial.print("The value that was sent by PC using RS232 com:");
    Serial.println(Temp_TXD_VALUE_RS232);
  }
  else Temp_TXD_VALUE_RS232 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS232;

    if(Temp_TXD_VALUE_RS485 != EASYCAT.BufferOut.Cust.TXD_VALUE_RS485)
  {
    Temp_TXD_VALUE_RS485 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS485;
    digitalWrite(EN_TX_485, HIGH);
    delay(50); 
    Serial.print("The value that was sent by PC using RS485 com:");
    Serial.println(Temp_TXD_VALUE_RS485);
    delay(50); 
    digitalWrite(EN_TX_485, LOW); 
  }
  else Temp_TXD_VALUE_RS485 = EASYCAT.BufferOut.Cust.TXD_VALUE_RS485;

}
