
#define CUSTOM                      // Custom mode
#include "LK_CustomSlave_22_0811_LKN.h"     // This file has been created by the Easy Configurator 
#include <MsTimer2.h>
#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252
#include <SPI.h>                    // SPI library
EasyCAT EASYCAT;                    // EasyCAT istantiation
const int VR_10K = A0;               // digital input  bit 0
const int CDS = A1;               // digital input  bit 0
uint16_t ContaUp;                      // used for sawthoot test generation
uint8_t  ContaDown;            
unsigned long Millis = 0;
unsigned long PreviousMillis = 0;
unsigned long PreviousSaw = 0;
unsigned long PreviousCycle = 0;

static unsigned int cnt = 0;
static unsigned int cnt_fnd = 0;
static bool toggle = true;
void timerISR()
{
  static unsigned int cnt_timer = 0;
  toggle = !toggle;
}
void setup() {
  Serial.begin(9600); // serial line initialization          
  pinMode(VR_10K, INPUT);             
  pinMode(CDS, INPUT); 
  MsTimer2::set(10,timerISR);
  MsTimer2::start();                            
  if (EASYCAT.Init() == true)                                     // initialization
  {                                                               // succesfully completed
    Serial.print ("initialized");                             
  }
  else                                                            // initialization failed   
  {                                                               // the EasyCAT board was not recognized
    Serial.print ("initialization failed");                       //     
  }
                                                                  // The most common reason is that the SPI 
}
void loop() {
  EASYCAT.MainTask();                                   // execute the EasyCAT task
  Application();                                        // user applications
}
void Application ()                                        
{
  uint16_t Analog0;
  uint16_t Analog1;
  static unsigned char Temp_TXD_VALUE_RS232 = 0;
  static unsigned char Temp_TXD_VALUE_RS485 = 0;    
  Millis = millis();                                    // As an example for this application 
  if (Millis - PreviousMillis >= 10)                    // we choose a cycle time of 10 mS 
  {                                                     // 
    PreviousMillis = Millis;                            //  
    // --- analog inputs management ---
    Analog0 = analogRead(VR_10K);                         // read analog input 0, 가변저항
    EASYCAT.BufferIn.Cust.AnalogInput = Analog0;           // and put the result into
    Analog1 = analogRead(CDS);                         // read analog input 0, CDS 조도센서
    EASYCAT.BufferIn.Cust.AnalogInput2 = Analog1;           // and put the result into
  }   
}
