
#include <mega128.h>
#include <delay.h>

#define PWM0 PORTB.0
#define PWM1 PORTB.1
#define DI0 PORTB.2
#define DI1 PORTB.3
unsigned int duty=0;

// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
{
    static unsigned int cnt,cnt2=0;
    cnt++;cnt2++;     
    if(cnt==duty)
    {
      PWM1=0;
    }   
    if(cnt==50)
    {
      PWM1=1;   
      cnt=0;
    }    
    if(cnt2==500)
    {
        duty++;     // pwm ontime duty  
        if(duty>50) 
        {
            duty=1; // pwm pluse initialization value  
        }
        cnt2=0;
    }
    TCNT0+=0x06;
}

void main(void)
{

    // Input/Output Ports initialization

    PORTB=0x00;
    DDRB=0x00;
 
    // Timer/Counter 0 initialization         
    TCCR0=0x03;// 64Prescale Select
    TCNT0=0x06;// Timer/Count Register initialization
    TIMSK=0x01;// Timer(s)/Counter(s) Interrupt(s) initialization
   
    #asm("sei")// Global enable interrupts
    
    duty=1;// pwm pluse initialization value   
    DI0=0;
    DI1=1;

while (1)
    {

    }
}
