
/*===========================================================================================
Project : TLCD Test
Version : LK-AVR8D-V01
Date    : 2011-07-28
Author  : Kyung Nam Lee
Company : LKEMBEDDED 
Compiler: WINAVR + AVRStuio
Comment : ATmega8 ߺ带 ̿Ͽ TLCD   ڸ ϴ α׷ ҽ̴.

 10Pin Box ̺  Ʒ  ּ!

ATmega8ߺ 10Pin Box Ŀ (PORTB) <----10P ÷̺ -------> TLCD Ȯ庸 - 10Pin Box Ŀ(PORT0)
ATmega8ߺ 10Pin Box Ŀ (PORTD) <----10P ÷̺--------> TLCD Ȯ庸 - 10Pin Box Ŀ(PORT1)

===========================================================================================*/

#include <avr/io.h>
#include <avr/delay.h>
#include <avr/interrupt.h>
#include <compat/deprecated.h>
#define   nop()   asm volatile("nop"::)

#define lcd_en_on 	sbi(PORTB,0)
#define lcd_en_off	 cbi(PORTB,0)

#define lcd_rw_on 	sbi(PORTB,1)
#define lcd_rw_off	 cbi(PORTB,1)

#define lcd_rs_on 	sbi(PORTB,2)
#define lcd_rs_off 	cbi(PORTB,2)

#define lcd_dt PORTD
volatile const char str[11][16]={"===LKEMBEDDED===",  
 								"====  WWW. =====", 
								"== LKEMBEDDED.==",
								"==== CO.KR =====", 
								"   Education    ",
								"   Development  ",
								"  AVR Dev & EDU ",  
								"  PIC Dev & EDU ",  
								"  ARM Dev & EDU ", 
								" PADS Dev & EDU ",  
								"   Cirquit EDU  "
								};   

void dsp_str(char n)
{
	lcd_rs_on;
	PORTD=n;
	_delay_us(5); //Pulse retain
	lcd_en_on;
	_delay_us(1);
	lcd_en_off;
	_delay_us(40);
}


//----------------------------------------------------
void dsp_cmd(char n)
{
	lcd_rs_off;
	PORTD=n;
	_delay_us(5); //Pulse retain
	lcd_en_on;
	_delay_us(1);
	lcd_en_off;
	_delay_us(40);
}
void lcd_init() //16x2line
{
	lcd_dt=0; 
	lcd_en_off;lcd_rw_off;lcd_rs_off;
	_delay_ms(10); dsp_cmd(0x30);
	_delay_ms(5);  dsp_cmd(0x30);
	_delay_ms(1);  dsp_cmd(0x30);
	_delay_ms(5);  dsp_cmd(0x38); //8bit mode,function set
	dsp_cmd(0x0c); 			      //display on/off
	dsp_cmd(0x14);				  //cursor/display
	dsp_cmd(0x06);				  //entry mode
	dsp_cmd(0x01); 				  //display clear
	_delay_ms(2);
}
void clcd_line1(){dsp_cmd(0x80);} //line1			
void clcd_line2(){dsp_cmd(0XC0);} //line2	

volatile int Toggle=0;
volatile int num_cnt1=0;
volatile int num_cnt2=6;
// Timer 0 overflow interrupt service routine
ISR(TIMER0_OVF_vect) 
{
	volatile  static unsigned int cnt,cnt2=0;
	cnt++;
	if(cnt==1000)
	{
	cnt2++;
	if(cnt2==2)
	{
	num_cnt1++;cnt2=0;
	}
	num_cnt2++;
	cnt=0;    
	}    
	if(num_cnt1==6)
	{
	num_cnt1=0;
	} 
	if(num_cnt2==9)
	{   
	num_cnt2=6;
	}
	TCNT0+=6;
}



void main(void)
{
	//-- Ʈ ʱȭ! 
	PORTB=0xFF; //Contro line
	DDRB=0xFF;    

	PORTD=0xFF; //Data line
	DDRD=0xFF;  

	//--Ÿ̸/ī ͷƮ ʱȭ!
	TCCR0=0X04;
	TCNT0=6;
	TIMSK=0X01;
	SREG=0X80;
	        
	lcd_init();

	while(1)
	{
	int i=0;
	clcd_line1();
	for(i=0; i<16; ++i){dsp_str(str[num_cnt1][i]);}
	
	clcd_line2();
	for(i=0; i<16; ++i){dsp_str(str[num_cnt2][i]);}
	}
	}



