/*===========================================================================================
Project :   1     ϱ  
Version : LKM-SMC-V01
Date    : 2014-08-13
Author  : Kyung Nam Lee
Company : LKEMBEDDED 
Compiler: CodevisionAVR + AVRStudio
Comment :  Ͱ θ ̺L(LK-SMC) Atmega128 (DEV) Ǿ  ׽Ʈ Ͽϴ.
PORTC PC0~PC4 A, /A, B, /B  ϸ ˴ϴ.
ܺͷƮ4, 5(PE4, PE5) ġ  PWM  ȸ/ȸ  ˴ϴ. 


10P ڽ  ̺  Ʒ  ּ!
ATmega128-C Ȯ ߺ 10P ڽ Ŀ(PORTC) <---------> θ  - 10P ڽ Ŀ(PORT)


===========================================================================================*/

#include <mega128.h>
#include <delay.h>
#include <stdio.h>


char cw[4]={0x01,0x04,0x02,0x08};
char ccw[4]={0x08,0x02,0x04,0x01};

static unsigned int i=0;
static unsigned int on_time_duty=2;
static unsigned int Dir=0;

interrupt [TIM0_OVF] void timer0_ovf_isr(void)// Timer 0 overflow interrupt service routine
{
    static int cnt=0;
    cnt++;
    if(cnt>=on_time_duty)//Phase delay! 30mS
    { 
    cnt=0;
      i++; //Phase up Counting!     
      if(i==4)
      {
        i=0;
      }
    }                
    TCNT0+=0x06; //per 1mS
}
// Declare your global variables here

interrupt [EXT_INT4] void external_int4(void)   // ܺ ͷƮ 1
{
    on_time_duty++; //  on time on_time_duty increment!
    delay_ms(5);                
}

interrupt [EXT_INT5] void external_int5(void)   // ܺ ͷƮ 1
{
    Dir++;  // reverse spin 
    delay_ms(5); 
                 
}

void main(void)
{
    PORTC=0x00; // PORTC 0~7   
    DDRC=0xff;                                                        

    TCCR0=0x04; // 64ֺ, ÷ο ͷƮ 
    TCNT0=0x06; // Ÿ̸ ī ʱⰪ 6  
    TIMSK=0x01; // Ÿ̸ ÷ο ͷƮ Ȱȭ  
    
    EICRB = 0b00001010 ;    // ܺ ͷƮ 4,5 falling edge   PE4,PE5
    EIMSK = 0b00110000;    // ܺ ͷƮ 4,5 enable 
    
    #asm("sei") // Global enable interrupts
 
    while (1) //endless Loop
    {   
        if(Dir>=2) 
        {
            Dir=0;
        }
        if(on_time_duty >= 6) //on time on_time_duty
        {
            on_time_duty=2; // 2mS initialization! 
        }
        switch(Dir){
            case 0 : PORTC=cw[i]; break;
            case 1 : PORTC=ccw[i]; break;
        }     
    }


}
