
/*===========================================================================================
Project : TLCD Test
Version : LK-AVR2560D-V01
Date    : 2011-07-28
Author  : Kyung Nam Lee
Company : LKEMBEDDED 
Compiler: CodevisionAVR + AVRStuio
Comment : ATmega2560 ߺ带 ̿Ͽ TLCD   ڸ ϴ α׷ ҽ̴.

 10Pin Box ̺  Ʒ  ּ!

ATmega2560ߺ 10Pin Box Ŀ (PORTB) <----10P ÷̺ -------> TLCD Ȯ庸 - 10Pin Box Ŀ(PORT0)
ATmega2560ߺ 10Pin Box Ŀ (PORTD) <----10P ÷̺--------> TLCD Ȯ庸 - 10Pin Box Ŀ(PORT1)

===========================================================================================*/
#include <mega2560.h>
#include <delay.h>

#define   nop()   asm volatile("nop"::)
#define lcd_dt PORTD
#define lcd_en PORTB.0
#define lcd_rw PORTB.1
#define lcd_rs PORTB.2

flash signed char str[11][17]={        
                                "===LKEMBEDDED===",  
 								"====  WWW. =====", 
								"== LKEMBEDDED.==",
								"==== CO.KR =====", 
								"   Education    ",
								"   Development  ",
								"  AVR Dev & EDU ",  
								"  PIC Dev & EDU ",  
								"  ARM Dev & EDU ", 
								" PADS Dev & EDU ",  
								"   Cirquit EDU  "
                        };   
void dsp_str(char n)
{
   lcd_rs=1; 
   lcd_dt=n;
   lcd_en=1; 
   delay_us(1);
   lcd_en=0;
   delay_us(40);
}

//----------------------------------------------------
void dsp_cmd(char n)
{
   lcd_rs=0; 
   lcd_dt=n;
   lcd_en=1;
   delay_us(1);
   lcd_en=0; 
   delay_us(40);
}
void lcd_init() //16x2line
{
   lcd_dt=0; lcd_rw=lcd_rs=lcd_en=0;
   delay_ms(10); dsp_cmd(0x30); //8bit mode
   delay_ms(5);  dsp_cmd(0x30);
   delay_ms(1);  dsp_cmd(0x30);
   delay_ms(5);  dsp_cmd(0x38); //function set
   dsp_cmd(0x0c); //display on/off
   dsp_cmd(0x14); //cursor/display
   dsp_cmd(0x06); //entry mode
   dsp_cmd(0x01); delay_ms(2); //display clear
}
void clcd_line1(){dsp_cmd(0x80);} //line1			
void clcd_line2(){dsp_cmd(0XC0);} //line2	

volatile int Toggle=0;
volatile int num_cnt1=0;
volatile int num_cnt2=6;
// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)  //1ms Tick Time
{
	static unsigned int cnt,cnt2=0;
	cnt++;
	if(cnt==1000)
	{
	cnt2++;
	if(cnt2==2)
	{
	num_cnt1++;cnt2=0;
	}
	num_cnt2++;
	cnt=0;    
	}    
	if(num_cnt1==6)
	{
	num_cnt1=0;
	} 
	if(num_cnt2==9)
	{   
	num_cnt2=6;
	}
	TCNT0+=6;
}



void main(void)
{
	//-- Ʈ ʱȭ! 
	PORTB=0xFF; //Contro line
	DDRB=0xFF;    

	PORTD=0xFF; //Data line
	DDRD=0xFF;  

	//--Ÿ̸/ī ͷƮ ʱȭ!
	TCCR0A=0X00;   
    TCCR0B=0X03; //64Prescale 
	TCNT0=6;
	TIMSK0=0X01;
	SREG=0X80;
	        
	lcd_init();

	while(1)
	{
	int i=0;
	clcd_line1();
	for(i=0; i<16; ++i){dsp_str(str[num_cnt1][i]);}
	
	clcd_line2();
	for(i=0; i<16; ++i){dsp_str(str[num_cnt2][i]);}
	}
	}




