
#pragma used+
sfrb PINA=0;
sfrb DDRA=1;
sfrb PORTA=2;
sfrb PINB=3;
sfrb DDRB=4;
sfrb PORTB=5;
sfrb PINC=6;
sfrb DDRC=7;
sfrb PORTC=8;
sfrb PIND=9;
sfrb DDRD=0xa;
sfrb PORTD=0xb;
sfrb PINE=0xc;
sfrb DDRE=0xd;
sfrb PORTE=0xe;
sfrb PINF=0xf;
sfrb DDRF=0x10;
sfrb PORTF=0x11;
sfrb PING=0x12;
sfrb DDRG=0x13;
sfrb PORTG=0x14;
sfrb TIFR0=0x15;
sfrb TIFR1=0x16;
sfrb TIFR2=0x17;
sfrb TIFR3=0x18;
sfrb TIFR4=0x19;
sfrb TIFR5=0x1a;
sfrb PCIFR=0x1b;
sfrb EIFR=0x1c;
sfrb EIMSK=0x1d;
sfrb GPIOR0=0x1e;
sfrb EECR=0x1f;
sfrb EEDR=0x20;
sfrb EEARL=0x21;
sfrb EEARH=0x22;
sfrw EEAR=0X21;   
sfrb GTCCR=0x23;
sfrb TCCR0A=0x24;
sfrb TCCR0B=0x25;
sfrb TCNT0=0x26;
sfrb OCR0A=0x27;
sfrb OCR0B=0x28;
sfrb GPIOR1=0x2a;
sfrb GPIOR2=0x2b;
sfrb SPCR=0x2c;
sfrb SPSR=0x2d;
sfrb SPDR=0x2e;
sfrb ACSR=0x30;
sfrb OCDR=0x31;
sfrb SMCR=0x33;
sfrb MCUSR=0x34;
sfrb MCUCR=0x35;
sfrb SPMCSR=0x37;
sfrb RAMPZ=0x3b;
sfrb EIND=0x3c;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.EQU __sm_adc_noise_red=0x02
	.SET power_ctrl_reg=smcr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

typedef char *va_list;

#pragma used+

char getchar(void);
void putchar(char c);
void puts(char *str);
void putsf(char flash *str);
int printf(char flash *fmtstr,...);
int sprintf(char *str, char flash *fmtstr,...);
int vprintf(char flash * fmtstr, va_list argptr);
int vsprintf(char *str, char flash * fmtstr, va_list argptr);

char *gets(char *str,unsigned int len);
int snprintf(char *str, unsigned int size, char flash *fmtstr,...);
int vsnprintf(char *str, unsigned int size, char flash * fmtstr, va_list argptr);

int scanf(char flash *fmtstr,...);
int sscanf(char *str, char flash *fmtstr,...);

#pragma used-

#pragma library stdio.lib

unsigned char screen[8][128];
bit flg;
char bf;
struct {
char bf, x, y, ty;
}  lcd;
bit lcd_pg, lcd_blk;
flash char han[62][24]={

0x00,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x0f,0x0c,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,

0x00,0xfe,0xfe,0xe0,0xb0,0x18,0x0c,0x06,0x02,0x00,0x00,0x00, 
0x00,0x0f,0x0f,0x00,0x01,0x03,0x06,0x0c,0x08,0x00,0x00,0x00,

0x00,0x38,0x44,0x44,0x44,0x44,0x38,0x00,0x00,0xfc,0x00,0x00, 
0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,

0x00,0xfc,0x40,0x40,0xfc,0x40,0x40,0xfc,0x00,0xfc,0x00,0x00, 
0x00,0x0f,0x08,0x08,0x0f,0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,

0x00,0xfc,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0xfc,0x00,0x00, 
0x00,0x0f,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x1f,0x00,0x00,

0x00,0x00,0xfc,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x00,0x00, 
0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,

0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, 
0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,

0x00,0x80,0xa4,0xa4,0xbc,0xa4,0xa4,0xbc,0xa4,0xa4,0x80,0x00, 
0x00,0x00,0x1e,0x12,0x12,0x12,0x13,0x12,0x12,0x1e,0x00,0x00,

0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, 
0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,

0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, 
0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,

0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x00,0x00,0xfc,0x00,0x00, 
0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,

0x00,0x84,0x84,0x84,0x44,0x24,0x5c,0x48,0x48,0xfc,0x00,0x00, 
0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,

0x00,0x7c,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0xfc,0x10,0x10, 
0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,

0x00,0x00,0xc0,0x30,0x0c,0x30,0xc0,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0e,0x01,0x01,0x01,0x01,0x01,0x0e,0x00,0x00,0x00,0x00,

0x00,0x1c,0xe0,0x00,0x00,0x00,0xe0,0x1c,0x00,0x00,0x00,0x00, 
0x00,0x00,0x00,0x03,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,

0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00, 
0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0xf0,0x08,0x04,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00, 
0x00,0x03,0x04,0x08,0x08,0x08,0x08,0x04,0x00,0x00,0x00,0x00,

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
0x00,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0xc0,0x30,0x0c,0x30,0xc0,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0e,0x01,0x01,0x01,0x01,0x01,0x0e,0x00,0x00,0x00,0x00,

0x00,0xfc,0x04,0x04,0x04,0x08,0xf0,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x08,0x08,0x08,0x04,0x03,0x00,0x00,0x00,0x00,0x00,

0x00,0x38,0x44,0x44,0x84,0x84,0x18,0x00,0x00,0x00,0x00,0x00, 
0x00,0x06,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0x04,0xc4,0x04,0x04,0xc4,0x04,0x04,0xfc,0x00,0x00, 
0x00,0x08,0x08,0x0f,0x08,0x08,0x0f,0x08,0x0a,0x09,0x08,0x00,

0x00,0x80,0x98,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0x98,0x80,0x00, 
0x00,0x00,0x02,0x03,0x02,0x02,0x02,0x02,0x03,0x1e,0x00,0x00,

0x00,0x04,0x84,0x64,0x1c,0x24,0x44,0x94,0x10,0xfc,0x00,0x00, 
0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,

0x00,0x00,0x3c,0x24,0x24,0x24,0x24,0x24,0x24,0x3c,0x00,0x00, 
0x00,0x01,0x1d,0x11,0x11,0x11,0x17,0x11,0x11,0x11,0x01,0x00,

0x00,0x84,0x84,0x84,0x44,0x24,0x1c,0x00,0x00,0xfc,0x20,0x20, 
0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,

0x00,0x00,0x00,0x80,0x7c,0x80,0x00,0x00,0x00,0xfc,0x80,0x80, 
0x00,0x08,0x06,0x01,0x00,0x01,0x06,0x08,0x00,0x1f,0x00,0x00,

0x00,0x04,0x84,0x64,0x1c,0x24,0x44,0x94,0x10,0xfc,0x00,0x00, 
0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,

0x00,0x04,0x04,0x84,0x7c,0x84,0x04,0x04,0x00,0xfc,0x80,0x80, 
0x00,0x08,0x06,0x01,0x00,0x01,0x06,0x08,0x00,0x1f,0x00,0x00,

0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, 
0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,

0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, 
0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,

0x00,0x80,0x98,0xe4,0xa4,0xa4,0xa4,0xa4,0xe4,0x98,0x80,0x00, 
0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,

0x00,0x38,0x44,0x44,0x44,0x44,0x38,0x28,0x28,0xfc,0x00,0x00, 
0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x1e,0x00,0x00,

0x00,0xfc,0x04,0x04,0x04,0x04,0xfc,0x00,0x00,0xfc,0x80,0x80, 
0x00,0x0f,0x08,0x08,0x08,0x08,0x0f,0x00,0x00,0x1f,0x00,0x00,

0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x00,0x00,0xfc,0x00,0x00, 
0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,

0x00,0x94,0x94,0x94,0x54,0x34,0x1c,0x10,0x10,0xfc,0x00,0x00, 
0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,

0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, 
0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,

0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x40,0x40,0xfc,0x00,0x00, 
0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,

0x00,0x00,0x80,0x60,0x1c,0x20,0x40,0x80,0x00,0xfc,0x00,0x00, 
0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,

0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, 
0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,

0x00,0x80,0xa4,0xa4,0xbc,0xa4,0xa4,0xbc,0xa4,0xa4,0x80,0x00, 
0x00,0x00,0x1e,0x12,0x12,0x12,0x13,0x12,0x12,0x1e,0x00,0x00,

0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, 
0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,

0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, 
0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,

0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,

0x00,0xfc,0x18,0x60,0x80,0x00,0x80,0x60,0x18,0xfc,0x00,0x00, 
0x00,0x0f,0x00,0x00,0x01,0x06,0x01,0x00,0x00,0x0f,0x00,0x00,

0x00,0x10,0x90,0x54,0x54,0x54,0x90,0x10,0x00,0xfc,0x00,0x00, 
0x00,0x08,0x09,0x0a,0x0e,0x0a,0x09,0x08,0x00,0x1f,0x00,0x00,

0x00,0x00,0xe4,0x24,0x24,0x24,0x24,0x24,0x24,0x3c,0x00,0x00, 
0x00,0x08,0x09,0x09,0x09,0x09,0x0f,0x09,0x09,0x09,0x08,0x00,

0x00,0x80,0x40,0x30,0x1c,0x20,0x50,0x10,0x10,0x7c,0x00,0x00, 
0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,

0x00,0x04,0x04,0x04,0xfc,0x10,0x10,0xfc,0x00,0xfc,0x00,0x00, 
0x00,0x08,0x04,0x03,0x00,0x01,0x01,0x1f,0x00,0x1f,0x00,0x00,

0x00,0x84,0x84,0xfc,0x84,0xfc,0x84,0x94,0x10,0xfc,0x00,0x00, 
0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,

0x00,0x38,0x44,0x44,0x44,0x38,0x00,0xfc,0x00,0xfc,0x00,0x00, 
0x00,0x01,0x09,0x07,0x01,0x05,0x04,0x1f,0x00,0x1f,0x00,0x00,

0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x40,0x40,0xfc,0x00,0x00, 
0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,

0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0xf0,0x08,0x04,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00, 
0x00,0x03,0x04,0x08,0x08,0x08,0x08,0x04,0x00,0x00,0x00,0x00,

0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, 
0x00,0x0f,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x00,0x00,0x00,

0x00,0xe0,0x18,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
0x00,0x03,0x0c,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x04,0x18,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
0x00,0x10,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

0x00,0x00,0xfc,0x90,0x90,0x90,0x90,0x90,0x90,0xfc,0x00,0x00, 
0x00,0x08,0x08,0x08,0x08,0x08,0x0f,0x08,0x08,0x08,0x08,0x00,

0x00,0x00,0xfc,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x00,0x00, 
0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,

};
char SecCnt=0;
bit SecFlag;
interrupt [24] void timer0_ovf_isr(void)
{
static unsigned int cnt=0;
cnt++;
if(cnt>=1000)
{
SecCnt++;
SecFlag^=1;
cnt=0;
if(SecCnt>=10)
{
SecCnt=0;

}
}

}

char gbuf[128][8];

void dsp_str(char n)
{
delay_us(30); PORTD.0=1; PORTC=n; 
PORTD.2=1; #asm("nop"); PORTD.2=0;  
}

void dsp_cmd(char n)
{
delay_us(30); PORTD.0=0; PORTC=n; 
PORTD.2=1; #asm("nop"); PORTD.2=0;  
}

void lcd_init()
{
PORTD.4=1;
PORTD.5=1; 
dsp_cmd(0x3f);
dsp_cmd(0xc0);
}

void set_page0() { lcd.x=0x40; lcd_pg=0; }
void set_page1() { lcd.x=0x40; lcd_pg=1; }

void dsp_addr()
{
if(lcd_pg) { PORTD.4=0; PORTD.5=1; } 
else       { PORTD.4=1; PORTD.5=0; } 
dsp_cmd(lcd.y);
dsp_cmd(lcd.x);
}
void dsp_nul(char n)
{
char i; dsp_addr();
for(i=0; i<n; ++i)
dsp_str(0);
}
void dsp_nul2(char n)
{
char i;
dsp_addr(); 
lcd.bf=0;  
if(lcd_blk)
lcd.bf=~lcd.bf;
for(i=0; i<n; ++i) 
dsp_str(lcd.bf);
++lcd.y;
dsp_addr();
lcd.bf=0;
if(lcd_blk)
{ lcd.bf=~lcd.bf; lcd.bf&=~0x80; }
for(i=0; i<n; ++i)
dsp_str(lcd.bf);
lcd.x+=n; 
lcd.y=lcd.ty;
}
void lcd_clear()
{
char i;
lcd.x=0x40; lcd.y=0xb8;
for(i=0; i<8; ++i) {
lcd_pg=0;
dsp_nul(64);
lcd_pg=1;
dsp_nul(64);
++lcd.y;

}
}
void dsp_han(flash char *p, char n)
{
char i, bf1, bf2;
static int cnt=0;
static int cnt2=0;
static int cnt3=0;
bf1=n*12;
dsp_addr();
for(i=0; i<bf1; ++i) {  
lcd.bf=p[i];
if(lcd_blk) lcd.bf=~lcd.bf; 
dsp_str(lcd.bf); 
}
bf2=bf1*2;  
++lcd.y; 
dsp_addr(); 
for(i=bf1; i<bf2; ++i) {
lcd.bf=p[i];
if(lcd_blk)
{ lcd.bf=~lcd.bf; lcd.bf&=~0x80; }
dsp_str(lcd.bf);
}

lcd.x+=bf1; 
lcd.y=lcd.ty; 
}
void first()
{
set_page0();
lcd.ty=lcd.y=0xb8;
lcd_blk=1;
dsp_nul2(28);
dsp_han(han[0],1);
dsp_han(han[1],1);
dsp_han(han[2],1);

set_page1();
lcd.ty=lcd.y=0xb8;
lcd_blk=1;
dsp_han(han[3],1);
dsp_han(han[4],1);
dsp_han(han[5],1); dsp_nul2(28);

}
void second()
{
switch(SecCnt)
{
case 0: 
set_page0();
lcd.ty=lcd.y=0xba; 
lcd_blk=0;
dsp_nul2(16);
dsp_han(han[30],1);
dsp_han(han[31],1);
dsp_han(han[32],1);
dsp_han(han[33],1);
set_page1();
lcd.ty=lcd.y=0xba;
lcd_blk=0;
dsp_han(han[34],1);
dsp_han(han[35],1);
dsp_han(han[26],1);
dsp_han(han[27],1);
dsp_nul2(16);
break;
case 5:
set_page0();
lcd.ty=lcd.y=0xba; 
lcd_blk=0;
dsp_nul2(16);
dsp_han(han[36],1);
dsp_han(han[37],1);
dsp_han(han[38],1);
dsp_han(han[39],1);
set_page1();
lcd.ty=lcd.y=0xba;
lcd_blk=0;
dsp_han(han[40],1);
dsp_han(han[60],1);
dsp_han(han[61],1);
dsp_han(han[44],1);
dsp_han(han[45],1);
dsp_nul2(3);
break;
}

}

void third()
{
switch(SecCnt)
{
case 0: 
set_page0();
lcd.ty=lcd.y=0xbc; 
lcd_blk=1;
dsp_nul2(4);
dsp_han(han[13],1);
dsp_han(han[14],1);
dsp_han(han[15],1);
dsp_han(han[52],1);
dsp_han(han[53],1);
set_page1();
lcd.ty=lcd.y=0xbc;
lcd_blk=1;

dsp_han(han[54],1);
dsp_han(han[26],1);
dsp_han(han[27],1);
dsp_han(han[24],1);
dsp_han(han[25],1);
dsp_nul2(5);
break;

case 2: 
set_page0();
lcd.ty=lcd.y=0xbc; 
lcd_blk=1;
dsp_nul2(4);
dsp_han(han[16],1);
dsp_han(han[17],1);
dsp_han(han[18],1);
dsp_han(han[52],1);
dsp_han(han[53],1);
set_page1();
lcd.ty=lcd.y=0xbc;
lcd_blk=1;

dsp_han(han[54],1);
dsp_han(han[26],1);
dsp_han(han[27],1);
dsp_han(han[24],1);
dsp_han(han[25],1);
dsp_nul2(5);
break;
case 4: 
set_page0();
lcd.ty=lcd.y=0xbc; 
lcd_blk=1;
dsp_nul2(4);
dsp_han(han[21],1);
dsp_han(han[46],1);
dsp_han(han[47],1);
dsp_han(han[52],1);
dsp_han(han[53],1);
set_page1();
lcd.ty=lcd.y=0xbc;
lcd_blk=1;

dsp_han(han[54],1);
dsp_han(han[26],1);
dsp_han(han[27],1);
dsp_han(han[24],1);
dsp_han(han[25],1);
dsp_nul2(5);
break;

case 6: 
set_page0();
lcd.ty=lcd.y=0xbc; 
lcd_blk=1;
dsp_nul2(4);
dsp_han(han[55],1);
dsp_han(han[56],1);
dsp_han(han[57],1);
dsp_han(han[50],1);
dsp_han(han[51],1);
set_page1();
lcd.ty=lcd.y=0xbc;
lcd_blk=1;

dsp_han(han[26],1);
dsp_han(han[27],1);
dsp_han(han[24],1);
dsp_han(han[25],1);

dsp_nul2(15);
break;

case 8: 
set_page0();
lcd.ty=lcd.y=0xbc; 
lcd_blk=1;
dsp_nul2(4);
dsp_han(han[30],1);
dsp_han(han[31],1);
dsp_han(han[48],1);
dsp_han(han[49],1);
dsp_han(han[50],1);
set_page1();
lcd.ty=lcd.y=0xbc;
lcd_blk=1;

dsp_han(han[51],1);
dsp_han(han[26],1);
dsp_han(han[27],1);
dsp_han(han[24],1);
dsp_han(han[25],1);

break;
}

}

void fourth()
{

switch(SecFlag)
{
case 0:
set_page0();
lcd.ty=lcd.y=0xbe; 
lcd_blk=1;
dsp_nul2(40);
dsp_han(han[10],1);
dsp_han(han[11],1);

set_page1();
lcd.ty=lcd.y=0xbe;
lcd_blk=1;

dsp_han(han[12],1);
dsp_nul2(1);
dsp_han(han[28],1);
dsp_han(han[29],1);
dsp_nul2(28);
break;
case 1:
set_page0();
lcd.ty=lcd.y=0xbe; 
lcd_blk=0;
dsp_nul2(40);
dsp_han(han[10],1);
dsp_han(han[11],1);

set_page1();
lcd.ty=lcd.y=0xbe;
lcd_blk=0;
dsp_han(han[12],1);
dsp_nul2(1);
dsp_han(han[28],1);
dsp_han(han[29],1);
dsp_nul2(28);
break;
}

}
void main()
{ 

DDRC=0xFF;      
DDRD=0xFF;      
PORTD.6=1;          
bf=0x0f;

TCCR0A=0x00;    
TCCR0B=0x03;    
TCNT0=0x06;     
(*(unsigned char *) 0x6e)=0x01;    
lcd_init();     
#asm("sei")     
while(1) {
first();     
second();    
fourth();    
third();     
}

}

