/*======================================================================================
Project : Ÿ̸/ī ͷƮ ̿ FND(7-SEGMENT LED)ϱ 
Version : AVR2560D-V01
Date    : 2011-07-28
Author  : Kyung Nam Lee
Company : LKEMBEDDED 
Compiler: CodevisionAVR + AVRStudio
Comment: FND(7-SEGMENT LED) 100mS  0~9999 ϴ α׷̴.  
======================================================================================*/
#include <mega2560.h>
#include <delay.h>

#define fnd1 0
#define fnd2 1
#define fnd3 2
#define fnd4 3

#define fnd1_on (0<<fnd1)
#define fnd2_on (0<<fnd2)
#define fnd3_on (0<<fnd3)
#define fnd4_on (0<<fnd4)

#define fnd1_off (1<<fnd1)
#define fnd2_off (1<<fnd2)
#define fnd3_off (1<<fnd3)
#define fnd4_off (1<<fnd4)

char Number[11]={0X3F,0X06,0X5B,0X4F,0X66,0X6D,0X7D,0X27,0X7F,0X6F};  //0~9 迭  FND2
unsigned int cnt=0;
// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)  //1ms Tick Time
{
 static int i=0;
 i++;
 if(i==100)
 {
    cnt++;
    i=0;
    if(cnt==9999)   
    {
        cnt=0;
        }
    }
 TCNT0+=0X06;
}

void FndDisplay(unsigned int data)
{                              

    int i,j,k,l=0;   
    l=(data/1000);
    k=(data%1000)/100;
    i=(data%100)/10;
    j=(data%10);
    PORTK=(fnd1_on|fnd2_off|fnd3_off|fnd4_off);
    PORTA=Number[l];         
    delay_ms(5);            
    
    PORTK=(fnd1_off|fnd2_on|fnd3_off|fnd4_off);
    PORTA=Number[k];
    delay_ms(5);    
    
    PORTK=(fnd1_off|fnd2_off|fnd3_on|fnd4_off);
    PORTA=Number[i];         
    delay_ms(5);       
    
    PORTK=(fnd1_off|fnd2_off|fnd3_off|fnd4_on);
    PORTA=Number[j];
    delay_ms(5);

}
void main(void)
{

DDRA=0XFF; //PORTA   
DDRK=0XFF; //PORTB   

TCCR0A=0x00;//Normal Mode Operation(Overflow Interrupt Enable) 
TCCR0B=0x03;//64Prescale Select
TCNT0=0x06;// Timer/Count Register initialization

TIMSK0=0x01;// Timer(s)/Counter(s) Interrupt(s) initialization
#asm("sei")// Global enable interrupts

while (1)
      {               
      FndDisplay(cnt); //Ÿ̸ ī ͷƮ ̿Ͽ 100ms FND ڰ Ѵ.
      }
}
