/*****************************************************
Project : ATmega2560 MCU SPI ׽Ʈ
Version : LK-AVR2560D V01
Date    : 2011-07-28
Author  : Kyung Nam Lee
Company : LKEMBEDDED 
Compiler: CodevisionAVR+AVRStudio
Comment: Master MCU(LK-AVR2560DȮ ߺ) SW1, SW2 Էϸ Slave MCU(LK-AVR2560DȮ ߺ)
          LED ON/OFF Ǹ , ̺ 忡  ȯ ͸ RS232Ʈ  ϴ α׷̴. 
        ̶ LK-AVR2560DȮ ߺ尣    10 ڽ Ŀ(PORTB) 10P÷̺ ̿Ͽ ݵ   Ǿ ־ Ѵ. 
*****************************************************/

#include <mega2560.h>
#include <delay.h>
#include <stdio.h>

//#define Master 
#define Slave   //LK-AVR2560DȮ ߺ Master or Slave 带 !


#ifdef Master
unsigned char SPI_send(unsigned char data)//
{ 
    unsigned char data3=0;    
    SPDR = data;            /* Start transmission */
    while(!(SPSR&0x80));    /* Wait for transmission complete */ 
    return SPDR; 
    /*return SPDR; (write)Լ б Լ   ؼ ּó Ѵ.
    ڴ  Լ   ʿ伺  .  
    ߿  SPIŽÿ Master SPDRͿ Ҷ SPI Clock µȴٴ ̴.
    , ̺꿡 SPDRͿ  ؼ ϰ , Master SPDRͿ  
    (ϸ) Feedback Ǿ Master Էµȴٴ Դϴ.
    */  
}    
char SPI_read()//dummyε о ü   SPI_sendԼó ٷ о  ͵ Ѵ. 
{ 
    unsigned char data3=0;    
    SPDR = 0x00; //Dummy Data
    while(!(SPSR&0x80));          
    return SPDR;  
}     
void Master_init()
{
    PORTB=0x00;
    DDRB=0x07; /* Set MOSI and SCK output, all others input */
    SPCR=0x50; /* Enable SPI, Master, set clock rate fck/16 */
    SPSR=0x00;
}
#endif 

#ifdef Slave 
/*̺ ͷ ͸  ÿ ͸ SPDRͿ 常 ϸ˴ϴ.
̶ Ͱ ̺ ͸   ̺ ʹ ڵ ͷ ۵˴ϴ.
ᱹ Ϳ ߻Ǵ SPIŬ ̴ ̺꿡 ܵ ͷ ͸  ,
AVRĨ SPI Ϳ ̺갡   (LOOP) ͸ ȯϰ ִ.*/
char SPI_receive() //slave
{   
    
    unsigned char data2=0;  
    while(!(SPSR&0x80)); /* Wait for reception complete */
    data2= SPDR;         /* Return Data Register */  
    if(data2==0xfe)
    SPDR = 1;         /* Start transmission */
    else SPDR = 2; 
    printf("SLAVE LK-AVR2560D:receive data from MASTER:%d \r\n",data2); 
    return data2;
    
}
void Slave_init()
{
   
    PORTB=0x00;
    DDRB=0x08;  /* Set MISO output, all others input */   
    SPCR=0x40;  /* Enable SPI */
    SPSR=0x00;
}
#endif
 
void main(void)
{
    UCSR0A=0x00;
    UCSR0B=0x08;
    UCSR0C=0x06;
    UBRR0H=0x00;
    UBRR0L=0x67;  
      
    DDRG=0X13;  //LED, BUZZ OUTPUT SET
    PORTG=0X13; //LED, BUZZ INITIALIZE

    #ifdef Master     //master? 
    Master_init(); 
    #endif
    #ifdef Slave      //master? 
    Slave_init();
    #endif         
while (1)
    {           
         #ifdef Master     //master? 
            static unsigned char data1=0;
            if((PING&0X04)==0)  
            {    
                delay_ms(20); //8mS ð Ȯ Ǿ߸ ۽Ű Ű ļ printf()  ʴ´.          
                data1=SPI_send(0XFF); //Slave '0xff' Transmitter!   
                printf("MASTER  LK-AVR2560D: receive data from SLAVE:%d \r\n",data1); 
            }  
            else if((PING&0X08)==0)  
            {      
                delay_ms(20); 
                data1=SPI_send(0XFE); //Slave '0xfe' Transmitter! 
                printf("MASTER LK-AVR2560D: receive data from SLAVE:%d \r\n",data1);      
    
            } 
        #endif 
        #ifdef Slave      //master? 
            static unsigned char data=0;
            data=SPI_receive(); //Receive Function 
            if(data==0xff)
            {
            PORTG=0X00;   //Buzz, LED ON   
            }
            if(data==0xfe)
            {
            PORTG=0X13;  //Buzz, LED OFF
            }                    
        #endif 
    }
      
}