
;CodeVisionAVR C Compiler V2.05.0 Professional
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega2560
;Program type             : Application
;Clock frequency          : 16.000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 1024 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega2560
	#pragma AVRPART MEMORY PROG_FLASH 262144
	#pragma AVRPART MEMORY EEPROM 4096
	#pragma AVRPART MEMORY INT_SRAM SIZE 8703
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x200

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU EECR=0x1F
	.EQU EEDR=0x20
	.EQU EEARL=0x21
	.EQU EEARH=0x22
	.EQU SPSR=0x2D
	.EQU SPDR=0x2E
	.EQU SMCR=0x33
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU WDTCSR=0x60
	.EQU UCSR0A=0xC0
	.EQU UDR0=0xC6
	.EQU RAMPZ=0x3B
	.EQU EIND=0x3C
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU XMCRA=0x74
	.EQU XMCRB=0x75
	.EQU GPIOR0=0x1E

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0200
	.EQU __SRAM_END=0x21FF
	.EQU __DSTACK_SIZE=0x0400
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _bf=R5
	.DEF _SecCnt=R4

;GPIOR0 INITIALIZATION VALUE
	.EQU __GPIOR0_INIT=0x00

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer0_ovf_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_han:
	.DB  0x0,0xFE,0xFE,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0xF,0xC
	.DB  0xC,0xC,0xC,0xC,0x0,0x0,0x0,0x0
	.DB  0x0,0xFE,0xFE,0xE0,0xB0,0x18,0xC,0x6
	.DB  0x2,0x0,0x0,0x0,0x0,0xF,0xF,0x0
	.DB  0x1,0x3,0x6,0xC,0x8,0x0,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x44,0x38,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0xFC,0x40,0x40,0xFC,0x40,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0xF,0x0,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0xFC,0x4,0x4,0x4,0x4,0x4,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0x8,0x8,0x8,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x0,0xFC,0x84,0x84,0x84,0x84,0x84
	.DB  0x84,0x84,0x0,0x0,0x0,0x8,0x8,0x8
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x0
	.DB  0x0,0x4,0x4,0xFC,0x4,0x44,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xC,0x3,0x0
	.DB  0x3,0xC,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0x80,0xA4,0xA4,0xBC,0xA4,0xA4,0xBC
	.DB  0xA4,0xA4,0x80,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x13,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x0,0xFC,0x80
	.DB  0x80,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x0,0x1F,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x7C,0x48,0x48,0x48,0x48,0x7C,0x0
	.DB  0x0,0x7C,0x10,0x10,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x84,0x84,0x84,0x44,0x24,0x5C,0x48
	.DB  0x48,0xFC,0x0,0x0,0x0,0x0,0xC,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0xC,0x0,0x0
	.DB  0x0,0x7C,0x40,0x40,0x40,0x40,0x40,0x40
	.DB  0x0,0xFC,0x10,0x10,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x0,0xC0,0x30,0xC,0x30,0xC0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xE,0x1,0x1
	.DB  0x1,0x1,0x1,0xE,0x0,0x0,0x0,0x0
	.DB  0x0,0x1C,0xE0,0x0,0x0,0x0,0xE0,0x1C
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3
	.DB  0xC,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x44,0xB8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0xF,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x84,0x84,0x84,0x84,0x78,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xFC,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xF,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xF0,0x8,0x4,0x4,0x4,0x4,0x8
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x4,0x8
	.DB  0x8,0x8,0x8,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x10,0x8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x84,0x84,0x84,0x84,0x78,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xC0,0x30,0xC,0x30,0xC0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xE,0x1,0x1
	.DB  0x1,0x1,0x1,0xE,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x4,0x4,0x4,0x8,0xF0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0x8,0x4,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x84,0x84,0x18,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x6,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x4,0xC4,0x4,0x4,0xC4,0x4
	.DB  0x4,0xFC,0x0,0x0,0x0,0x8,0x8,0xF
	.DB  0x8,0x8,0xF,0x8,0xA,0x9,0x8,0x0
	.DB  0x0,0x80,0x98,0xA4,0xA4,0xA4,0xA4,0xA4
	.DB  0xA4,0x98,0x80,0x0,0x0,0x0,0x2,0x3
	.DB  0x2,0x2,0x2,0x2,0x3,0x1E,0x0,0x0
	.DB  0x0,0x4,0x84,0x64,0x1C,0x24,0x44,0x94
	.DB  0x10,0xFC,0x0,0x0,0x0,0x1,0x1C,0x10
	.DB  0x10,0x10,0x10,0x10,0x10,0x13,0x0,0x0
	.DB  0x0,0x0,0x3C,0x24,0x24,0x24,0x24,0x24
	.DB  0x24,0x3C,0x0,0x0,0x0,0x1,0x1D,0x11
	.DB  0x11,0x11,0x17,0x11,0x11,0x11,0x1,0x0
	.DB  0x0,0x84,0x84,0x84,0x44,0x24,0x1C,0x0
	.DB  0x0,0xFC,0x20,0x20,0x0,0x0,0xC,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0xC,0x0,0x0
	.DB  0x0,0x0,0x0,0x80,0x7C,0x80,0x0,0x0
	.DB  0x0,0xFC,0x80,0x80,0x0,0x8,0x6,0x1
	.DB  0x0,0x1,0x6,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x4,0x84,0x64,0x1C,0x24,0x44,0x94
	.DB  0x10,0xFC,0x0,0x0,0x0,0x1,0x1C,0x10
	.DB  0x10,0x10,0x10,0x10,0x10,0x13,0x0,0x0
	.DB  0x0,0x4,0x4,0x84,0x7C,0x84,0x4,0x4
	.DB  0x0,0xFC,0x80,0x80,0x0,0x8,0x6,0x1
	.DB  0x0,0x1,0x6,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x0,0xFC,0x80
	.DB  0x80,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x0,0x1F,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x7C,0x48,0x48,0x48,0x48,0x7C,0x0
	.DB  0x0,0x7C,0x10,0x10,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0x80,0x98,0xE4,0xA4,0xA4,0xA4,0xA4
	.DB  0xE4,0x98,0x80,0x0,0x0,0x0,0xC,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0xC,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x44,0x38,0x28
	.DB  0x28,0xFC,0x0,0x0,0x0,0x0,0x2,0x2
	.DB  0x2,0x2,0x2,0x2,0x2,0x1E,0x0,0x0
	.DB  0x0,0xFC,0x4,0x4,0x4,0x4,0xFC,0x0
	.DB  0x0,0xFC,0x80,0x80,0x0,0xF,0x8,0x8
	.DB  0x8,0x8,0xF,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x94,0x94,0x94,0x54,0x34,0x1C,0x10
	.DB  0x10,0xFC,0x0,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x4,0x4,0xFC,0x4,0x44,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xC,0x3,0x0
	.DB  0x3,0xC,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x40
	.DB  0x40,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x0,0x80,0x60,0x1C,0x20,0x40,0x80
	.DB  0x0,0xFC,0x0,0x0,0x0,0x1,0x1C,0x10
	.DB  0x10,0x10,0x10,0x10,0x10,0x13,0x0,0x0
	.DB  0x0,0x4,0x4,0xFC,0x4,0x44,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xC,0x3,0x0
	.DB  0x3,0xC,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0x80,0xA4,0xA4,0xBC,0xA4,0xA4,0xBC
	.DB  0xA4,0xA4,0x80,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x13,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x0,0xFC,0x80
	.DB  0x80,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x0,0x1F,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x7C,0x48,0x48,0x48,0x48,0x7C,0x0
	.DB  0x0,0x7C,0x10,0x10,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x44,0xB8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0xF,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x18,0x60,0x80,0x0,0x80,0x60
	.DB  0x18,0xFC,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x1,0x6,0x1,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x10,0x90,0x54,0x54,0x54,0x90,0x10
	.DB  0x0,0xFC,0x0,0x0,0x0,0x8,0x9,0xA
	.DB  0xE,0xA,0x9,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x0,0xE4,0x24,0x24,0x24,0x24,0x24
	.DB  0x24,0x3C,0x0,0x0,0x0,0x8,0x9,0x9
	.DB  0x9,0x9,0xF,0x9,0x9,0x9,0x8,0x0
	.DB  0x0,0x80,0x40,0x30,0x1C,0x20,0x50,0x10
	.DB  0x10,0x7C,0x0,0x0,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x10,0x10,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x1,0x1,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0x84,0x84,0xFC,0x84,0xFC,0x84,0x94
	.DB  0x10,0xFC,0x0,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x38,0x0,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0x1,0x9,0x7
	.DB  0x1,0x5,0x4,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x40
	.DB  0x40,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0xFC,0x84,0x84,0x84,0x84,0x78,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xF0,0x8,0x4,0x4,0x4,0x4,0x8
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x4,0x8
	.DB  0x8,0x8,0x8,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x44,0xB8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xE0,0x18,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0xC,0x10
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x4,0x18,0xE0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x10,0xC,0x3
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFC,0x90,0x90,0x90,0x90,0x90
	.DB  0x90,0xFC,0x0,0x0,0x0,0x8,0x8,0x8
	.DB  0x8,0x8,0xF,0x8,0x8,0x8,0x8,0x0
	.DB  0x0,0x0,0xFC,0x84,0x84,0x84,0x84,0x84
	.DB  0x84,0x84,0x0,0x0,0x0,0x8,0x8,0x8
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x0
_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

_0x81:
	.DB  0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x04
	.DW  _0x81*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30
	STS  XMCRA,R30
	STS  XMCRB,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	WDR
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	STS  WDTCSR,R31
	STS  WDTCSR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,LOW(__SRAM_START)
	LDI  R27,HIGH(__SRAM_START)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

	OUT  RAMPZ,R24

	OUT  EIND,R24

;GPIOR0 INITIALIZATION
	LDI  R30,__GPIOR0_INIT
	OUT  GPIOR0,R30

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x600

	.CSEG
;/*======================================================================================
;Project : ׷LCDȮ庸带 ̿  
;Version :
;Date    : 2011-07-28
;Author  : Kyung Nam Lee
;Company : LKEMBEDDED
;Compiler: CodevisionAVR + AVRStudio
;Comment: ׷LCDȮ庸带 ̿  
;
;ءǻסء
;10p  ̺  Ʒ  ּ!
;
;ATmega2560 Ȯ ߺ PORTC <-------------> ׷LCDȮ庸 - 10 ڽ Ŀ (PORT1)
;ATmega2560 Ȯ ߺ PORTD <-------------> ׷LCDȮ庸 - 10 ڽ Ŀ (PORT0)
;======================================================================================*/
;
;#include <mega2560.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.EQU __sm_adc_noise_red=0x02
	.SET power_ctrl_reg=smcr
	#endif
;#include <delay.h>
;#include <stdio.h>
;//---------------------------------------------
;#define lcd_dt PORTC
;#define RW     PORTD.1
;#define lcd_en PORTD.2
;#define lcd_di PORTD.0
;#define lcd_s2 PORTD.5
;#define lcd_s1 PORTD.4
;#define rst    PORTD.6
;//----------------------------------------------------
;unsigned char screen[8][128];
;bit flg;
;char bf;
;struct {
;   char bf, x, y, ty;
;}  lcd;
;bit lcd_pg, lcd_blk;
;flash char han[62][24]={
;
;0x00,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //L  0
;0x00,0x0f,0x0f,0x0c,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,
;
;
;0x00,0xfe,0xfe,0xe0,0xb0,0x18,0x0c,0x06,0x02,0x00,0x00,0x00, //K
;0x00,0x0f,0x0f,0x00,0x01,0x03,0x06,0x0c,0x08,0x00,0x00,0x00,
;
;
;0x00,0x38,0x44,0x44,0x44,0x44,0x38,0x00,0x00,0xfc,0x00,0x00, //  2
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0xfc,0x40,0x40,0xfc,0x40,0x40,0xfc,0x00,0xfc,0x00,0x00, //  3
;0x00,0x0f,0x08,0x08,0x0f,0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0xfc,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0xfc,0x00,0x00, //   4
;0x00,0x0f,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x00,0xfc,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x00,0x00, //   5
;0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
;
;0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, //   6
;0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0x80,0xa4,0xa4,0xbc,0xa4,0xa4,0xbc,0xa4,0xa4,0x80,0x00, //ǰ   7
;0x00,0x00,0x1e,0x12,0x12,0x12,0x13,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, //   8
;0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, //   9
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x00,0x00,0xfc,0x00,0x00, //   10
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x84,0x84,0x84,0x44,0x24,0x5c,0x48,0x48,0xfc,0x00,0x00, //   11
;0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,
;
;0x00,0x7c,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0xfc,0x10,0x10, //   12
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x00,0xc0,0x30,0x0c,0x30,0xc0,0x00,0x00,0x00,0x00,0x00, //A    13
;0x00,0x0e,0x01,0x01,0x01,0x01,0x01,0x0e,0x00,0x00,0x00,0x00,
;
;0x00,0x1c,0xe0,0x00,0x00,0x00,0xe0,0x1c,0x00,0x00,0x00,0x00, //V    14
;0x00,0x00,0x00,0x03,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, //R   15
;0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, //P   16
;0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00, //I   17
;0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xf0,0x08,0x04,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00, //C   18
;0x00,0x03,0x04,0x08,0x08,0x08,0x08,0x04,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //,   19
;0x00,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, //P   20
;0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0xc0,0x30,0x0c,0x30,0xc0,0x00,0x00,0x00,0x00,0x00, //A   21
;0x00,0x0e,0x01,0x01,0x01,0x01,0x01,0x0e,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x04,0x04,0x04,0x08,0xf0,0x00,0x00,0x00,0x00,0x00, //D    22
;0x00,0x0f,0x08,0x08,0x08,0x04,0x03,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x38,0x44,0x44,0x84,0x84,0x18,0x00,0x00,0x00,0x00,0x00, //S    23
;0x00,0x06,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0x04,0xc4,0x04,0x04,0xc4,0x04,0x04,0xfc,0x00,0x00, //   24
;0x00,0x08,0x08,0x0f,0x08,0x08,0x0f,0x08,0x0a,0x09,0x08,0x00,
;
;0x00,0x80,0x98,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0x98,0x80,0x00, //   25
;0x00,0x00,0x02,0x03,0x02,0x02,0x02,0x02,0x03,0x1e,0x00,0x00,
;
;0x00,0x04,0x84,0x64,0x1c,0x24,0x44,0x94,0x10,0xfc,0x00,0x00, //   26
;0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,
;
;0x00,0x00,0x3c,0x24,0x24,0x24,0x24,0x24,0x24,0x3c,0x00,0x00, //  27
;0x00,0x01,0x1d,0x11,0x11,0x11,0x17,0x11,0x11,0x11,0x01,0x00,
;
;
;0x00,0x84,0x84,0x84,0x44,0x24,0x1c,0x00,0x00,0xfc,0x20,0x20, //  28
;0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,
;
;0x00,0x00,0x00,0x80,0x7c,0x80,0x00,0x00,0x00,0xfc,0x80,0x80, //  29
;0x00,0x08,0x06,0x01,0x00,0x01,0x06,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x04,0x84,0x64,0x1c,0x24,0x44,0x94,0x10,0xfc,0x00,0x00, //  30
;0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,
;
;0x00,0x04,0x04,0x84,0x7c,0x84,0x04,0x04,0x00,0xfc,0x80,0x80, //   31
;0x00,0x08,0x06,0x01,0x00,0x01,0x06,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, //   32
;0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, //   33
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0x80,0x98,0xe4,0xa4,0xa4,0xa4,0xa4,0xe4,0x98,0x80,0x00, //   34
;0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,
;
;0x00,0x38,0x44,0x44,0x44,0x44,0x38,0x28,0x28,0xfc,0x00,0x00, //   35
;0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x1e,0x00,0x00,
;
;0x00,0xfc,0x04,0x04,0x04,0x04,0xfc,0x00,0x00,0xfc,0x80,0x80, //   36
;0x00,0x0f,0x08,0x08,0x08,0x08,0x0f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x00,0x00,0xfc,0x00,0x00, //   37
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x94,0x94,0x94,0x54,0x34,0x1c,0x10,0x10,0xfc,0x00,0x00, //   38
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, //   39
;0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x40,0x40,0xfc,0x00,0x00, //   40
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x00,0x80,0x60,0x1c,0x20,0x40,0x80,0x00,0xfc,0x00,0x00, //   41
;0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,
;
;0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, //   42
;0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0x80,0xa4,0xa4,0xbc,0xa4,0xa4,0xbc,0xa4,0xa4,0x80,0x00, //ǰ   43
;0x00,0x00,0x1e,0x12,0x12,0x12,0x13,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, //   44
;0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, //   45
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, //R    46
;0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x18,0x60,0x80,0x00,0x80,0x60,0x18,0xfc,0x00,0x00, //M    47
;0x00,0x0f,0x00,0x00,0x01,0x06,0x01,0x00,0x00,0x0f,0x00,0x00,
;
;0x00,0x10,0x90,0x54,0x54,0x54,0x90,0x10,0x00,0xfc,0x00,0x00, //ȸ   48
;0x00,0x08,0x09,0x0a,0x0e,0x0a,0x09,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x00,0xe4,0x24,0x24,0x24,0x24,0x24,0x24,0x3c,0x00,0x00, //   49
;0x00,0x08,0x09,0x09,0x09,0x09,0x0f,0x09,0x09,0x09,0x08,0x00,
;
;0x00,0x80,0x40,0x30,0x1c,0x20,0x50,0x10,0x10,0x7c,0x00,0x00, //   50
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x10,0x10,0xfc,0x00,0xfc,0x00,0x00, //   51
;0x00,0x08,0x04,0x03,0x00,0x01,0x01,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0x84,0x84,0xfc,0x84,0xfc,0x84,0x94,0x10,0xfc,0x00,0x00, //   52
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x38,0x44,0x44,0x44,0x38,0x00,0xfc,0x00,0xfc,0x00,0x00, //   53
;0x00,0x01,0x09,0x07,0x01,0x05,0x04,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x40,0x40,0xfc,0x00,0x00, //   54
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, //P    55
;0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xf0,0x08,0x04,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00, //C   56
;0x00,0x03,0x04,0x08,0x08,0x08,0x08,0x04,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, //B   57
;0x00,0x0f,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xe0,0x18,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //(   58
;0x00,0x03,0x0c,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x04,0x18,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //)   59
;0x00,0x10,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0xfc,0x90,0x90,0x90,0x90,0x90,0x90,0xfc,0x00,0x00, //    60
;0x00,0x08,0x08,0x08,0x08,0x08,0x0f,0x08,0x08,0x08,0x08,0x00,
;
;0x00,0x00,0xfc,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x00,0x00, //    61
;0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
;
;
;
;
;};
;char SecCnt=0;
;bit SecFlag;
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)// Timer 0 overflow interrupt service routine
; 0000 00EA {

	.CSEG
_timer0_ovf_isr:
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00EB     static unsigned int cnt=0;
; 0000 00EC     cnt++;
	LDI  R26,LOW(_cnt_S0000000000)
	LDI  R27,HIGH(_cnt_S0000000000)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 00ED     if(cnt>=1000)
	LDS  R26,_cnt_S0000000000
	LDS  R27,_cnt_S0000000000+1
	CPI  R26,LOW(0x3E8)
	LDI  R30,HIGH(0x3E8)
	CPC  R27,R30
	BRLO _0x3
; 0000 00EE     {
; 0000 00EF     SecCnt++;
	INC  R4
; 0000 00F0     SecFlag^=1;
	LDI  R26,0
	SBIC 0x1E,3
	LDI  R26,1
	LDI  R30,LOW(1)
	EOR  R30,R26
	BRNE _0x4
	CBI  0x1E,3
	RJMP _0x5
_0x4:
	SBI  0x1E,3
_0x5:
; 0000 00F1     cnt=0;
	LDI  R30,LOW(0)
	STS  _cnt_S0000000000,R30
	STS  _cnt_S0000000000+1,R30
; 0000 00F2         if(SecCnt>=10)
	LDI  R30,LOW(10)
	CP   R4,R30
	BRLO _0x6
; 0000 00F3         {
; 0000 00F4          SecCnt=0;
	CLR  R4
; 0000 00F5 
; 0000 00F6         }
; 0000 00F7     }
_0x6:
; 0000 00F8 
; 0000 00F9 
; 0000 00FA }
_0x3:
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	RETI
;//----------------------------------------------------
;char gbuf[128][8];
;//----------------------------------------------------
;//----------------------------------------------------
;void dsp_str(char n)
; 0000 0100 {
_dsp_str:
; 0000 0101    delay_us(30); lcd_di=1; lcd_dt=n; //data
;	n -> Y+0
	__DELAY_USB 160
	SBI  0xB,0
	LD   R30,Y
	OUT  0x8,R30
; 0000 0102    lcd_en=1; #asm("nop"); lcd_en=0;  //on->off
	SBI  0xB,2
	nop
	RJMP _0x2060002
; 0000 0103 }
;//----------------------------------------------------
;void dsp_cmd(char n)
; 0000 0106 {
_dsp_cmd:
; 0000 0107    delay_us(30); lcd_di=0; lcd_dt=n; //data
;	n -> Y+0
	__DELAY_USB 160
	CBI  0xB,0
	LD   R30,Y
	OUT  0x8,R30
; 0000 0108    lcd_en=1; #asm("nop"); lcd_en=0;  //on->off
	SBI  0xB,2
	nop
_0x2060002:
	CBI  0xB,2
; 0000 0109 }
	ADIW R28,1
	RET
;//----------------------------------------------------
;void lcd_init()
; 0000 010C {
_lcd_init:
; 0000 010D    lcd_s1=1;
	SBI  0xB,4
; 0000 010E    lcd_s2=1; //page0,1
	SBI  0xB,5
; 0000 010F    dsp_cmd(0x3f);
	LDI  R30,LOW(63)
	ST   -Y,R30
	RCALL _dsp_cmd
; 0000 0110    dsp_cmd(0xc0);
	LDI  R30,LOW(192)
	RJMP _0x2060001
; 0000 0111 }
;//----------------------------------------------------
;void set_page0() { lcd.x=0x40; lcd_pg=0; }
; 0000 0113 void set_page0() { lcd.x=0x40; lcd_pg=0; }
_set_page0:
	LDI  R30,LOW(64)
	__PUTB1MN _lcd,1
	CBI  0x1E,1
	RET
;void set_page1() { lcd.x=0x40; lcd_pg=1; }
; 0000 0114 void set_page1() { lcd.x=0x40; lcd_pg=1; }
_set_page1:
	LDI  R30,LOW(64)
	__PUTB1MN _lcd,1
	SBI  0x1E,1
	RET
;
;void dsp_addr()
; 0000 0117 {
_dsp_addr:
; 0000 0118    if(lcd_pg) { lcd_s1=0; lcd_s2=1; } //page1?
	SBIS 0x1E,1
	RJMP _0x1B
	CBI  0xB,4
	SBI  0xB,5
; 0000 0119    else       { lcd_s1=1; lcd_s2=0; } //page0
	RJMP _0x20
_0x1B:
	SBI  0xB,4
	CBI  0xB,5
_0x20:
; 0000 011A    dsp_cmd(lcd.y);
	__GETB1MN _lcd,2
	ST   -Y,R30
	RCALL _dsp_cmd
; 0000 011B    dsp_cmd(lcd.x);
	__GETB1MN _lcd,1
_0x2060001:
	ST   -Y,R30
	RCALL _dsp_cmd
; 0000 011C }
	RET
; void dsp_nul(char n)
; 0000 011E {
; 0000 011F    char i; dsp_addr();
;	n -> Y+1
;	i -> R17
; 0000 0120    for(i=0; i<n; ++i)///64  Ŭ Ų.
; 0000 0121    dsp_str(0);
; 0000 0122 }
;void dsp_nul2(char n)
; 0000 0124 {
_dsp_nul2:
; 0000 0125    char i;
; 0000 0126    dsp_addr(); // ǥ 
	ST   -Y,R17
;	n -> Y+1
;	i -> R17
	RCALL _dsp_addr
; 0000 0127    lcd.bf=0;  // ä
	LDI  R30,LOW(0)
	STS  _lcd,R30
; 0000 0128    if(lcd_blk)
	SBIS 0x1E,2
	RJMP _0x28
; 0000 0129    lcd.bf=~lcd.bf;
	CALL SUBOPT_0x0
; 0000 012A    for(i=0; i<n; ++i) //nŭ ϸ 
_0x28:
	LDI  R17,LOW(0)
_0x2A:
	LDD  R30,Y+1
	CP   R17,R30
	BRSH _0x2B
; 0000 012B     dsp_str(lcd.bf);
	CALL SUBOPT_0x1
	SUBI R17,-LOW(1)
	RJMP _0x2A
_0x2B:
; 0000 012C ++lcd.y;
	CALL SUBOPT_0x2
; 0000 012D     dsp_addr();
; 0000 012E     lcd.bf=0;
	LDI  R30,LOW(0)
	STS  _lcd,R30
; 0000 012F    if(lcd_blk)
	SBIS 0x1E,2
	RJMP _0x2C
; 0000 0130    { lcd.bf=~lcd.bf; lcd.bf&=~0x80; }
	CALL SUBOPT_0x0
	LDS  R30,_lcd
	ANDI R30,0x7F
	STS  _lcd,R30
; 0000 0131    for(i=0; i<n; ++i)
_0x2C:
	LDI  R17,LOW(0)
_0x2E:
	LDD  R30,Y+1
	CP   R17,R30
	BRSH _0x2F
; 0000 0132    dsp_str(lcd.bf);
	CALL SUBOPT_0x1
	SUBI R17,-LOW(1)
	RJMP _0x2E
_0x2F:
; 0000 0133 lcd.x+=n;
	__GETB1MN _lcd,1
	LDD  R26,Y+1
	ADD  R30,R26
	CALL SUBOPT_0x3
; 0000 0134    lcd.y=lcd.ty;
; 0000 0135 }
	LDD  R17,Y+0
	ADIW R28,2
	RET
;void lcd_clear()
; 0000 0137 {
; 0000 0138    char i;
; 0000 0139    lcd.x=0x40; lcd.y=0xb8;
;	i -> R17
; 0000 013A    for(i=0; i<8; ++i) {
; 0000 013B      lcd_pg=0;
; 0000 013C      dsp_nul(64);
; 0000 013D      lcd_pg=1;
; 0000 013E       dsp_nul(64);
; 0000 013F      ++lcd.y;
; 0000 0140 
; 0000 0141 
; 0000 0142    }
; 0000 0143 }
;void dsp_han(flash char *p, char n)
; 0000 0145 {
_dsp_han:
; 0000 0146    char i, bf1, bf2;
; 0000 0147    static int cnt=0;
; 0000 0148      static int cnt2=0;
; 0000 0149       static int cnt3=0;
; 0000 014A    bf1=n*12;//ù° ڿ ũ⸦ Ȯ
	CALL __SAVELOCR4
;	*p -> Y+5
;	n -> Y+4
;	i -> R17
;	bf1 -> R16
;	bf2 -> R19
	LDD  R30,Y+4
	LDI  R26,LOW(12)
	MULS R30,R26
	MOV  R16,R0
; 0000 014B    dsp_addr();/// ǥ Ȯ
	RCALL _dsp_addr
; 0000 014C    for(i=0; i<bf1; ++i) {  //ڿ ũ⸸ŭ  
	LDI  R17,LOW(0)
_0x38:
	CP   R17,R16
	BRSH _0x39
; 0000 014D       lcd.bf=p[i];
	CALL SUBOPT_0x4
; 0000 014E       if(lcd_blk) lcd.bf=~lcd.bf; //  
	SBIS 0x1E,2
	RJMP _0x3A
	CALL SUBOPT_0x0
; 0000 014F        dsp_str(lcd.bf); //Ÿ 
_0x3A:
	CALL SUBOPT_0x1
; 0000 0150    }
	SUBI R17,-LOW(1)
	RJMP _0x38
_0x39:
; 0000 0151     bf2=bf1*2;  //2°  ũ 
	MOV  R30,R16
	LSL  R30
	MOV  R19,R30
; 0000 0152     ++lcd.y; //lcd y adrees 0xb9 2°  
	CALL SUBOPT_0x2
; 0000 0153     dsp_addr(); /// ǥ Ȯ
; 0000 0154    for(i=bf1; i<bf2; ++i) {
	MOV  R17,R16
_0x3C:
	CP   R17,R19
	BRSH _0x3D
; 0000 0155       lcd.bf=p[i];
	CALL SUBOPT_0x4
; 0000 0156       if(lcd_blk)
	SBIS 0x1E,2
	RJMP _0x3E
; 0000 0157        { lcd.bf=~lcd.bf; lcd.bf&=~0x80; }
	CALL SUBOPT_0x0
	LDS  R30,_lcd
	ANDI R30,0x7F
	STS  _lcd,R30
; 0000 0158         dsp_str(lcd.bf);
_0x3E:
	CALL SUBOPT_0x1
; 0000 0159    }
	SUBI R17,-LOW(1)
	RJMP _0x3C
_0x3D:
; 0000 015A 
; 0000 015B    lcd.x+=bf1; //lcd y address  0x4c مd ,   ǥ  
	__GETB1MN _lcd,1
	ADD  R30,R16
	CALL SUBOPT_0x3
; 0000 015C    lcd.y=lcd.ty; //lcd xǥ 0xb8 
; 0000 015D }
	CALL __LOADLOCR4
	ADIW R28,7
	RET
;void first()
; 0000 015F {
_first:
; 0000 0160     set_page0();
	RCALL _set_page0
; 0000 0161     lcd.ty=lcd.y=0xb8;///ù° 
	CALL SUBOPT_0x5
; 0000 0162     lcd_blk=1;
; 0000 0163     dsp_nul2(28);
	CALL SUBOPT_0x6
; 0000 0164     dsp_han(han[0],1);
	LDI  R30,LOW(_han*2)
	LDI  R31,HIGH(_han*2)
	CALL SUBOPT_0x7
; 0000 0165     dsp_han(han[1],1);
	__POINTW1FN _han,24
	CALL SUBOPT_0x7
; 0000 0166     dsp_han(han[2],1);
	__POINTW1FN _han,48
	CALL SUBOPT_0x7
; 0000 0167 
; 0000 0168     set_page1();
	RCALL _set_page1
; 0000 0169     lcd.ty=lcd.y=0xb8;
	CALL SUBOPT_0x5
; 0000 016A     lcd_blk=1;
; 0000 016B     dsp_han(han[3],1);
	__POINTW1FN _han,72
	CALL SUBOPT_0x7
; 0000 016C     dsp_han(han[4],1);
	__POINTW1FN _han,96
	CALL SUBOPT_0x7
; 0000 016D     dsp_han(han[5],1); dsp_nul2(28);
	__POINTW1FN _han,120
	CALL SUBOPT_0x7
	CALL SUBOPT_0x6
; 0000 016E 
; 0000 016F }
	RET
;void second()
; 0000 0171 {
_second:
; 0000 0172     switch(SecCnt)
	MOV  R30,R4
	LDI  R31,0
; 0000 0173     {
; 0000 0174     case 0: //avr
	SBIW R30,0
	BRNE _0x46
; 0000 0175     set_page0();
	CALL SUBOPT_0x8
; 0000 0176     lcd.ty=lcd.y=0xba; //2° 
; 0000 0177     lcd_blk=0;
; 0000 0178     dsp_nul2(16);
; 0000 0179     dsp_han(han[30],1);
	__POINTW1FN _han,720
	CALL SUBOPT_0x7
; 0000 017A     dsp_han(han[31],1);
	__POINTW1FN _han,744
	CALL SUBOPT_0x7
; 0000 017B     dsp_han(han[32],1);
	__POINTW1FN _han,768
	CALL SUBOPT_0x7
; 0000 017C     dsp_han(han[33],1);
	__POINTW1FN _han,792
	CALL SUBOPT_0x7
; 0000 017D     set_page1();
	CALL SUBOPT_0x9
; 0000 017E     lcd.ty=lcd.y=0xba;
; 0000 017F     lcd_blk=0;
; 0000 0180     dsp_han(han[34],1);
	__POINTW1FN _han,816
	CALL SUBOPT_0x7
; 0000 0181     dsp_han(han[35],1);
	__POINTW1FN _han,840
	CALL SUBOPT_0x7
; 0000 0182     dsp_han(han[26],1);
	CALL SUBOPT_0xA
; 0000 0183     dsp_han(han[27],1);
	CALL SUBOPT_0xB
; 0000 0184     dsp_nul2(16);
	LDI  R30,LOW(16)
	RJMP _0x7F
; 0000 0185     break;
; 0000 0186     case 5:
_0x46:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0x45
; 0000 0187     set_page0();
	CALL SUBOPT_0x8
; 0000 0188     lcd.ty=lcd.y=0xba; //2° 
; 0000 0189     lcd_blk=0;
; 0000 018A     dsp_nul2(16);
; 0000 018B     dsp_han(han[36],1);
	__POINTW1FN _han,864
	CALL SUBOPT_0x7
; 0000 018C     dsp_han(han[37],1);
	__POINTW1FN _han,888
	CALL SUBOPT_0x7
; 0000 018D     dsp_han(han[38],1);
	__POINTW1FN _han,912
	CALL SUBOPT_0x7
; 0000 018E     dsp_han(han[39],1);
	__POINTW1FN _han,936
	CALL SUBOPT_0x7
; 0000 018F     set_page1();
	CALL SUBOPT_0x9
; 0000 0190     lcd.ty=lcd.y=0xba;
; 0000 0191     lcd_blk=0;
; 0000 0192      dsp_han(han[40],1);
	__POINTW1FN _han,960
	CALL SUBOPT_0x7
; 0000 0193     dsp_han(han[60],1);
	__POINTW1FN _han,1440
	CALL SUBOPT_0x7
; 0000 0194     dsp_han(han[61],1);
	__POINTW1FN _han,1464
	CALL SUBOPT_0x7
; 0000 0195     dsp_han(han[44],1);
	__POINTW1FN _han,1056
	CALL SUBOPT_0x7
; 0000 0196     dsp_han(han[45],1);
	__POINTW1FN _han,1080
	CALL SUBOPT_0x7
; 0000 0197     dsp_nul2(3);
	LDI  R30,LOW(3)
_0x7F:
	ST   -Y,R30
	RCALL _dsp_nul2
; 0000 0198     break;
; 0000 0199     }
_0x45:
; 0000 019A 
; 0000 019B 
; 0000 019C }
	RET
;
;void third()
; 0000 019F {
_third:
; 0000 01A0     switch(SecCnt)
	MOV  R30,R4
	LDI  R31,0
; 0000 01A1     {
; 0000 01A2     case 0: //avr
	SBIW R30,0
	BRNE _0x53
; 0000 01A3     set_page0();
	CALL SUBOPT_0xC
; 0000 01A4     lcd.ty=lcd.y=0xbc; //3° 
; 0000 01A5     lcd_blk=1;
; 0000 01A6      dsp_nul2(4);
; 0000 01A7     dsp_han(han[13],1);
	__POINTW1FN _han,312
	CALL SUBOPT_0x7
; 0000 01A8     dsp_han(han[14],1);
	__POINTW1FN _han,336
	CALL SUBOPT_0x7
; 0000 01A9     dsp_han(han[15],1);
	__POINTW1FN _han,360
	CALL SUBOPT_0x7
; 0000 01AA     dsp_han(han[52],1);
	CALL SUBOPT_0xD
; 0000 01AB     dsp_han(han[53],1);
	CALL SUBOPT_0xE
; 0000 01AC     set_page1();
	CALL SUBOPT_0xF
; 0000 01AD     lcd.ty=lcd.y=0xbc;
; 0000 01AE     lcd_blk=1;
; 0000 01AF 
; 0000 01B0     dsp_han(han[54],1);
; 0000 01B1     dsp_han(han[26],1);
	CALL SUBOPT_0xA
; 0000 01B2     dsp_han(han[27],1);
	CALL SUBOPT_0xB
; 0000 01B3     dsp_han(han[24],1);
	CALL SUBOPT_0x10
; 0000 01B4     dsp_han(han[25],1);
	CALL SUBOPT_0x11
; 0000 01B5     dsp_nul2(5);
	CALL SUBOPT_0x12
; 0000 01B6     break;
	RJMP _0x52
; 0000 01B7 
; 0000 01B8     case 2: //pic
_0x53:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x58
; 0000 01B9     set_page0();
	CALL SUBOPT_0xC
; 0000 01BA     lcd.ty=lcd.y=0xbc; //3° 
; 0000 01BB     lcd_blk=1;
; 0000 01BC      dsp_nul2(4);
; 0000 01BD     dsp_han(han[16],1);
	__POINTW1FN _han,384
	CALL SUBOPT_0x7
; 0000 01BE     dsp_han(han[17],1);
	__POINTW1FN _han,408
	CALL SUBOPT_0x7
; 0000 01BF     dsp_han(han[18],1);
	__POINTW1FN _han,432
	CALL SUBOPT_0x7
; 0000 01C0     dsp_han(han[52],1);
	CALL SUBOPT_0xD
; 0000 01C1     dsp_han(han[53],1);
	CALL SUBOPT_0xE
; 0000 01C2     set_page1();
	CALL SUBOPT_0xF
; 0000 01C3     lcd.ty=lcd.y=0xbc;
; 0000 01C4     lcd_blk=1;
; 0000 01C5 
; 0000 01C6     dsp_han(han[54],1);
; 0000 01C7     dsp_han(han[26],1);
	CALL SUBOPT_0xA
; 0000 01C8     dsp_han(han[27],1);
	CALL SUBOPT_0xB
; 0000 01C9     dsp_han(han[24],1);
	CALL SUBOPT_0x10
; 0000 01CA     dsp_han(han[25],1);
	CALL SUBOPT_0x11
; 0000 01CB     dsp_nul2(5);
	CALL SUBOPT_0x12
; 0000 01CC     break;
	RJMP _0x52
; 0000 01CD     case 4: //arm
_0x58:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x5D
; 0000 01CE     set_page0();
	CALL SUBOPT_0xC
; 0000 01CF     lcd.ty=lcd.y=0xbc; //3° 
; 0000 01D0     lcd_blk=1;
; 0000 01D1      dsp_nul2(4);
; 0000 01D2     dsp_han(han[21],1);
	__POINTW1FN _han,504
	CALL SUBOPT_0x7
; 0000 01D3     dsp_han(han[46],1);
	__POINTW1FN _han,1104
	CALL SUBOPT_0x7
; 0000 01D4     dsp_han(han[47],1);
	__POINTW1FN _han,1128
	CALL SUBOPT_0x7
; 0000 01D5     dsp_han(han[52],1);
	CALL SUBOPT_0xD
; 0000 01D6     dsp_han(han[53],1);
	CALL SUBOPT_0xE
; 0000 01D7     set_page1();
	CALL SUBOPT_0xF
; 0000 01D8     lcd.ty=lcd.y=0xbc;
; 0000 01D9     lcd_blk=1;
; 0000 01DA 
; 0000 01DB     dsp_han(han[54],1);
; 0000 01DC     dsp_han(han[26],1);
	CALL SUBOPT_0xA
; 0000 01DD     dsp_han(han[27],1);
	CALL SUBOPT_0xB
; 0000 01DE     dsp_han(han[24],1);
	CALL SUBOPT_0x10
; 0000 01DF     dsp_han(han[25],1);
	CALL SUBOPT_0x11
; 0000 01E0     dsp_nul2(5);
	CALL SUBOPT_0x12
; 0000 01E1     break;
	RJMP _0x52
; 0000 01E2 
; 0000 01E3     case 6: //pcb
_0x5D:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0x62
; 0000 01E4     set_page0();
	CALL SUBOPT_0xC
; 0000 01E5     lcd.ty=lcd.y=0xbc; //3° 
; 0000 01E6     lcd_blk=1;
; 0000 01E7      dsp_nul2(4);
; 0000 01E8     dsp_han(han[55],1);
	__POINTW1FN _han,1320
	CALL SUBOPT_0x7
; 0000 01E9     dsp_han(han[56],1);
	__POINTW1FN _han,1344
	CALL SUBOPT_0x7
; 0000 01EA     dsp_han(han[57],1);
	__POINTW1FN _han,1368
	CALL SUBOPT_0x7
; 0000 01EB     dsp_han(han[50],1);
	__POINTW1FN _han,1200
	CALL SUBOPT_0x7
; 0000 01EC     dsp_han(han[51],1);
	__POINTW1FN _han,1224
	CALL SUBOPT_0x7
; 0000 01ED     set_page1();
	CALL SUBOPT_0x13
; 0000 01EE     lcd.ty=lcd.y=0xbc;
; 0000 01EF     lcd_blk=1;
; 0000 01F0 
; 0000 01F1     dsp_han(han[26],1);
	CALL SUBOPT_0xA
; 0000 01F2     dsp_han(han[27],1);
	CALL SUBOPT_0xB
; 0000 01F3     dsp_han(han[24],1);
	CALL SUBOPT_0x10
; 0000 01F4     dsp_han(han[25],1);
	CALL SUBOPT_0x11
; 0000 01F5  //   dsp_han(han[25],1);
; 0000 01F6     dsp_nul2(15);
	LDI  R30,LOW(15)
	ST   -Y,R30
	RCALL _dsp_nul2
; 0000 01F7     break;
	RJMP _0x52
; 0000 01F8 
; 0000 01F9      case 8: //pcb
_0x62:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0x52
; 0000 01FA     set_page0();
	CALL SUBOPT_0xC
; 0000 01FB     lcd.ty=lcd.y=0xbc; //3° 
; 0000 01FC     lcd_blk=1;
; 0000 01FD      dsp_nul2(4);
; 0000 01FE     dsp_han(han[30],1);
	__POINTW1FN _han,720
	CALL SUBOPT_0x7
; 0000 01FF     dsp_han(han[31],1);
	__POINTW1FN _han,744
	CALL SUBOPT_0x7
; 0000 0200     dsp_han(han[48],1);
	__POINTW1FN _han,1152
	CALL SUBOPT_0x7
; 0000 0201     dsp_han(han[49],1);
	__POINTW1FN _han,1176
	CALL SUBOPT_0x7
; 0000 0202     dsp_han(han[50],1);
	__POINTW1FN _han,1200
	CALL SUBOPT_0x7
; 0000 0203     set_page1();
	CALL SUBOPT_0x13
; 0000 0204     lcd.ty=lcd.y=0xbc;
; 0000 0205     lcd_blk=1;
; 0000 0206 
; 0000 0207     dsp_han(han[51],1);
	__POINTW1FN _han,1224
	CALL SUBOPT_0x7
; 0000 0208     dsp_han(han[26],1);
	CALL SUBOPT_0xA
; 0000 0209     dsp_han(han[27],1);
	CALL SUBOPT_0xB
; 0000 020A     dsp_han(han[24],1);
	CALL SUBOPT_0x10
; 0000 020B     dsp_han(han[25],1);
	CALL SUBOPT_0x11
; 0000 020C     //dsp_nul2(15);
; 0000 020D     break;
; 0000 020E     }
_0x52:
; 0000 020F 
; 0000 0210 }
	RET
;
;void fourth()
; 0000 0213 {
_fourth:
; 0000 0214 
; 0000 0215 
; 0000 0216    switch(SecFlag)
	LDI  R30,0
	SBIC 0x1E,3
	LDI  R30,1
; 0000 0217    {
; 0000 0218    case 0:
	CPI  R30,0
	BRNE _0x6F
; 0000 0219     set_page0();
	CALL SUBOPT_0x14
; 0000 021A     lcd.ty=lcd.y=0xbe; //4° 
; 0000 021B     lcd_blk=1;
	SBI  0x1E,2
; 0000 021C     dsp_nul2(40);
	CALL SUBOPT_0x15
; 0000 021D     dsp_han(han[10],1);
; 0000 021E     dsp_han(han[11],1);
	__POINTW1FN _han,264
	CALL SUBOPT_0x7
; 0000 021F 
; 0000 0220     set_page1();
	CALL SUBOPT_0x16
; 0000 0221     lcd.ty=lcd.y=0xbe;
; 0000 0222     lcd_blk=1;
	SBI  0x1E,2
; 0000 0223 
; 0000 0224     dsp_han(han[12],1);
	RJMP _0x80
; 0000 0225     dsp_nul2(1);
; 0000 0226     dsp_han(han[28],1);
; 0000 0227     dsp_han(han[29],1);
; 0000 0228     dsp_nul2(28);
; 0000 0229     break;
; 0000 022A     case 1:
_0x6F:
	CPI  R30,LOW(0x1)
	BRNE _0x6E
; 0000 022B     set_page0();
	CALL SUBOPT_0x14
; 0000 022C     lcd.ty=lcd.y=0xbe; //4° 
; 0000 022D     lcd_blk=0;
	CBI  0x1E,2
; 0000 022E     dsp_nul2(40);
	CALL SUBOPT_0x15
; 0000 022F     dsp_han(han[10],1);
; 0000 0230     dsp_han(han[11],1);
	__POINTW1FN _han,264
	CALL SUBOPT_0x7
; 0000 0231 
; 0000 0232     set_page1();
	CALL SUBOPT_0x16
; 0000 0233     lcd.ty=lcd.y=0xbe;
; 0000 0234     lcd_blk=0;
	CBI  0x1E,2
; 0000 0235     dsp_han(han[12],1);
_0x80:
	__POINTW1FN _han,288
	CALL SUBOPT_0x7
; 0000 0236     dsp_nul2(1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _dsp_nul2
; 0000 0237     dsp_han(han[28],1);
	__POINTW1FN _han,672
	CALL SUBOPT_0x7
; 0000 0238     dsp_han(han[29],1);
	__POINTW1FN _han,696
	CALL SUBOPT_0x7
; 0000 0239     dsp_nul2(28);
	CALL SUBOPT_0x6
; 0000 023A     break;
; 0000 023B     }
_0x6E:
; 0000 023C 
; 0000 023D 
; 0000 023E }
	RET
;void main()
; 0000 0240 {
_main:
; 0000 0241 
; 0000 0242     DDRC=0xFF;      //׷LCD Ȯ庸 ͹  
	LDI  R30,LOW(255)
	OUT  0x7,R30
; 0000 0243     DDRD=0xFF;      //׷LCD Ȯ庸 (Control) (rst, lcd_s1, lcd_s2, lcd_di, lcd_en, RW)
	OUT  0xA,R30
; 0000 0244     rst=1;          //LCD Ȯ庸  Normal Mode High(5V) ΰ 
	SBI  0xB,6
; 0000 0245     bf=0x0f;
	LDI  R30,LOW(15)
	MOV  R5,R30
; 0000 0246     //---------------Ÿ̸/ī ͷƮ ʱȭ!
; 0000 0247     TCCR0A=0x00;    //Normal Mode Operation(Overflow Interrupt Enable)
	LDI  R30,LOW(0)
	OUT  0x24,R30
; 0000 0248     TCCR0B=0x03;    //64Prescale Select
	LDI  R30,LOW(3)
	OUT  0x25,R30
; 0000 0249     TCNT0=0x06;     // Timer/Count Register initialization
	LDI  R30,LOW(6)
	OUT  0x26,R30
; 0000 024A     TIMSK0=0x01;    // Timer(s)/Counter(s) Interrupt(s) initialization
	LDI  R30,LOW(1)
	STS  110,R30
; 0000 024B     lcd_init();     //׷LCD Ȯ庸 ʱȭ
	RCALL _lcd_init
; 0000 024C      #asm("sei")     // Global enable interrupts
	sei
; 0000 024D    while(1) {
_0x7B:
; 0000 024E        first();     //׷LCD ù° 
	RCALL _first
; 0000 024F        second();    //׷LCD ι° 
	RCALL _second
; 0000 0250        fourth();    //׷LCD ° 
	RCALL _fourth
; 0000 0251        third();     //׷LCD ׹° 
	RCALL _third
; 0000 0252      }
	RJMP _0x7B
; 0000 0253 
; 0000 0254    }
_0x7E:
	RJMP _0x7E
;
;
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.EQU __sm_adc_noise_red=0x02
	.SET power_ctrl_reg=smcr
	#endif

	.CSEG

	.CSEG

	.CSEG

	.DSEG
_lcd:
	.BYTE 0x4
_cnt_S0000000000:
	.BYTE 0x2

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x0:
	LDS  R30,_lcd
	COM  R30
	STS  _lcd,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x1:
	LDS  R30,_lcd
	ST   -Y,R30
	JMP  _dsp_str

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x2:
	__GETB1MN _lcd,2
	SUBI R30,-LOW(1)
	__PUTB1MN _lcd,2
	JMP  _dsp_addr

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x3:
	__PUTB1MN _lcd,1
	__GETB1MN _lcd,3
	__PUTB1MN _lcd,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x4:
	MOV  R30,R17
	LDD  R26,Y+5
	LDD  R27,Y+5+1
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R0,Z
	STS  _lcd,R0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5:
	LDI  R30,LOW(184)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x6:
	LDI  R30,LOW(28)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 79 TIMES, CODE SIZE REDUCTION:309 WORDS
SUBOPT_0x7:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	JMP  _dsp_han

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x8:
	CALL _set_page0
	LDI  R30,LOW(186)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	CBI  0x1E,2
	LDI  R30,LOW(16)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x9:
	CALL _set_page1
	LDI  R30,LOW(186)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	CBI  0x1E,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0xA:
	__POINTW1FN _han,624
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0xB:
	__POINTW1FN _han,648
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:37 WORDS
SUBOPT_0xC:
	CALL _set_page0
	LDI  R30,LOW(188)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,2
	LDI  R30,LOW(4)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xD:
	__POINTW1FN _han,1248
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xE:
	__POINTW1FN _han,1272
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0xF:
	CALL _set_page1
	LDI  R30,LOW(188)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,2
	__POINTW1FN _han,1296
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x10:
	__POINTW1FN _han,576
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x11:
	__POINTW1FN _han,600
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x12:
	LDI  R30,LOW(5)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x13:
	CALL _set_page1
	LDI  R30,LOW(188)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x14:
	CALL _set_page0
	LDI  R30,LOW(190)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x15:
	LDI  R30,LOW(40)
	ST   -Y,R30
	CALL _dsp_nul2
	__POINTW1FN _han,240
	RJMP SUBOPT_0x7

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x16:
	CALL _set_page1
	LDI  R30,LOW(190)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	RET


	.CSEG
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
