
#pragma used+
sfrb PINA=0;
sfrb DDRA=1;
sfrb PORTA=2;
sfrb PINB=3;
sfrb DDRB=4;
sfrb PORTB=5;
sfrb PINC=6;
sfrb DDRC=7;
sfrb PORTC=8;
sfrb PIND=9;
sfrb DDRD=0xa;
sfrb PORTD=0xb;
sfrb PINE=0xc;
sfrb DDRE=0xd;
sfrb PORTE=0xe;
sfrb PINF=0xf;
sfrb DDRF=0x10;
sfrb PORTF=0x11;
sfrb PING=0x12;
sfrb DDRG=0x13;
sfrb PORTG=0x14;
sfrb TIFR0=0x15;
sfrb TIFR1=0x16;
sfrb TIFR2=0x17;
sfrb TIFR3=0x18;
sfrb TIFR4=0x19;
sfrb TIFR5=0x1a;
sfrb PCIFR=0x1b;
sfrb EIFR=0x1c;
sfrb EIMSK=0x1d;
sfrb GPIOR0=0x1e;
sfrb EECR=0x1f;
sfrb EEDR=0x20;
sfrb EEARL=0x21;
sfrb EEARH=0x22;
sfrw EEAR=0X21;   
sfrb GTCCR=0x23;
sfrb TCCR0A=0x24;
sfrb TCCR0B=0x25;
sfrb TCNT0=0x26;
sfrb OCR0A=0x27;
sfrb OCR0B=0x28;
sfrb GPIOR1=0x2a;
sfrb GPIOR2=0x2b;
sfrb SPCR=0x2c;
sfrb SPSR=0x2d;
sfrb SPDR=0x2e;
sfrb ACSR=0x30;
sfrb OCDR=0x31;
sfrb SMCR=0x33;
sfrb MCUSR=0x34;
sfrb MCUCR=0x35;
sfrb SPMCSR=0x37;
sfrb RAMPZ=0x3b;
sfrb EIND=0x3c;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-

#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.EQU __sm_adc_noise_red=0x02
	.SET power_ctrl_reg=smcr
	#endif
#endasm

#pragma used+

void delay_us(unsigned int n);
void delay_ms(unsigned int n);

#pragma used-

char vertical[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
char english[28][8]={
0xe7,0xdb,0xbd,0xbd,0x81,0xbd,0xbd,0xbd,     
0xc1,0xbd,0xbd,0xc1,0xdd,0xbd,0xbd,0xc1,     
0xc3,0xbd,0xfd,0xfd,0xfd,0xbd,0xbd,0xc3,     
0xc1,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xc1,     
0x81,0xfd,0xfd,0x81,0xfd,0xfd,0xfd,0x81,     
0x81,0xfd,0xfd,0x81,0xfd,0xfd,0xfd,0xfd,     
0xe7,0xd9,0xbd,0xfd,0x8d,0xbd,0xdb,0xe7,     
0xbd,0xbd,0xbd,0x81,0xbd,0xbd,0xbd,0xbd,     
0xc3,0xe7,0xe7,0xe7,0xe7,0xe7,0xe7,0xc3,     
0xc3,0xe7,0xe7,0xe7,0xe7,0xe5,0xf5,0xfb,     
0xdd,0xed,0xf5,0xf9,0xf5,0xed,0xdd,0xbd,     
0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0x81,     
0xbd,0x99,0xa5,0xa5,0xa5,0xbd,0xbd,0xbd,     
0xbd,0xbd,0xb9,0xb5,0xad,0x9d,0xbd,0xbd,     
0xe7,0xdb,0xbd,0xbd,0xbd,0xbd,0xdb,0xe7,     
0xe1,0xdd,0xdd,0xdd,0xe1,0xfd,0xfd,0xfd,     
0xe3,0xdd,0xdd,0xdd,0xd5,0xcd,0xc3,0xbf,     
0xc1,0xbd,0xbd,0xc1,0xdd,0xbd,0xbd,0xbd,     
0xc3,0xbd,0xfd,0xc3,0xbf,0xbf,0xbd,0xc3,     
0x81,0xe7,0xe7,0xe7,0xe7,0xe7,0xe7,0xe7,     
0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xc3,     
0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xdb,0xe7,     
0xbd,0xbd,0xbd,0xbd,0xa5,0xa5,0xa5,0x99,     
0xbd,0xbd,0xd9,0xe7,0xe7,0xdb,0xbd,0xbd,     
0xbd,0xbd,0xbd,0xdb,0xe7,0xe7,0xe7,0xe7,     
0x81,0xbf,0xdf,0xef,0xf7,0xfb,0xfd,0x81,     
};
int Toggle=0;
int num_cnt=0;

interrupt [24] void timer0_ovf_isr(void)
{
static int cnt=0;
cnt++;
if(cnt==500)
{
num_cnt++;
cnt=0;         
if(num_cnt==27)
{   
Toggle++;
if(Toggle==3)
Toggle=0;
num_cnt=0;
}
}

TCNT0+=6;
}

void main(void)
{

PORTC=0xFF;
DDRC=0xFF;       

PORTD=0xFF;
DDRD=0xFF;

TCCR0A=0x00;
TCCR0B=0x03;
TCNT0=0x06;

(*(unsigned char *) 0x6e)=0x01;
#asm("sei")
while(1)
{
int i=0;
static int j=0;  
for(i=0;i<8;i++)
{
switch(Toggle)
{
case 0:

PORTD=0XFE;                 
PORTC=english[num_cnt][i];
PORTD=0XFF;                 

PORTD=0XFD;
PORTC=0XFF;
PORTD=0XFF;

PORTD=0XFB;
PORTC=vertical[i];
PORTD=0XFF;
delay_ms(1); 
break;  

case 1:

PORTD=0XFE;
PORTC=0xff;
PORTD=0XFF;

PORTD=0XFD;                 
PORTC=english[num_cnt][i];
PORTD=0XFF;                 

PORTD=0XFB;             
PORTC=vertical[i];
PORTD=0XFF;             
delay_ms(1);             

break;  

case 2:

PORTD=0XFE;
PORTC=english[num_cnt][i];
PORTD=0XFF;

PORTD=0XFD;                 
PORTC=english[num_cnt][i];
PORTD=0XFF;                 

PORTD=0XFB;             
PORTC=vertical[i];
PORTD=0XFF;             
delay_ms(1);             

break;
}
}  

}
}
