
;CodeVisionAVR C Compiler V2.05.0 Professional
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega2560
;Program type             : Application
;Clock frequency          : 16.000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 2048 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega2560
	#pragma AVRPART MEMORY PROG_FLASH 262144
	#pragma AVRPART MEMORY EEPROM 4096
	#pragma AVRPART MEMORY INT_SRAM SIZE 8703
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x200

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU EECR=0x1F
	.EQU EEDR=0x20
	.EQU EEARL=0x21
	.EQU EEARH=0x22
	.EQU SPSR=0x2D
	.EQU SPDR=0x2E
	.EQU SMCR=0x33
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU WDTCSR=0x60
	.EQU UCSR0A=0xC0
	.EQU UDR0=0xC6
	.EQU RAMPZ=0x3B
	.EQU EIND=0x3C
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU XMCRA=0x74
	.EQU XMCRB=0x75
	.EQU GPIOR0=0x1E

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0200
	.EQU __SRAM_END=0x21FF
	.EQU __DSTACK_SIZE=0x0800
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _Pulse=R4
	.DEF _Dir=R5
	.DEF _Pulse_cnt=R7
	.DEF _DCMotorduty=R9
	.DEF _MotorDir=R11
	.DEF _timeCnt=R13
	.DEF _bf=R3

;GPIOR0 INITIALIZATION VALUE
	.EQU __GPIOR0_INIT=0x00

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer2_ovf_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer0_ovf_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_row:
	.DB  0x1,0x0,0x2,0x0,0x4,0x0,0x8,0x0
	.DB  0x10,0x0,0x20,0x0,0x40,0x0,0x80,0x0
	.DB  0x0,0x1,0x0,0x2,0x0,0x4,0x0,0x8
	.DB  0x0,0x10,0x0,0x20,0x0,0x40,0x0,0x80
_str5:
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF6,0xFF,0xF6
	.DB  0xFF,0xF6,0xFF,0xF6,0xFF,0xF6,0x7F,0xC7
	.DB  0x7F,0xF7,0xBF,0xF7,0xDF,0xF7,0xE7,0xF7
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xF7,0xF7,0xF7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xC7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0x7,0xF4
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF6,0xF7,0xF7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xC7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0x7,0xF4
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF6,0xFF,0xF6
	.DB  0xFF,0xF6,0xFF,0xF6,0x7,0xF6,0xF7,0xC7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0x7,0xF4
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF6,0xF7,0xF6
	.DB  0xF7,0xF6,0xF7,0xF6,0xF7,0xF6,0xF7,0xC6
	.DB  0xF7,0xF6,0xF7,0xF6,0xF7,0xF6,0x7,0xF6
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xF6,0xF7,0xF6
	.DB  0xF7,0xF6,0xF7,0xF6,0x7,0xF6,0xF7,0xC6
	.DB  0xF7,0xF6,0xF7,0xF6,0xF7,0xF6,0x7,0xF6
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xBF,0xF7,0xBF,0xF7
	.DB  0xBF,0xF7,0xBF,0xF7,0xBF,0xF7,0x5F,0xC7
	.DB  0x5F,0xF7,0xEF,0xF6,0xEF,0xF6,0xF7,0xF5
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF,0xF7,0xF7,0xF6
	.DB  0xF7,0xF6,0xF7,0xF6,0xF7,0xF6,0xF7,0xC6
	.DB  0xF7,0xF6,0xF7,0xF6,0xF7,0xF6,0xF,0xF7
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF4,0xBF,0xF7
	.DB  0xBF,0xF7,0xBF,0xF7,0xBF,0xF7,0x5F,0xC7
	.DB  0x5F,0xF7,0xEF,0xF6,0xEF,0xF6,0xF7,0xF5
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF6,0xFF,0xF6
	.DB  0xFF,0xF6,0xFF,0xF6,0x7,0xF6,0x7F,0xC7
	.DB  0x7F,0xF7,0xBF,0xF7,0xDF,0xF7,0xE7,0xF7
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x1F,0xF7,0xFF,0xF7
	.DB  0x7,0xF4,0xBF,0xF7,0xBF,0xF7,0xBF,0xC7
	.DB  0x5F,0xF7,0xDF,0xF6,0xEF,0xF5,0xF7,0xF7
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF6,0xF7,0xF7
	.DB  0xF7,0xF7,0xF7,0xF7,0x7,0xF6,0xF7,0xC7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0x7,0xF4
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF4,0xFF,0xF7
	.DB  0x6F,0xF7,0x6F,0xF7,0x6F,0xF7,0x6F,0xC7
	.DB  0x6F,0xF7,0x6F,0xF7,0x6F,0xF7,0x7,0xF4
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x8F,0xF7,0xFF,0xF7
	.DB  0x3,0xF6,0xFF,0xF7,0x8F,0xF7,0x77,0xC7
	.DB  0x77,0xF7,0x77,0xF7,0x77,0xF7,0x8F,0xF7
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0x5F,0xFF,0x5F,0xFF,0xEF,0xFE,0xEF,0xFE
	.DB  0xF,0xFE,0xF7,0xFD,0xF7,0xFD,0xF7,0xFD
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xFF,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0x7,0xFF,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0xF7,0xFE,0x7,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x1F,0xFE,0xEF,0xFD
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xEF,0xFD,0x1F,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x87,0xFF,0x77,0xFF
	.DB  0xF7,0xFE,0xF7,0xFE,0xF7,0xFE,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0x77,0xFF,0x87,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xFE,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0x7,0xFE,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0x7,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xFE,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0x7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x1F,0xFE,0xEF,0xFD
	.DB  0xF7,0xFF,0xF7,0xFF,0x37,0xFC,0xF7,0xFD
	.DB  0xF7,0xFD,0xF7,0xFD,0xEF,0xFC,0x1F,0xFD
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFE,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0x7,0xFE,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0xF7,0xFE,0xF7,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0xBF,0xFF,0xBF,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0xBF,0xFF,0xBB,0xFF,0xBB,0xFF,0xC7,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFE,0x77,0xFF
	.DB  0xB7,0xFF,0xD7,0xFF,0xE7,0xFF,0xD7,0xFF
	.DB  0xB7,0xFF,0x77,0xFF,0xF7,0xFE,0xF7,0xFD
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0x7,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xF7,0xE7,0xF3
	.DB  0xE7,0xF3,0xD7,0xF5,0xD7,0xF5,0xB7,0xF6
	.DB  0xB7,0xF6,0x77,0xF7,0x77,0xF7,0xF7,0xF7
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xE7,0xFD,0xE7,0xFD
	.DB  0xD7,0xFD,0xD7,0xFD,0xB7,0xFD,0xB7,0xFD
	.DB  0x77,0xFD,0x77,0xFD,0xF7,0xFC,0xF7,0xFC
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x1F,0xFF,0xEF,0xFE
	.DB  0xF7,0xFD,0xF7,0xFD,0xF7,0xFD,0xF7,0xFD
	.DB  0xF7,0xFD,0xF7,0xFD,0xEF,0xFE,0x1F,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xFF,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0xF7,0xFE,0x7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x1F,0xFF,0xEF,0xFE
	.DB  0xF7,0xFD,0xF7,0xFD,0xF7,0xFD,0xF7,0xFD
	.DB  0xF7,0xFD,0x77,0xFD,0xEF,0xFE,0x1F,0xFD
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xFF,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0x7,0xFF,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0xF7,0xFE,0xF7,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF,0xFF,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFF,0xCF,0xFF,0x3F,0xFF
	.DB  0xFF,0xFE,0xF7,0xFE,0xF7,0xFE,0xF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xFC,0xBF,0xFF
	.DB  0xBF,0xFF,0xBF,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0xBF,0xFF,0xBF,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFE,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0xF7,0xFE,0xF7,0xFE
	.DB  0xF7,0xFE,0xF7,0xFE,0xF7,0xFE,0xF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFD,0xF7,0xFD
	.DB  0xF7,0xFD,0xEF,0xFE,0xEF,0xFE,0xEF,0xFE
	.DB  0x5F,0xFF,0x5F,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x77,0xF7,0x77,0xF7
	.DB  0x77,0xF7,0xAF,0xFA,0xAF,0xFA,0xAF,0xFA
	.DB  0xAF,0xFA,0xDF,0xFD,0xDF,0xFD,0xDF,0xFD
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFD,0xF7,0xFD
	.DB  0xEF,0xFE,0x5F,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0x5F,0xFF,0xEF,0xFE,0xF7,0xFD,0xF7,0xFD
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFD,0xF7,0xFD
	.DB  0xEF,0xFE,0xEF,0xFE,0x5F,0xFF,0x5F,0xFF
	.DB  0xBF,0xFF,0xBF,0xFF,0xBF,0xFF,0xBF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xFE,0xFF,0xFE
	.DB  0x7F,0xFF,0xBF,0xFF,0xBF,0xFF,0xDF,0xFF
	.DB  0xEF,0xFF,0xEF,0xFF,0xF7,0xFF,0x7,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF4,0xBF,0xF7
	.DB  0xBF,0xF7,0x5F,0xC7,0xEF,0xF6,0xF7,0xF5
	.DB  0xFF,0xFF,0xF,0xF0,0xFF,0xF7,0xFF,0xF7
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xBF,0xF7,0xBF,0xF7
	.DB  0x9F,0xF0,0x5F,0xF7,0xEF,0xF6,0xF7,0xF5
	.DB  0xFF,0xFF,0x1F,0xF8,0xEF,0xF7,0xEF,0xF7
	.DB  0x1F,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0xF7,0xFF
	.DB  0xF7,0xFF,0xF7,0xFF,0xF7,0xFF,0x7,0xFE
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF7,0xFE,0x77,0xFF
	.DB  0xB7,0xFF,0xD7,0xFF,0xE7,0xFF,0xD7,0xFF
	.DB  0xB7,0xFF,0x77,0xFF,0xF7,0xFE,0xF7,0xFD
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF,0xF7,0xF7,0xF6
	.DB  0xF7,0xF6,0xF7,0xF6,0xF,0xF7,0xFF,0xF7
	.DB  0xFF,0xFF,0xF,0xF0,0xEF,0xF7,0xEF,0xF7
	.DB  0xF,0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xB7,0xF5,0xB7,0xF5
	.DB  0xB7,0xF5,0xB7,0xF5,0x7,0xF4,0xB7,0xF5
	.DB  0xB7,0xF5,0xB7,0xF5,0xB7,0xF5,0x87,0xF5
	.DB  0xFF,0xF5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0x7,0xF6,0xF7,0xF7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7
	.DB  0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0x7,0xF4
	.DB  0xFF,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
	.DB  0xFF,0xFF,0xFF,0xFF,0xF,0xF0,0xEF,0xFF
	.DB  0xEF,0xFF,0xEF,0xFF,0xEF,0xFF,0xF,0xF0
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7,0xE0
	.DB  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
_han:
	.DB  0x0,0xFE,0xFE,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0xF,0xC
	.DB  0xC,0xC,0xC,0xC,0x0,0x0,0x0,0x0
	.DB  0x0,0xFE,0xFE,0xE0,0xB0,0x18,0xC,0x6
	.DB  0x2,0x0,0x0,0x0,0x0,0xF,0xF,0x0
	.DB  0x1,0x3,0x6,0xC,0x8,0x0,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x44,0x38,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0xFC,0x40,0x40,0xFC,0x40,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0xF,0x0,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0xFC,0x4,0x4,0x4,0x4,0x4,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0x8,0x8,0x8,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x0,0xFC,0x84,0x84,0x84,0x84,0x84
	.DB  0x84,0x84,0x0,0x0,0x0,0x8,0x8,0x8
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x0
	.DB  0x0,0x4,0x4,0xFC,0x4,0x44,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xC,0x3,0x0
	.DB  0x3,0xC,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0x80,0xA4,0xA4,0xBC,0xA4,0xA4,0xBC
	.DB  0xA4,0xA4,0x80,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x13,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x0,0xFC,0x80
	.DB  0x80,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x0,0x1F,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x7C,0x48,0x48,0x48,0x48,0x7C,0x0
	.DB  0x0,0x7C,0x10,0x10,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x84,0x84,0x84,0x44,0x24,0x5C,0x48
	.DB  0x48,0xFC,0x0,0x0,0x0,0x0,0xC,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0xC,0x0,0x0
	.DB  0x0,0x7C,0x40,0x40,0x40,0x40,0x40,0x40
	.DB  0x0,0xFC,0x10,0x10,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x0,0xC0,0x30,0xC,0x30,0xC0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xE,0x1,0x1
	.DB  0x1,0x1,0x1,0xE,0x0,0x0,0x0,0x0
	.DB  0x0,0x1C,0xE0,0x0,0x0,0x0,0xE0,0x1C
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3
	.DB  0xC,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x44,0xB8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0xF,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x84,0x84,0x84,0x84,0x78,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xFC,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xF,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xF0,0x8,0x4,0x4,0x4,0x4,0x8
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x4,0x8
	.DB  0x8,0x8,0x8,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x10,0x8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x84,0x84,0x84,0x84,0x78,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xC0,0x30,0xC,0x30,0xC0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xE,0x1,0x1
	.DB  0x1,0x1,0x1,0xE,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x4,0x4,0x4,0x8,0xF0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0x8,0x4,0x3,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x84,0x84,0x18,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x6,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x4,0xC4,0x4,0x4,0xC4,0x4
	.DB  0x4,0xFC,0x0,0x0,0x0,0x8,0x8,0xF
	.DB  0x8,0x8,0xF,0x8,0xA,0x9,0x8,0x0
	.DB  0x0,0x80,0x98,0xA4,0xA4,0xA4,0xA4,0xA4
	.DB  0xA4,0x98,0x80,0x0,0x0,0x0,0x2,0x3
	.DB  0x2,0x2,0x2,0x2,0x3,0x1E,0x0,0x0
	.DB  0x0,0x4,0x84,0x64,0x1C,0x24,0x44,0x94
	.DB  0x10,0xFC,0x0,0x0,0x0,0x1,0x1C,0x10
	.DB  0x10,0x10,0x10,0x10,0x10,0x13,0x0,0x0
	.DB  0x0,0x0,0x3C,0x24,0x24,0x24,0x24,0x24
	.DB  0x24,0x3C,0x0,0x0,0x0,0x1,0x1D,0x11
	.DB  0x11,0x11,0x17,0x11,0x11,0x11,0x1,0x0
	.DB  0x0,0x84,0x84,0x84,0x44,0x24,0x1C,0x0
	.DB  0x0,0xFC,0x20,0x20,0x0,0x0,0xC,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0xC,0x0,0x0
	.DB  0x0,0x0,0x0,0x80,0x7C,0x80,0x0,0x0
	.DB  0x0,0xFC,0x80,0x80,0x0,0x8,0x6,0x1
	.DB  0x0,0x1,0x6,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x4,0x84,0x64,0x1C,0x24,0x44,0x94
	.DB  0x10,0xFC,0x0,0x0,0x0,0x1,0x1C,0x10
	.DB  0x10,0x10,0x10,0x10,0x10,0x13,0x0,0x0
	.DB  0x0,0x4,0x4,0x84,0x7C,0x84,0x4,0x4
	.DB  0x0,0xFC,0x80,0x80,0x0,0x8,0x6,0x1
	.DB  0x0,0x1,0x6,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x0,0xFC,0x80
	.DB  0x80,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x0,0x1F,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x7C,0x48,0x48,0x48,0x48,0x7C,0x0
	.DB  0x0,0x7C,0x10,0x10,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0x80,0x98,0xE4,0xA4,0xA4,0xA4,0xA4
	.DB  0xE4,0x98,0x80,0x0,0x0,0x0,0xC,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0xC,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x44,0x38,0x28
	.DB  0x28,0xFC,0x0,0x0,0x0,0x0,0x2,0x2
	.DB  0x2,0x2,0x2,0x2,0x2,0x1E,0x0,0x0
	.DB  0x0,0xFC,0x4,0x4,0x4,0x4,0xFC,0x0
	.DB  0x0,0xFC,0x80,0x80,0x0,0xF,0x8,0x8
	.DB  0x8,0x8,0xF,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x0
	.DB  0x0,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x94,0x94,0x94,0x54,0x34,0x1C,0x10
	.DB  0x10,0xFC,0x0,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x4,0x4,0xFC,0x4,0x44,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xC,0x3,0x0
	.DB  0x3,0xC,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x40
	.DB  0x40,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x0,0x80,0x60,0x1C,0x20,0x40,0x80
	.DB  0x0,0xFC,0x0,0x0,0x0,0x1,0x1C,0x10
	.DB  0x10,0x10,0x10,0x10,0x10,0x13,0x0,0x0
	.DB  0x0,0x4,0x4,0xFC,0x4,0x44,0x40,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0xC,0x3,0x0
	.DB  0x3,0xC,0x0,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0x80,0xA4,0xA4,0xBC,0xA4,0xA4,0xBC
	.DB  0xA4,0xA4,0x80,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x13,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x0,0xFC,0x80
	.DB  0x80,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x0,0x1F,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0x7C,0x48,0x48,0x48,0x48,0x7C,0x0
	.DB  0x0,0x7C,0x10,0x10,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x44,0xB8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0xF,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x18,0x60,0x80,0x0,0x80,0x60
	.DB  0x18,0xFC,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x1,0x6,0x1,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x10,0x90,0x54,0x54,0x54,0x90,0x10
	.DB  0x0,0xFC,0x0,0x0,0x0,0x8,0x9,0xA
	.DB  0xE,0xA,0x9,0x8,0x0,0x1F,0x0,0x0
	.DB  0x0,0x0,0xE4,0x24,0x24,0x24,0x24,0x24
	.DB  0x24,0x3C,0x0,0x0,0x0,0x8,0x9,0x9
	.DB  0x9,0x9,0xF,0x9,0x9,0x9,0x8,0x0
	.DB  0x0,0x80,0x40,0x30,0x1C,0x20,0x50,0x10
	.DB  0x10,0x7C,0x0,0x0,0x0,0x0,0x1D,0x15
	.DB  0x15,0x15,0x15,0x15,0x15,0x17,0x0,0x0
	.DB  0x0,0x4,0x4,0x4,0xFC,0x10,0x10,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0x8,0x4,0x3
	.DB  0x0,0x1,0x1,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0x84,0x84,0xFC,0x84,0xFC,0x84,0x94
	.DB  0x10,0xFC,0x0,0x0,0x0,0x0,0x1E,0x12
	.DB  0x12,0x12,0x12,0x12,0x12,0x1E,0x0,0x0
	.DB  0x0,0x38,0x44,0x44,0x44,0x38,0x0,0xFC
	.DB  0x0,0xFC,0x0,0x0,0x0,0x1,0x9,0x7
	.DB  0x1,0x5,0x4,0x1F,0x0,0x1F,0x0,0x0
	.DB  0x0,0xF8,0x4,0x4,0x4,0x4,0xF8,0x40
	.DB  0x40,0xFC,0x0,0x0,0x0,0x7,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x1F,0x0,0x0
	.DB  0x0,0xFC,0x84,0x84,0x84,0x84,0x78,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xF0,0x8,0x4,0x4,0x4,0x4,0x8
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0x4,0x8
	.DB  0x8,0x8,0x8,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0xFC,0x44,0x44,0x44,0x44,0xB8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0xF,0x8,0x8
	.DB  0x8,0x8,0x7,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0xE0,0x18,0x4,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x3,0xC,0x10
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x4,0x18,0xE0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x10,0xC,0x3
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xFC,0x90,0x90,0x90,0x90,0x90
	.DB  0x90,0xFC,0x0,0x0,0x0,0x8,0x8,0x8
	.DB  0x8,0x8,0xF,0x8,0x8,0x8,0x8,0x0
	.DB  0x0,0x0,0xFC,0x84,0x84,0x84,0x84,0x84
	.DB  0x84,0x84,0x0,0x0,0x0,0x8,0x8,0x8
	.DB  0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x0
_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

_0x3:
	.DB  0x11,0x44,0x22,0x88
_0x4:
	.DB  0x88,0x22,0x44,0x11
_0x16A:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0
_0x0:
	.DB  0x55,0x41,0x52,0x54,0x30,0x20,0x53,0x65
	.DB  0x72,0x69,0x61,0x6C,0x20,0x4F,0x75,0x74
	.DB  0x70,0x75,0x74,0x20,0x54,0x65,0x73,0x74
	.DB  0xD,0xA,0x0

__GLOBAL_INI_TBL:
	.DW  0x04
	.DW  _cw
	.DW  _0x3*2

	.DW  0x04
	.DW  _ccw
	.DW  _0x4*2

	.DW  0x0B
	.DW  0x04
	.DW  _0x16A*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30
	STS  XMCRA,R30
	STS  XMCRB,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	WDR
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	STS  WDTCSR,R31
	STS  WDTCSR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,LOW(__SRAM_START)
	LDI  R27,HIGH(__SRAM_START)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

	OUT  RAMPZ,R24

	OUT  EIND,R24

;GPIOR0 INITIALIZATION
	LDI  R30,__GPIOR0_INIT
	OUT  GPIOR0,R30

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0xA00

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.05.0 Professional
;Automatic Program Generator
; Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 2012-05-16
;Author  :
;Company :
;Comments:
;
;
;Chip type               : ATmega2560
;Program type            : Application
;AVR Core Clock frequency: 16.000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 2048
;*****************************************************/
;
;#include <mega2560.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.EQU __sm_adc_noise_red=0x02
	.SET power_ctrl_reg=smcr
	#endif
;
;#include <delay.h>
;
;// Standard Input/Output functions
;#include <stdio.h>
;//------------------------------------------servo Motor
;#define max ((1.5+0.8)*10)
;#define min ((1.5-0.9)*10)
;#define mideum (1.5*10) // 90 ġ On-Time dury 1.5ms
;#define duty 200
;bit direction_flag;
;char Pulse=0;
;//------------------------------------------Stepping Motor
;char cw[4]={0x11,0x44,0x22,0x88};

	.DSEG
;char ccw[4]={0x88,0x22,0x44,0x11};
;bit Flag;
;int Dir;
;int Pulse_cnt;
;//------------------------------------------DC Motor
;#define CW1 PORTD.0
;#define CWC1 PORTD.1
;#define CW2 PORTD.2
;#define CCW2 PORTD.3
;#define EN1 PORTD.4
;#define EN2 PORTD.5
;unsigned int DCMotorduty=0;
;unsigned int MotorDir=0;
;
;//------------------------------------------Dotmatrix
;#define PORT0 PORTH
;#define PORT2 PORTK
;flash unsigned int str[]={0xffff,0xe7ff,0xe7ff,0xe601,0xe601,0xe67f,0x867f,0x867f,0xe73f,0xe79f,0xe7cf,0xe7e7,0xe7f3,0xe7fb,0xe7ff,0xffff};  // 
;flash unsigned int str1[]={0xffff,0xe7ff,0xe7ff,0xe601,0xe601,0xe67f,0x867f,0x867f,0xe73f,0xe79f,0xe7cf,0xe7e7,0xe7f3,0xe7fb,0xe7ff,0xffff}; // 
;flash unsigned int str2[]={0xffff,0xfe7f,0xfe7f,0xfc3f,0xf99f,0xf3cf,0xe7e7,0xffff,0x8001,0x8001,0xfe7f,0xfe7f,0xfe7f,0xfe7f,0xfe7f,0xffff}; // 
;flash unsigned int str3[]={0xffff,0x9cf9,0x9cf9,0xccf9,0xe4f9,0xf0f9,0xf8f9,0xfcf9,0xf0f9,0xe4f9,0xccf9,0x9cf9,0x9c81,0x9c81,0xffff,0xffff}; // LK
;flash unsigned int str4[]={0xffff,0xffff,0xffff,0xe3c7,0xddbb,0xffff,0xffff,0xffff,0xffff,0xf00f,0xf7ef,0xf7ef,0xfbdf,0xfc3f,0xffff,0xffff}; // SMILE
;flash unsigned int row[]={0x00001,0x00002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,0x0200,0x0400,0x0800,0x1000,0x2000,0x4000,0x8000,};
;flash unsigned int str5[48][16]={   0xffff,0xffff,0xf607,0xf6ff,0xf6ff,0xf6ff,0xf6ff,0xc77f,0xf77f,0xf7bf,0xf7df,0xf7e7,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xc7f7,0xf7f7,0xf7f7,0xf7f7,0xf407,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf607,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xc7f7,0xf7f7,0xf7f7,0xf7f7,0xf407,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf607,0xf6ff,0xf6ff,0xf6ff,0xf607,0xc7f7,0xf7f7,0xf7f7,0xf7f7,0xf407,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf607,0xf6f7,0xf6f7,0xf6f7,0xf6f7,0xc6f7,0xf6f7,0xf6f7,0xf6f7,0xf607,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf6f7,0xf6f7,0xf6f7,0xf6f7,0xf607,0xc6f7,0xf6f7,0xf6f7,0xf6f7,0xf607,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf7bf,0xf7bf,0xf7bf,0xf7bf,0xf7bf,0xc75f,0xf75f,0xf6ef,0xf6ef,0xf5f7,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf70f,0xf6f7,0xf6f7,0xf6f7,0xf6f7,0xc6f7,0xf6f7,0xf6f7,0xf6f7,0xf70f,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf407,0xf7bf,0xf7bf,0xf7bf,0xf7bf,0xc75f,0xf75f,0xf6ef,0xf6ef,0xf5f7,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf607,0xf6ff,0xf6ff,0xf6ff,0xf607,0xc77f,0xf77f,0xf7bf,0xf7df,0xf7e7,0xf7ff,0xffff,0xffff,0xffff, //ī
;                                   0xffff,0xffff,0xf71f,0xf7ff,0xf407,0xf7bf,0xf7bf,0xc7bf,0xf75f,0xf6df,0xf5ef,0xf7f7,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf607,0xf7f7,0xf7f7,0xf7f7,0xf607,0xc7f7,0xf7f7,0xf7f7,0xf7f7,0xf407,0xf7ff,0xffff,0xffff,0xffff, //Ÿ
;                                   0xffff,0xffff,0xf407,0xf7ff,0xf76f,0xf76f,0xf76f,0xc76f,0xf76f,0xf76f,0xf76f,0xf407,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf78f,0xf7ff,0xf603,0xf7ff,0xf78f,0xc777,0xf777,0xf777,0xf777,0xf78f,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xffbf,0xffbf,0xff5f,0xff5f,0xfeef,0xfeef,0xfe0f,0xfdf7,0xfdf7,0xfdf7,0xffff,0xffff,0xffff,0xffff, //A
;                                   0xffff,0xffff,0xff07,0xfef7,0xfef7,0xfef7,0xff07,0xfef7,0xfef7,0xfef7,0xfef7,0xff07,0xffff,0xffff,0xffff,0xffff, //B
;                                   0xffff,0xffff,0xfe1f,0xfdef,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfdef,0xfe1f,0xffff,0xffff,0xffff,0xffff, //C
;                                   0xffff,0xffff,0xff87,0xff77,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xff77,0xff87,0xffff,0xffff,0xffff,0xffff, //D
;                                   0xffff,0xffff,0xfe07,0xfff7,0xfff7,0xfff7,0xfe07,0xfff7,0xfff7,0xfff7,0xfff7,0xfe07,0xffff,0xffff,0xffff,0xffff, //E
;                                   0xffff,0xffff,0xfe07,0xfff7,0xfff7,0xfff7,0xff07,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xffff,0xffff,0xffff,0xffff, //F
;                                   0xffff,0xffff,0xfe1f,0xfdef,0xfff7,0xfff7,0xfc37,0xfdf7,0xfdf7,0xfdf7,0xfcef,0xfd1f,0xffff,0xffff,0xffff,0xffff, //G
;                                   0xffff,0xffff,0xfef7,0xfef7,0xfef7,0xfef7,0xfe07,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xffff,0xffff,0xffff,0xffff, //H
;                                   0xffff,0xffff,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xffff,0xffff,0xffff,0xffff, //I
;                                   0xffff,0xffff,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffbb,0xffbb,0xffc7,0xffff,0xffff,0xffff,0xffff, //J
;                                   0xffff,0xffff,0xfef7,0xff77,0xffb7,0xffd7,0xffe7,0xffd7,0xffb7,0xff77,0xfef7,0xfdf7,0xffff,0xffff,0xffff,0xffff, //K
;                                   0xffff,0xffff,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfe07,0xffff,0xffff,0xffff,0xffff, //L
;                                   0xffff,0xffff,0xf7f7,0xf3e7,0xf3e7,0xf5d7,0xf5d7,0xf6b7,0xf6b7,0xf777,0xf777,0xf7f7,0xffff,0xffff,0xffff,0xffff, //M
;                                   0xffff,0xffff,0xfde7,0xfde7,0xfdd7,0xfdd7,0xfdb7,0xfdb7,0xfd77,0xfd77,0xfcf7,0xfcf7,0xffff,0xffff,0xffff,0xffff, //N
;                                   0xffff,0xffff,0xff1f,0xfeef,0xfdf7,0xfdf7,0xfdf7,0xfdf7,0xfdf7,0xfdf7,0xfeef,0xff1f,0xffff,0xffff,0xffff,0xffff, //O
;                                   0xffff,0xffff,0xff07,0xfef7,0xfef7,0xfef7,0xfef7,0xff07,0xfff7,0xfff7,0xfff7,0xfff7,0xffff,0xffff,0xffff,0xffff, //P
;                                   0xffff,0xffff,0xff1f,0xfeef,0xfdf7,0xfdf7,0xfdf7,0xfdf7,0xfdf7,0xfd77,0xfeef,0xfd1f,0xffff,0xffff,0xffff,0xffff, //Q
;                                   0xffff,0xffff,0xff07,0xfef7,0xfef7,0xfef7,0xff07,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xffff,0xffff,0xffff,0xffff, //R
;                                   0xffff,0xffff,0xff0f,0xfef7,0xfef7,0xfff7,0xffcf,0xff3f,0xfeff,0xfef7,0xfef7,0xff0f,0xffff,0xffff,0xffff,0xffff, //S
;                                   0xffff,0xffff,0xfc07,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffbf,0xffff,0xffff,0xffff,0xffff, //T
;                                   0xffff,0xffff,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xfef7,0xff0f,0xffff,0xffff,0xffff,0xffff, //U
;                                   0xffff,0xffff,0xfdf7,0xfdf7,0xfdf7,0xfeef,0xfeef,0xfeef,0xff5f,0xff5f,0xffbf,0xffbf,0xffff,0xffff,0xffff,0xffff, //V
;                                   0xffff,0xffff,0xf777,0xf777,0xf777,0xfaaf,0xfaaf,0xfaaf,0xfaaf,0xfddf,0xfddf,0xfddf,0xffff,0xffff,0xffff,0xffff, //W
;                                   0xffff,0xffff,0xfdf7,0xfdf7,0xfeef,0xff5f,0xffbf,0xffbf,0xff5f,0xfeef,0xfdf7,0xfdf7,0xffff,0xffff,0xffff,0xffff, //X
;                                   0xffff,0xffff,0xfdf7,0xfdf7,0xfeef,0xfeef,0xff5f,0xff5f,0xffbf,0xffbf,0xffbf,0xffbf,0xffff,0xffff,0xffff,0xffff, //Y
;                                   0xffff,0xffff,0xfe07,0xfeff,0xff7f,0xffbf,0xffbf,0xffdf,0xffef,0xffef,0xfff7,0xfe07,0xffff,0xffff,0xffff,0xffff, //Z
;                                   0xffff,0xffff,0xf407,0xf7bf,0xf7bf,0xc75f,0xf6ef,0xf5f7,0xffff,0xf00f,0xf7ff,0xf7ff,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf7bf,0xf7bf,0xf09f,0xf75f,0xf6ef,0xf5f7,0xffff,0xf81f,0xf7ef,0xf7ef,0xf81f,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfff7,0xfe07,0xffff,0xffff,0xffff,0xffff, //L
;                                   0xffff,0xffff,0xfef7,0xff77,0xffb7,0xffd7,0xffe7,0xffd7,0xffb7,0xff77,0xfef7,0xfdf7,0xffff,0xffff,0xffff,0xffff, //K
;                                   0xffff,0xffff,0xf70f,0xf6f7,0xf6f7,0xf6f7,0xf70f,0xf7ff,0xffff,0xf00f,0xf7ef,0xf7ef,0xf00f,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf5b7,0xf5b7,0xf5b7,0xf5b7,0xf407,0xf5b7,0xf5b7,0xf5b7,0xf5b7,0xf587,0xf5ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf607,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xf7f7,0xf407,0xf7ff,0xffff,0xffff,0xffff, //
;                                   0xffff,0xffff,0xf00f,0xffef,0xffef,0xffef,0xffef,0xf00f,0xffff,0xffff,0xffff,0xe007,0xffff,0xffff,0xffff,0xffff,  //
;                                   };
;#define OrangeLed_Clk0 0xfe
;#define OrangeLed_Clk1 0xfd
;
;#define RedLed_Clk0 0xfb
;#define RedLed_Clk1 0xf7
;
;#define Row_Clk0 0xef
;#define Row_Clk1 0xdf
;
;#define CP_Enable 0xFF
;#if 0
;74hc574 ȣ Low to High̴.
;#endif
;#define MoveSpeed 10
;bit Toggle=0;
;int timeCnt=0;
;
;//------------------------------------------GLCD
;//---------------------------------------------
;#define lcd_dt PORTJ
;#define RW     PORTA.1
;#define lcd_en PORTA.2
;#define lcd_di PORTA.0
;#define lcd_s2 PORTA.5
;#define lcd_s1 PORTA.4
;#define rst    PORTA.6
;//----------------------------------------------------
;unsigned char screen[8][128];
;bit flg;
;char bf;
;struct {
;   char bf, x, y, ty;
;}  lcd;
;bit lcd_pg, lcd_blk;
;flash char han[62][24]={
;
;0x00,0xfe,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //L  0
;0x00,0x0f,0x0f,0x0c,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,
;
;
;0x00,0xfe,0xfe,0xe0,0xb0,0x18,0x0c,0x06,0x02,0x00,0x00,0x00, //K
;0x00,0x0f,0x0f,0x00,0x01,0x03,0x06,0x0c,0x08,0x00,0x00,0x00,
;
;
;0x00,0x38,0x44,0x44,0x44,0x44,0x38,0x00,0x00,0xfc,0x00,0x00, //  2
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0xfc,0x40,0x40,0xfc,0x40,0x40,0xfc,0x00,0xfc,0x00,0x00, //  3
;0x00,0x0f,0x08,0x08,0x0f,0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0xfc,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0xfc,0x00,0x00, //   4
;0x00,0x0f,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x00,0xfc,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x00,0x00, //   5
;0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
;
;0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, //   6
;0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0x80,0xa4,0xa4,0xbc,0xa4,0xa4,0xbc,0xa4,0xa4,0x80,0x00, //ǰ   7
;0x00,0x00,0x1e,0x12,0x12,0x12,0x13,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, //   8
;0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, //   9
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x00,0x00,0xfc,0x00,0x00, //   10
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x84,0x84,0x84,0x44,0x24,0x5c,0x48,0x48,0xfc,0x00,0x00, //   11
;0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,
;
;0x00,0x7c,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0xfc,0x10,0x10, //   12
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x00,0xc0,0x30,0x0c,0x30,0xc0,0x00,0x00,0x00,0x00,0x00, //A    13
;0x00,0x0e,0x01,0x01,0x01,0x01,0x01,0x0e,0x00,0x00,0x00,0x00,
;
;0x00,0x1c,0xe0,0x00,0x00,0x00,0xe0,0x1c,0x00,0x00,0x00,0x00, //V    14
;0x00,0x00,0x00,0x03,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, //R   15
;0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, //P   16
;0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00, //I   17
;0x00,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xf0,0x08,0x04,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00, //C   18
;0x00,0x03,0x04,0x08,0x08,0x08,0x08,0x04,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //,   19
;0x00,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, //P   20
;0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0xc0,0x30,0x0c,0x30,0xc0,0x00,0x00,0x00,0x00,0x00, //A   21
;0x00,0x0e,0x01,0x01,0x01,0x01,0x01,0x0e,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x04,0x04,0x04,0x08,0xf0,0x00,0x00,0x00,0x00,0x00, //D    22
;0x00,0x0f,0x08,0x08,0x08,0x04,0x03,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x38,0x44,0x44,0x84,0x84,0x18,0x00,0x00,0x00,0x00,0x00, //S    23
;0x00,0x06,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0x04,0xc4,0x04,0x04,0xc4,0x04,0x04,0xfc,0x00,0x00, //   24
;0x00,0x08,0x08,0x0f,0x08,0x08,0x0f,0x08,0x0a,0x09,0x08,0x00,
;
;0x00,0x80,0x98,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0x98,0x80,0x00, //   25
;0x00,0x00,0x02,0x03,0x02,0x02,0x02,0x02,0x03,0x1e,0x00,0x00,
;
;0x00,0x04,0x84,0x64,0x1c,0x24,0x44,0x94,0x10,0xfc,0x00,0x00, //   26
;0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,
;
;0x00,0x00,0x3c,0x24,0x24,0x24,0x24,0x24,0x24,0x3c,0x00,0x00, //  27
;0x00,0x01,0x1d,0x11,0x11,0x11,0x17,0x11,0x11,0x11,0x01,0x00,
;
;
;0x00,0x84,0x84,0x84,0x44,0x24,0x1c,0x00,0x00,0xfc,0x20,0x20, //  28
;0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,
;
;0x00,0x00,0x00,0x80,0x7c,0x80,0x00,0x00,0x00,0xfc,0x80,0x80, //  29
;0x00,0x08,0x06,0x01,0x00,0x01,0x06,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x04,0x84,0x64,0x1c,0x24,0x44,0x94,0x10,0xfc,0x00,0x00, //  30
;0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,
;
;0x00,0x04,0x04,0x84,0x7c,0x84,0x04,0x04,0x00,0xfc,0x80,0x80, //   31
;0x00,0x08,0x06,0x01,0x00,0x01,0x06,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, //   32
;0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, //   33
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0x80,0x98,0xe4,0xa4,0xa4,0xa4,0xa4,0xe4,0x98,0x80,0x00, //   34
;0x00,0x00,0x0c,0x12,0x12,0x12,0x12,0x12,0x12,0x0c,0x00,0x00,
;
;0x00,0x38,0x44,0x44,0x44,0x44,0x38,0x28,0x28,0xfc,0x00,0x00, //   35
;0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x1e,0x00,0x00,
;
;0x00,0xfc,0x04,0x04,0x04,0x04,0xfc,0x00,0x00,0xfc,0x80,0x80, //   36
;0x00,0x0f,0x08,0x08,0x08,0x08,0x0f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x00,0x00,0xfc,0x00,0x00, //   37
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x94,0x94,0x94,0x54,0x34,0x1c,0x10,0x10,0xfc,0x00,0x00, //   38
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, //   39
;0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x40,0x40,0xfc,0x00,0x00, //   40
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x00,0x80,0x60,0x1c,0x20,0x40,0x80,0x00,0xfc,0x00,0x00, //   41
;0x00,0x01,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x13,0x00,0x00,
;
;0x00,0x04,0x04,0xfc,0x04,0x44,0x40,0xfc,0x00,0xfc,0x00,0x00, //   42
;0x00,0x0c,0x03,0x00,0x03,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0x80,0xa4,0xa4,0xbc,0xa4,0xa4,0xbc,0xa4,0xa4,0x80,0x00, //ǰ   43
;0x00,0x00,0x1e,0x12,0x12,0x12,0x13,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x00,0xfc,0x80,0x80,0xfc,0x00,0x00, //   44
;0x00,0x08,0x04,0x03,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0x7c,0x48,0x48,0x48,0x48,0x7c,0x00,0x00,0x7c,0x10,0x10, //   45
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, //R    46
;0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x18,0x60,0x80,0x00,0x80,0x60,0x18,0xfc,0x00,0x00, //M    47
;0x00,0x0f,0x00,0x00,0x01,0x06,0x01,0x00,0x00,0x0f,0x00,0x00,
;
;0x00,0x10,0x90,0x54,0x54,0x54,0x90,0x10,0x00,0xfc,0x00,0x00, //ȸ   48
;0x00,0x08,0x09,0x0a,0x0e,0x0a,0x09,0x08,0x00,0x1f,0x00,0x00,
;
;0x00,0x00,0xe4,0x24,0x24,0x24,0x24,0x24,0x24,0x3c,0x00,0x00, //   49
;0x00,0x08,0x09,0x09,0x09,0x09,0x0f,0x09,0x09,0x09,0x08,0x00,
;
;0x00,0x80,0x40,0x30,0x1c,0x20,0x50,0x10,0x10,0x7c,0x00,0x00, //   50
;0x00,0x00,0x1d,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x00,0x00,
;
;0x00,0x04,0x04,0x04,0xfc,0x10,0x10,0xfc,0x00,0xfc,0x00,0x00, //   51
;0x00,0x08,0x04,0x03,0x00,0x01,0x01,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0x84,0x84,0xfc,0x84,0xfc,0x84,0x94,0x10,0xfc,0x00,0x00, //   52
;0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x1e,0x00,0x00,
;
;0x00,0x38,0x44,0x44,0x44,0x38,0x00,0xfc,0x00,0xfc,0x00,0x00, //   53
;0x00,0x01,0x09,0x07,0x01,0x05,0x04,0x1f,0x00,0x1f,0x00,0x00,
;
;0x00,0xf8,0x04,0x04,0x04,0x04,0xf8,0x40,0x40,0xfc,0x00,0x00, //   54
;0x00,0x07,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x1f,0x00,0x00,
;
;0x00,0xfc,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00, //P    55
;0x00,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xf0,0x08,0x04,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00, //C   56
;0x00,0x03,0x04,0x08,0x08,0x08,0x08,0x04,0x00,0x00,0x00,0x00,
;
;0x00,0xfc,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00, //B   57
;0x00,0x0f,0x08,0x08,0x08,0x08,0x07,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0xe0,0x18,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //(   58
;0x00,0x03,0x0c,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x04,0x18,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //)   59
;0x00,0x10,0x0c,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
;
;0x00,0x00,0xfc,0x90,0x90,0x90,0x90,0x90,0x90,0xfc,0x00,0x00, //    60
;0x00,0x08,0x08,0x08,0x08,0x08,0x0f,0x08,0x08,0x08,0x08,0x00,
;
;0x00,0x00,0xfc,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x00,0x00, //    61
;0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
;
;
;
;
;};
;char SecCnt=0;
;bit SecFlag;
;
;// Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 0159 {

	.CSEG
_timer0_ovf_isr:
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 015A  static int cnt,cnt2,cnt3,cnt4,cnt5=0;
; 0000 015B     cnt++;cnt2++;
	LDI  R26,LOW(_cnt_S0000000000)
	LDI  R27,HIGH(_cnt_S0000000000)
	CALL SUBOPT_0x0
	LDI  R26,LOW(_cnt2_S0000000000)
	LDI  R27,HIGH(_cnt2_S0000000000)
	CALL SUBOPT_0x0
; 0000 015C     if(cnt==2)//2ms
	LDS  R26,_cnt_S0000000000
	LDS  R27,_cnt_S0000000000+1
	SBIW R26,2
	BRNE _0x5
; 0000 015D     {
; 0000 015E         Pulse_cnt++; // Pulse Count!
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 7,8,30,31
; 0000 015F         if(Pulse_cnt==4)
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CP   R30,R7
	CPC  R31,R8
	BRNE _0x6
; 0000 0160         {
; 0000 0161         Pulse_cnt=0;
	CLR  R7
	CLR  R8
; 0000 0162         }
; 0000 0163         cnt=0;
_0x6:
	LDI  R30,LOW(0)
	STS  _cnt_S0000000000,R30
	STS  _cnt_S0000000000+1,R30
; 0000 0164     }
; 0000 0165     if(cnt2==3000)
_0x5:
	LDS  R26,_cnt2_S0000000000
	LDS  R27,_cnt2_S0000000000+1
	CPI  R26,LOW(0xBB8)
	LDI  R30,HIGH(0xBB8)
	CPC  R27,R30
	BRNE _0x7
; 0000 0166     {
; 0000 0167 		Dir^=1;
	LDI  R30,LOW(1)
	EOR  R5,R30
; 0000 0168         cnt2=0;
	LDI  R30,LOW(0)
	STS  _cnt2_S0000000000,R30
	STS  _cnt2_S0000000000+1,R30
; 0000 0169     }
; 0000 016A 
; 0000 016B     cnt3++;cnt4++;
_0x7:
	LDI  R26,LOW(_cnt3_S0000000000)
	LDI  R27,HIGH(_cnt3_S0000000000)
	CALL SUBOPT_0x0
	LDI  R26,LOW(_cnt4_S0000000000)
	LDI  R27,HIGH(_cnt4_S0000000000)
	CALL SUBOPT_0x0
; 0000 016C     if(cnt3==duty)
	LDS  R26,_cnt3_S0000000000
	LDS  R27,_cnt3_S0000000000+1
	CPI  R26,LOW(0xC8)
	LDI  R30,HIGH(0xC8)
	CPC  R27,R30
	BRNE _0x8
; 0000 016D     {
; 0000 016E       EN1=EN2=0;
	CBI  0xB,5
	CBI  0xB,4
; 0000 016F     }
; 0000 0170     if(cnt3==50)
_0x8:
	LDS  R26,_cnt3_S0000000000
	LDS  R27,_cnt3_S0000000000+1
	SBIW R26,50
	BRNE _0xD
; 0000 0171     {
; 0000 0172       EN1=EN2=1;
	SBI  0xB,5
	SBI  0xB,4
; 0000 0173       cnt3=0;
	LDI  R30,LOW(0)
	STS  _cnt3_S0000000000,R30
	STS  _cnt3_S0000000000+1,R30
; 0000 0174     }
; 0000 0175     if(cnt4==500)
_0xD:
	LDS  R26,_cnt4_S0000000000
	LDS  R27,_cnt4_S0000000000+1
	CPI  R26,LOW(0x1F4)
	LDI  R30,HIGH(0x1F4)
	CPC  R27,R30
	BRNE _0x12
; 0000 0176     {
; 0000 0177         DCMotorduty++;
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 9,10,30,31
; 0000 0178         if(DCMotorduty>50)
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	CP   R30,R9
	CPC  R31,R10
	BRSH _0x13
; 0000 0179         {
; 0000 017A             DCMotorduty=1;// pwm pluse initialization value
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__PUTW1R 9,10
; 0000 017B             MotorDir^=1;  //direction Select variable value
	EOR  R11,R30
; 0000 017C 
; 0000 017D         }
; 0000 017E         cnt4=0;
_0x13:
	LDI  R30,LOW(0)
	STS  _cnt4_S0000000000,R30
	STS  _cnt4_S0000000000+1,R30
; 0000 017F     }
; 0000 0180     cnt5++;
_0x12:
	LDI  R26,LOW(_cnt5_S0000000000)
	LDI  R27,HIGH(_cnt5_S0000000000)
	CALL SUBOPT_0x0
; 0000 0181     if(cnt5>=1000)
	LDS  R26,_cnt5_S0000000000
	LDS  R27,_cnt5_S0000000000+1
	CPI  R26,LOW(0x3E8)
	LDI  R30,HIGH(0x3E8)
	CPC  R27,R30
	BRLT _0x14
; 0000 0182     {
; 0000 0183     SecCnt++;
	LDS  R30,_SecCnt
	SUBI R30,-LOW(1)
	STS  _SecCnt,R30
; 0000 0184     SecFlag^=1;
	LDI  R26,0
	SBIC 0x1E,6
	LDI  R26,1
	LDI  R30,LOW(1)
	EOR  R30,R26
	BRNE _0x15
	CBI  0x1E,6
	RJMP _0x16
_0x15:
	SBI  0x1E,6
_0x16:
; 0000 0185     cnt5=0;
	LDI  R30,LOW(0)
	STS  _cnt5_S0000000000,R30
	STS  _cnt5_S0000000000+1,R30
; 0000 0186         if(SecCnt>=10)
	LDS  R26,_SecCnt
	CPI  R26,LOW(0xA)
	BRLO _0x17
; 0000 0187         {
; 0000 0188          SecCnt=0;
	STS  _SecCnt,R30
; 0000 0189 
; 0000 018A         }
; 0000 018B     }
_0x17:
; 0000 018C 
; 0000 018D 
; 0000 018E 
; 0000 018F     switch(Dir)
_0x14:
	__GETW1R 5,6
; 0000 0190     {
; 0000 0191     case 0:PORTL=ccw[Pulse_cnt];break; //forward direction
	SBIW R30,0
	BRNE _0x1B
	LDI  R26,LOW(_ccw)
	LDI  R27,HIGH(_ccw)
	RJMP _0x164
; 0000 0192     case 1:PORTL=cw[Pulse_cnt];break; //reverse direction
_0x1B:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x1A
	LDI  R26,LOW(_cw)
	LDI  R27,HIGH(_cw)
_0x164:
	ADD  R26,R7
	ADC  R27,R8
	LD   R30,X
	STS  267,R30
; 0000 0193     }
_0x1A:
; 0000 0194     TCNT0+=0x06;
	IN   R30,0x26
	SUBI R30,-LOW(6)
	OUT  0x26,R30
; 0000 0195 
; 0000 0196   //printf("UART0 Serial Output Test\r\n");
; 0000 0197 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	RETI
;
;// Timer2 overflow interrupt service routine
;interrupt [TIM2_OVF] void timer2_ovf_isr(void)
; 0000 019B {
_timer2_ovf_isr:
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 019C static unsigned int cnt,cnt2,cnt3=0;
; 0000 019D     cnt2++;
	LDI  R26,LOW(_cnt2_S0000001000)
	LDI  R27,HIGH(_cnt2_S0000001000)
	CALL SUBOPT_0x0
; 0000 019E     cnt++;
	LDI  R26,LOW(_cnt_S0000001000)
	LDI  R27,HIGH(_cnt_S0000001000)
	CALL SUBOPT_0x0
; 0000 019F     if(cnt2==20000)// 2 ?
	LDS  R26,_cnt2_S0000001000
	LDS  R27,_cnt2_S0000001000+1
	CPI  R26,LOW(0x4E20)
	LDI  R30,HIGH(0x4E20)
	CPC  R27,R30
	BRNE _0x1D
; 0000 01A0     {
; 0000 01A1        Pulse=min;
	__GETD1N 0x6
	MOV  R4,R30
; 0000 01A2        }
; 0000 01A3     if(cnt2==40000)// 4 ?
_0x1D:
	LDS  R26,_cnt2_S0000001000
	LDS  R27,_cnt2_S0000001000+1
	CPI  R26,LOW(0x9C40)
	LDI  R30,HIGH(0x9C40)
	CPC  R27,R30
	BRNE _0x1E
; 0000 01A4     {
; 0000 01A5        Pulse=max;
	__GETD1N 0x17
	MOV  R4,R30
; 0000 01A6        cnt2=0;
	LDI  R30,LOW(0)
	STS  _cnt2_S0000001000,R30
	STS  _cnt2_S0000001000+1,R30
; 0000 01A7        }
; 0000 01A8     if(cnt==Pulse)
_0x1E:
	MOV  R30,R4
	LDS  R26,_cnt_S0000001000
	LDS  R27,_cnt_S0000001000+1
	LDI  R31,0
	CP   R30,R26
	CPC  R31,R27
	BRNE _0x1F
; 0000 01A9     {
; 0000 01AA     PORTB.0=0;
	CBI  0x5,0
; 0000 01AB     PORTB.1=0;
	CBI  0x5,1
; 0000 01AC     PORTB.2=0;
	CBI  0x5,2
; 0000 01AD     PORTB.3=0;
	CBI  0x5,3
; 0000 01AE     }
; 0000 01AF     if(cnt==duty)
_0x1F:
	LDS  R26,_cnt_S0000001000
	LDS  R27,_cnt_S0000001000+1
	CPI  R26,LOW(0xC8)
	LDI  R30,HIGH(0xC8)
	CPC  R27,R30
	BRNE _0x28
; 0000 01B0     {
; 0000 01B1     PORTB.0=1;
	SBI  0x5,0
; 0000 01B2     PORTB.1=1;
	SBI  0x5,1
; 0000 01B3     PORTB.2=1;
	SBI  0x5,2
; 0000 01B4     PORTB.3=1;
	SBI  0x5,3
; 0000 01B5     cnt=0;
	LDI  R30,LOW(0)
	STS  _cnt_S0000001000,R30
	STS  _cnt_S0000001000+1,R30
; 0000 01B6     }
; 0000 01B7 
; 0000 01B8 
; 0000 01B9 
; 0000 01BA  TCNT2+=0xe7;//100uS Tick Time
_0x28:
	LDI  R26,LOW(178)
	LDI  R27,HIGH(178)
	LD   R30,X
	SUBI R30,-LOW(231)
	ST   X,R30
; 0000 01BB }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R23,Y+
	LD   R22,Y+
	RETI
;
;#define ADC_VREF_TYPE 0x40
;
;// Read the AD conversion result
;unsigned int read_adc(unsigned char adc_input)
; 0000 01C1 {
; 0000 01C2 ADMUX=(adc_input & 0x1f) | (ADC_VREF_TYPE & 0xff);
;	adc_input -> Y+0
; 0000 01C3 if (adc_input & 0x20) ADCSRB |= 0x08;
; 0000 01C4 else ADCSRB &= 0xf7;
; 0000 01C5 // Delay needed for the stabilization of the ADC input voltage
; 0000 01C6 delay_us(10);
; 0000 01C7 // Start the AD conversion
; 0000 01C8 ADCSRA|=0x40;
; 0000 01C9 // Wait for the AD conversion to complete
; 0000 01CA while ((ADCSRA & 0x10)==0);
; 0000 01CB ADCSRA|=0x10;
; 0000 01CC return ADCW;
; 0000 01CD }
;
;void reverse_dis() //ϸ鼭 Ʈ  Function
; 0000 01D0 {
_reverse_dis:
; 0000 01D1         int i,j,k,l=0;
; 0000 01D2         static int sum,rowsum=0;
; 0000 01D3         static unsigned int buff[];
; 0000 01D4         #if 1
; 0000 01D5         for(j=15;j>=1;j--){
	SBIW R28,2
	LDI  R30,LOW(0)
	ST   Y,R30
	STD  Y+1,R30
	CALL __SAVELOCR6
;	i -> R16,R17
;	j -> R18,R19
;	k -> R20,R21
;	l -> Y+6
	__GETWRN 18,19,15
_0x37:
	__CPWRN 18,19,1
	BRGE PC+3
	JMP _0x38
; 0000 01D6         for(i=0;i<16;i++){
	__GETWRN 16,17,0
_0x3A:
	__CPWRN 16,17,16
	BRLT PC+3
	JMP _0x3B
; 0000 01D7         buff[i]=str5[timeCnt][i]>>j; //ڸ  ̵忡 ߾ Ʈ 
	CALL SUBOPT_0x1
	CALL SUBOPT_0x2
	CALL __LSRW12
	CALL SUBOPT_0x3
; 0000 01D8 
; 0000 01D9         switch(j){   //ڰ ̵ÿ 鿡 led offϱ  ̴. ذ  ɽÿ switch ּó Ͽ غ ˼ ̴
; 0000 01DA         case 15:
	BRNE _0x3F
; 0000 01DB         for(l=0;l<16;l++){buff[l]|=0xfffe;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x41:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x42
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFFE)
	ORI  R31,HIGH(0xFFFE)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x41
_0x42:
	RJMP _0x3E
; 0000 01DC         case 14:
_0x3F:
	CPI  R30,LOW(0xE)
	LDI  R26,HIGH(0xE)
	CPC  R31,R26
	BRNE _0x43
; 0000 01DD         for(l=0;l<16;l++){buff[l]|=0xfffc;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x45:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x46
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFFC)
	ORI  R31,HIGH(0xFFFC)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x45
_0x46:
	RJMP _0x3E
; 0000 01DE         case 13:
_0x43:
	CPI  R30,LOW(0xD)
	LDI  R26,HIGH(0xD)
	CPC  R31,R26
	BRNE _0x47
; 0000 01DF         for(l=0;l<16;l++){buff[l]|=0xfff8;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x49:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x4A
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFF8)
	ORI  R31,HIGH(0xFFF8)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x49
_0x4A:
	RJMP _0x3E
; 0000 01E0         case 12:
_0x47:
	CPI  R30,LOW(0xC)
	LDI  R26,HIGH(0xC)
	CPC  R31,R26
	BRNE _0x4B
; 0000 01E1         for(l=0;l<16;l++){buff[l]|=0xfff0;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x4D:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x4E
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFF0)
	ORI  R31,HIGH(0xFFF0)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x4D
_0x4E:
	RJMP _0x3E
; 0000 01E2         case 11:
_0x4B:
	CPI  R30,LOW(0xB)
	LDI  R26,HIGH(0xB)
	CPC  R31,R26
	BRNE _0x4F
; 0000 01E3         for(l=0;l<16;l++){buff[l]|=0xffe0;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x51:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x52
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFE0)
	ORI  R31,HIGH(0xFFE0)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x51
_0x52:
	RJMP _0x3E
; 0000 01E4         case 10:
_0x4F:
	CPI  R30,LOW(0xA)
	LDI  R26,HIGH(0xA)
	CPC  R31,R26
	BRNE _0x53
; 0000 01E5         for(l=0;l<16;l++){buff[l]|=0xffc0;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x55:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x56
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFC0)
	ORI  R31,HIGH(0xFFC0)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x55
_0x56:
	RJMP _0x3E
; 0000 01E6         case 9:
_0x53:
	CPI  R30,LOW(0x9)
	LDI  R26,HIGH(0x9)
	CPC  R31,R26
	BRNE _0x57
; 0000 01E7         for(l=0;l<168;l++){buff[l]|=0xff80;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x59:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CPI  R26,LOW(0xA8)
	LDI  R30,HIGH(0xA8)
	CPC  R27,R30
	BRGE _0x5A
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFF80)
	ORI  R31,HIGH(0xFF80)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x59
_0x5A:
	RJMP _0x3E
; 0000 01E8         case 8:
_0x57:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0x5B
; 0000 01E9         for(l=0;l<16;l++){buff[l]|=0xff00;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x5D:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x5E
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0xFF00)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x5D
_0x5E:
	RJMP _0x3E
; 0000 01EA         case 7:
_0x5B:
	CPI  R30,LOW(0x7)
	LDI  R26,HIGH(0x7)
	CPC  R31,R26
	BRNE _0x5F
; 0000 01EB         for(l=0;l<16;l++){buff[l]|=0xfe00;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x61:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x62
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0xFE00)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x61
_0x62:
	RJMP _0x3E
; 0000 01EC         case 6:
_0x5F:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0x63
; 0000 01ED         for(l=0;l<16;l++){buff[l]|=0xfc00;}break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x65:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x66
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0xFC00)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x65
_0x66:
	RJMP _0x3E
; 0000 01EE         case 5:
_0x63:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0x67
; 0000 01EF         for(l=0;l<16;l++){buff[l]|=0xf800;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x69:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x6A
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0xF800)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x69
_0x6A:
	RJMP _0x3E
; 0000 01F0         case 4:
_0x67:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x6B
; 0000 01F1         for(l=0;l<16;l++){buff[l]|=0xf000;} break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x6D:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x6E
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0xF000)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x6D
_0x6E:
	RJMP _0x3E
; 0000 01F2         case 3:
_0x6B:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x6F
; 0000 01F3         for(l=0;l<16;l++){buff[l]|=0xe000;}break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x71:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x72
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0xE000)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x71
_0x72:
	RJMP _0x3E
; 0000 01F4         case 2:
_0x6F:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x73
; 0000 01F5         for(l=0;l<16;l++){buff[l]|=0xc000;}break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x75:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x76
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0xC000)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x75
_0x76:
	RJMP _0x3E
; 0000 01F6         case 1:
_0x73:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x3E
; 0000 01F7         for(l=0;l<16;l++){buff[l]|=0x8000;}break;
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x79:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x7A
	CALL SUBOPT_0x4
	ORI  R31,HIGH(0x8000)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x79
_0x7A:
; 0000 01F8         }
_0x3E:
; 0000 01F9 
; 0000 01FA         }
	__ADDWRN 16,17,1
	RJMP _0x3A
_0x3B:
; 0000 01FB         for(k=0;k<MoveSpeed;k++){
	__GETWRN 20,21,0
_0x7C:
	__CPWRN 20,21,10
	BRGE _0x7D
; 0000 01FC              for(i=0;i<16;i++){
	__GETWRN 16,17,0
_0x7F:
	__CPWRN 16,17,16
	BRGE _0x80
; 0000 01FD                 if(Toggle){
	SBIS 0x1E,2
	RJMP _0x81
; 0000 01FE                 PORT0=0xff;
	CALL SUBOPT_0x6
; 0000 01FF                 PORT2=OrangeLed_Clk0;
; 0000 0200                 PORT2=CP_Enable;
; 0000 0201 
; 0000 0202                 PORT0=0xff;
; 0000 0203                 PORT2=OrangeLed_Clk1;
; 0000 0204                 PORT2=CP_Enable;
; 0000 0205 
; 0000 0206                 sum=buff[i];
	CALL SUBOPT_0x7
; 0000 0207                 PORT0=(sum&0xff);
; 0000 0208                 PORT2=RedLed_Clk0;
	CALL SUBOPT_0x8
; 0000 0209                 PORT2=CP_Enable;
; 0000 020A 
; 0000 020B                 PORT0=(sum>>8);
	CALL SUBOPT_0x9
	RJMP _0x166
; 0000 020C                 PORT2=RedLed_Clk1;
; 0000 020D                 PORT2=CP_Enable;
; 0000 020E                 }
; 0000 020F                 else
_0x81:
; 0000 0210                 {
; 0000 0211                 sum=buff[i];
	CALL SUBOPT_0x1
	CALL SUBOPT_0x7
; 0000 0212                 PORT0=sum&0xff;
; 0000 0213                 PORT2=OrangeLed_Clk0;
	CALL SUBOPT_0xA
; 0000 0214                 PORT2=CP_Enable;
; 0000 0215 
; 0000 0216                 PORT0=sum>>8;
	STS  258,R30
; 0000 0217                 PORT2=OrangeLed_Clk1;
	LDI  R30,LOW(253)
	CALL SUBOPT_0xB
; 0000 0218                 PORT2=CP_Enable;
; 0000 0219 
; 0000 021A                 PORT0=0xff;
	LDI  R30,LOW(255)
	STS  258,R30
; 0000 021B                 PORT2=RedLed_Clk0;
	CALL SUBOPT_0x8
; 0000 021C                 PORT2=CP_Enable;
; 0000 021D 
; 0000 021E 
; 0000 021F                 PORT0=0xff;
	LDI  R30,LOW(255)
_0x166:
	STS  258,R30
; 0000 0220                 PORT2=RedLed_Clk1;
	LDI  R30,LOW(247)
	CALL SUBOPT_0xB
; 0000 0221                 PORT2=CP_Enable;
; 0000 0222                 }
; 0000 0223 
; 0000 0224 
; 0000 0225                 rowsum=row[i];
	CALL SUBOPT_0xC
; 0000 0226                 PORT0=rowsum&0xff;
; 0000 0227                 PORT2=Row_Clk0;
; 0000 0228                 PORT2=CP_Enable;
; 0000 0229 
; 0000 022A 
; 0000 022B                 PORT0=rowsum>>8;
	CALL SUBOPT_0xD
; 0000 022C                 PORT2=Row_Clk1;
; 0000 022D                 PORT2=CP_Enable;
; 0000 022E                 delay_ms(1);
	CALL SUBOPT_0xE
; 0000 022F 
; 0000 0230             }
	__ADDWRN 16,17,1
	RJMP _0x7F
_0x80:
; 0000 0231         }
	__ADDWRN 20,21,1
	RJMP _0x7C
_0x7D:
; 0000 0232 
; 0000 0233      }
	__SUBWRN 18,19,1
	RJMP _0x37
_0x38:
; 0000 0234      #endif
; 0000 0235 
; 0000 0236      for(j=0;j<16;j++){
	__GETWRN 18,19,0
_0x84:
	__CPWRN 18,19,16
	BRLT PC+3
	JMP _0x85
; 0000 0237         for(i=0;i<16;i++){   //ڸ ߾ӿ  Ʈ 
	__GETWRN 16,17,0
_0x87:
	__CPWRN 16,17,16
	BRLT PC+3
	JMP _0x88
; 0000 0238         buff[i]=str5[timeCnt][i]<<j;
	CALL SUBOPT_0x1
	CALL SUBOPT_0x2
	CALL __LSLW12
	CALL SUBOPT_0x3
; 0000 0239         switch(j){    //ڰ ̵ÿ 鿡 led offϱ  ̴. ذ  ɽÿ switch ּó Ͽ غ ˼ ̴.                */
; 0000 023A          case 15:for(l=0;l<16;l++){buff[l]|=0xffff;} break;
	BRNE _0x8C
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x8E:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x8F
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFFF)
	ORI  R31,HIGH(0xFFFF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x8E
_0x8F:
	RJMP _0x8B
; 0000 023B         case 14:for(l=0;l<16;l++){buff[l]|=0x7fff;}break;
_0x8C:
	CPI  R30,LOW(0xE)
	LDI  R26,HIGH(0xE)
	CPC  R31,R26
	BRNE _0x90
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x92:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x93
	CALL SUBOPT_0x4
	ORI  R30,LOW(0x7FFF)
	ORI  R31,HIGH(0x7FFF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x92
_0x93:
	RJMP _0x8B
; 0000 023C         case 13:for(l=0;l<16;l++){buff[l]|=0x3fff;} break;
_0x90:
	CPI  R30,LOW(0xD)
	LDI  R26,HIGH(0xD)
	CPC  R31,R26
	BRNE _0x94
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x96:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x97
	CALL SUBOPT_0x4
	ORI  R30,LOW(0x3FFF)
	ORI  R31,HIGH(0x3FFF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x96
_0x97:
	RJMP _0x8B
; 0000 023D         case 12:for(l=0;l<16;l++){buff[l]|=0x1fff;} break;
_0x94:
	CPI  R30,LOW(0xC)
	LDI  R26,HIGH(0xC)
	CPC  R31,R26
	BRNE _0x98
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x9A:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x9B
	CALL SUBOPT_0x4
	ORI  R30,LOW(0x1FFF)
	ORI  R31,HIGH(0x1FFF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x9A
_0x9B:
	RJMP _0x8B
; 0000 023E         case 11:for(l=0;l<16;l++){buff[l]|=0x0fff;}break;
_0x98:
	CPI  R30,LOW(0xB)
	LDI  R26,HIGH(0xB)
	CPC  R31,R26
	BRNE _0x9C
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0x9E:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0x9F
	CALL SUBOPT_0x4
	ORI  R30,LOW(0xFFF)
	ORI  R31,HIGH(0xFFF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0x9E
_0x9F:
	RJMP _0x8B
; 0000 023F         case 10:for(l=0;l<16;l++){buff[l]|=0x07ff;}break;
_0x9C:
	CPI  R30,LOW(0xA)
	LDI  R26,HIGH(0xA)
	CPC  R31,R26
	BRNE _0xA0
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xA2:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xA3
	CALL SUBOPT_0x4
	ORI  R30,LOW(0x7FF)
	ORI  R31,HIGH(0x7FF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0xA2
_0xA3:
	RJMP _0x8B
; 0000 0240         case 9:for(l=0;l<16;l++){buff[l]|=0x03ff;}break;
_0xA0:
	CPI  R30,LOW(0x9)
	LDI  R26,HIGH(0x9)
	CPC  R31,R26
	BRNE _0xA4
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xA6:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xA7
	CALL SUBOPT_0x4
	ORI  R30,LOW(0x3FF)
	ORI  R31,HIGH(0x3FF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0xA6
_0xA7:
	RJMP _0x8B
; 0000 0241         case 8:for(l=0;l<16;l++){buff[l]|=0x01ff;}break;
_0xA4:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0xA8
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xAA:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xAB
	CALL SUBOPT_0x4
	ORI  R30,LOW(0x1FF)
	ORI  R31,HIGH(0x1FF)
	ST   -X,R31
	ST   -X,R30
	CALL SUBOPT_0x5
	RJMP _0xAA
_0xAB:
	RJMP _0x8B
; 0000 0242         case 7:for(l=0;l<16;l++){buff[l]|=0x00ff;} break;
_0xA8:
	CPI  R30,LOW(0x7)
	LDI  R26,HIGH(0x7)
	CPC  R31,R26
	BRNE _0xAC
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xAE:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xAF
	CALL SUBOPT_0xF
	ORI  R30,LOW(0xFF)
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xAE
_0xAF:
	RJMP _0x8B
; 0000 0243         case 6:for(l=0;l<16;l++){buff[l]|=0x007f;}break;
_0xAC:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0xB0
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xB2:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xB3
	CALL SUBOPT_0xF
	ORI  R30,LOW(0x7F)
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xB2
_0xB3:
	RJMP _0x8B
; 0000 0244         case 5:for(l=0;l<16;l++){buff[l]|=0x003f;} break;
_0xB0:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0xB4
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xB6:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xB7
	CALL SUBOPT_0xF
	ORI  R30,LOW(0x3F)
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xB6
_0xB7:
	RJMP _0x8B
; 0000 0245         case 4:for(l=0;l<16;l++){buff[l]|=0x001f;} break;
_0xB4:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0xB8
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xBA:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xBB
	CALL SUBOPT_0xF
	ORI  R30,LOW(0x1F)
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xBA
_0xBB:
	RJMP _0x8B
; 0000 0246         case 3:for(l=0;l<16;l++){buff[l]|=0x000f;}break;
_0xB8:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0xBC
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xBE:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xBF
	CALL SUBOPT_0xF
	ORI  R30,LOW(0xF)
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xBE
_0xBF:
	RJMP _0x8B
; 0000 0247         case 2:for(l=0;l<16;l++){buff[l]|=0x0007;}break;
_0xBC:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0xC0
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xC2:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xC3
	CALL SUBOPT_0xF
	ORI  R30,LOW(0x7)
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xC2
_0xC3:
	RJMP _0x8B
; 0000 0248         case 1:for(l=0;l<16;l++){buff[l]|=0x0003;}break;
_0xC0:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0xC4
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xC6:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xC7
	CALL SUBOPT_0xF
	ORI  R30,LOW(0x3)
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xC6
_0xC7:
	RJMP _0x8B
; 0000 0249         case 0:for(l=0;l<16;l++){buff[l]|=0x0001;}break;
_0xC4:
	SBIW R30,0
	BRNE _0x8B
	LDI  R30,LOW(0)
	STD  Y+6,R30
	STD  Y+6+1,R30
_0xCA:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SBIW R26,16
	BRGE _0xCB
	CALL SUBOPT_0xF
	ORI  R30,1
	ST   X,R30
	CALL SUBOPT_0x5
	RJMP _0xCA
_0xCB:
; 0000 024A 
; 0000 024B            }
_0x8B:
; 0000 024C       }
	__ADDWRN 16,17,1
	RJMP _0x87
_0x88:
; 0000 024D 
; 0000 024E          for(k=0;k<MoveSpeed;k++){
	__GETWRN 20,21,0
_0xCD:
	__CPWRN 20,21,10
	BRGE _0xCE
; 0000 024F              for(i=0;i<16;i++){
	__GETWRN 16,17,0
_0xD0:
	__CPWRN 16,17,16
	BRGE _0xD1
; 0000 0250                if(Toggle){
	SBIS 0x1E,2
	RJMP _0xD2
; 0000 0251                 PORT0=0xff;
	CALL SUBOPT_0x6
; 0000 0252                 PORT2=OrangeLed_Clk0;
; 0000 0253                 PORT2=CP_Enable;
; 0000 0254 
; 0000 0255                 PORT0=0xff;
; 0000 0256                 PORT2=OrangeLed_Clk1;
; 0000 0257                 PORT2=CP_Enable;
; 0000 0258 
; 0000 0259                 sum=buff[i];
	CALL SUBOPT_0x7
; 0000 025A                 PORT0=(sum&0xff);
; 0000 025B                 PORT2=RedLed_Clk0;
	CALL SUBOPT_0x8
; 0000 025C                 PORT2=CP_Enable;
; 0000 025D 
; 0000 025E                 PORT0=(sum>>8);
	CALL SUBOPT_0x9
	STS  258,R30
; 0000 025F                 PORT2=RedLed_Clk1;
	LDI  R30,LOW(247)
	RJMP _0x167
; 0000 0260                 PORT2=CP_Enable;
; 0000 0261                 }
; 0000 0262                 else
_0xD2:
; 0000 0263                 {
; 0000 0264                 PORT0=0xff;
	LDI  R30,LOW(255)
	STS  258,R30
; 0000 0265                 PORT2=RedLed_Clk0;
	CALL SUBOPT_0x8
; 0000 0266                 PORT2=CP_Enable;
; 0000 0267 
; 0000 0268 
; 0000 0269                 PORT0=0xff;
	LDI  R30,LOW(255)
	STS  258,R30
; 0000 026A                 PORT2=RedLed_Clk1;
	LDI  R30,LOW(247)
	CALL SUBOPT_0xB
; 0000 026B                 PORT2=CP_Enable;
; 0000 026C 
; 0000 026D                 sum=buff[i];
	CALL SUBOPT_0x1
	CALL SUBOPT_0x7
; 0000 026E                 PORT0=(sum&0xff);
; 0000 026F                 PORT2=OrangeLed_Clk0;
	CALL SUBOPT_0xA
; 0000 0270                 PORT2=CP_Enable;
; 0000 0271 
; 0000 0272                 PORT0=(sum>>8);
	STS  258,R30
; 0000 0273                 PORT2=OrangeLed_Clk1;
	LDI  R30,LOW(253)
_0x167:
	STS  264,R30
; 0000 0274                 PORT2=CP_Enable;
	LDI  R30,LOW(255)
	STS  264,R30
; 0000 0275                 }
; 0000 0276 
; 0000 0277 
; 0000 0278                 rowsum=row[i];
	CALL SUBOPT_0xC
; 0000 0279                 PORT0=rowsum&0xff;
; 0000 027A                 PORT2=Row_Clk0;
; 0000 027B                 PORT2=CP_Enable;
; 0000 027C 
; 0000 027D 
; 0000 027E                 PORT0=rowsum>>8;
	CALL SUBOPT_0xD
; 0000 027F                 PORT2=Row_Clk1;
; 0000 0280                 PORT2=CP_Enable;
; 0000 0281                 delay_ms(1);
	CALL SUBOPT_0xE
; 0000 0282 
; 0000 0283             }
	__ADDWRN 16,17,1
	RJMP _0xD0
_0xD1:
; 0000 0284         }
	__ADDWRN 20,21,1
	RJMP _0xCD
_0xCE:
; 0000 0285 
; 0000 0286     }
	__ADDWRN 18,19,1
	RJMP _0x84
_0x85:
; 0000 0287     timeCnt++; //ڰ ƮƮ   ڷ ٲ
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	__ADDWRR 13,14,30,31
; 0000 0288     Toggle^=1;
	LDI  R26,0
	SBIC 0x1E,2
	LDI  R26,1
	EOR  R30,R26
	BRNE _0xD4
	CBI  0x1E,2
	RJMP _0xD5
_0xD4:
	SBI  0x1E,2
_0xD5:
; 0000 0289         if(timeCnt==48)
	LDI  R30,LOW(48)
	LDI  R31,HIGH(48)
	CP   R30,R13
	CPC  R31,R14
	BRNE _0xD6
; 0000 028A     {
; 0000 028B         timeCnt=0;
	CLR  R13
	CLR  R14
; 0000 028C         }
; 0000 028D 
; 0000 028E }
_0xD6:
	CALL __LOADLOCR6
	ADIW R28,8
	RET
;//----------------------------------------------------
;char gbuf[128][8];
;//----------------------------------------------------
;//----------------------------------------------------
;void dsp_str(char n)
; 0000 0294 {
_dsp_str:
; 0000 0295    delay_us(30); lcd_di=1; lcd_dt=n; //data
;	n -> Y+0
	__DELAY_USB 160
	SBI  0x2,0
	LD   R30,Y
	STS  261,R30
; 0000 0296    lcd_en=1; #asm("nop"); lcd_en=0;  //on->off
	SBI  0x2,2
	nop
	CBI  0x2,2
; 0000 0297 }
	JMP  _0x2060001
;//----------------------------------------------------
;void dsp_cmd(char n)
; 0000 029A {
_dsp_cmd:
; 0000 029B    delay_us(30); lcd_di=0; lcd_dt=n; //data
;	n -> Y+0
	__DELAY_USB 160
	CBI  0x2,0
	LD   R30,Y
	STS  261,R30
; 0000 029C    lcd_en=1; #asm("nop"); lcd_en=0;  //on->off
	SBI  0x2,2
	nop
	CBI  0x2,2
; 0000 029D }
	JMP  _0x2060001
;//----------------------------------------------------
;void lcd_init()
; 0000 02A0 {
_lcd_init:
; 0000 02A1    lcd_s1=1;
	SBI  0x2,4
; 0000 02A2    lcd_s2=1; //page0,1
	SBI  0x2,5
; 0000 02A3    dsp_cmd(0x3f);
	LDI  R30,LOW(63)
	ST   -Y,R30
	RCALL _dsp_cmd
; 0000 02A4    dsp_cmd(0xc0);
	LDI  R30,LOW(192)
	RJMP _0x2060002
; 0000 02A5 }
;//----------------------------------------------------
;void set_page0() { lcd.x=0x40; lcd_pg=0; }
; 0000 02A7 void set_page0() { lcd.x=0x40; lcd_pg=0; }
_set_page0:
	LDI  R30,LOW(64)
	__PUTB1MN _lcd,1
	CBI  0x1E,4
	RET
;void set_page1() { lcd.x=0x40; lcd_pg=1; }
; 0000 02A8 void set_page1() { lcd.x=0x40; lcd_pg=1; }
_set_page1:
	LDI  R30,LOW(64)
	__PUTB1MN _lcd,1
	SBI  0x1E,4
	RET
;
;void dsp_addr()
; 0000 02AB {
_dsp_addr:
; 0000 02AC    if(lcd_pg) { lcd_s1=0; lcd_s2=1; } //page1?
	SBIS 0x1E,4
	RJMP _0xEB
	CBI  0x2,4
	SBI  0x2,5
; 0000 02AD    else       { lcd_s1=1; lcd_s2=0; } //page0
	RJMP _0xF0
_0xEB:
	SBI  0x2,4
	CBI  0x2,5
_0xF0:
; 0000 02AE    dsp_cmd(lcd.y);
	__GETB1MN _lcd,2
	ST   -Y,R30
	RCALL _dsp_cmd
; 0000 02AF    dsp_cmd(lcd.x);
	__GETB1MN _lcd,1
_0x2060002:
	ST   -Y,R30
	RCALL _dsp_cmd
; 0000 02B0 }
	RET
; void dsp_nul(char n)
; 0000 02B2 {
; 0000 02B3    char i; dsp_addr();
;	n -> Y+1
;	i -> R17
; 0000 02B4    for(i=0; i<n; ++i)///64  Ŭ Ų.
; 0000 02B5    dsp_str(0);
; 0000 02B6 }
;void dsp_nul2(char n)
; 0000 02B8 {
_dsp_nul2:
; 0000 02B9    char i;
; 0000 02BA    dsp_addr(); // ǥ 
	ST   -Y,R17
;	n -> Y+1
;	i -> R17
	RCALL _dsp_addr
; 0000 02BB    lcd.bf=0;  // ä
	LDI  R30,LOW(0)
	STS  _lcd,R30
; 0000 02BC    if(lcd_blk)
	SBIS 0x1E,5
	RJMP _0xF8
; 0000 02BD    lcd.bf=~lcd.bf;
	CALL SUBOPT_0x10
; 0000 02BE    for(i=0; i<n; ++i) //nŭ ϸ 
_0xF8:
	LDI  R17,LOW(0)
_0xFA:
	LDD  R30,Y+1
	CP   R17,R30
	BRSH _0xFB
; 0000 02BF     dsp_str(lcd.bf);
	CALL SUBOPT_0x11
	SUBI R17,-LOW(1)
	RJMP _0xFA
_0xFB:
; 0000 02C0 ++lcd.y;
	CALL SUBOPT_0x12
; 0000 02C1     dsp_addr();
; 0000 02C2     lcd.bf=0;
	LDI  R30,LOW(0)
	STS  _lcd,R30
; 0000 02C3    if(lcd_blk)
	SBIS 0x1E,5
	RJMP _0xFC
; 0000 02C4    { lcd.bf=~lcd.bf; lcd.bf&=~0x80; }
	CALL SUBOPT_0x10
	LDS  R30,_lcd
	ANDI R30,0x7F
	STS  _lcd,R30
; 0000 02C5    for(i=0; i<n; ++i)
_0xFC:
	LDI  R17,LOW(0)
_0xFE:
	LDD  R30,Y+1
	CP   R17,R30
	BRSH _0xFF
; 0000 02C6    dsp_str(lcd.bf);
	CALL SUBOPT_0x11
	SUBI R17,-LOW(1)
	RJMP _0xFE
_0xFF:
; 0000 02C7 lcd.x+=n;
	__GETB1MN _lcd,1
	LDD  R26,Y+1
	ADD  R30,R26
	CALL SUBOPT_0x13
; 0000 02C8    lcd.y=lcd.ty;
; 0000 02C9 }
	LDD  R17,Y+0
	ADIW R28,2
	RET
;void lcd_clear()
; 0000 02CB {
; 0000 02CC    char i;
; 0000 02CD    lcd.x=0x40; lcd.y=0xb8;
;	i -> R17
; 0000 02CE    for(i=0; i<8; ++i) {
; 0000 02CF      lcd_pg=0;
; 0000 02D0      dsp_nul(64);
; 0000 02D1      lcd_pg=1;
; 0000 02D2       dsp_nul(64);
; 0000 02D3      ++lcd.y;
; 0000 02D4 
; 0000 02D5 
; 0000 02D6    }
; 0000 02D7 }
;void dsp_han(flash char *p, char n)
; 0000 02D9 {
_dsp_han:
; 0000 02DA    char i, bf1, bf2;
; 0000 02DB    static int cnt=0;
; 0000 02DC      static int cnt2=0;
; 0000 02DD       static int cnt3=0;
; 0000 02DE    bf1=n*12;//ù° ڿ ũ⸦ Ȯ
	CALL __SAVELOCR4
;	*p -> Y+5
;	n -> Y+4
;	i -> R17
;	bf1 -> R16
;	bf2 -> R19
	LDD  R30,Y+4
	LDI  R26,LOW(12)
	MULS R30,R26
	MOV  R16,R0
; 0000 02DF    dsp_addr();/// ǥ Ȯ
	RCALL _dsp_addr
; 0000 02E0    for(i=0; i<bf1; ++i) {  //ڿ ũ⸸ŭ  
	LDI  R17,LOW(0)
_0x108:
	CP   R17,R16
	BRSH _0x109
; 0000 02E1       lcd.bf=p[i];
	CALL SUBOPT_0x14
; 0000 02E2       if(lcd_blk) lcd.bf=~lcd.bf; //  
	SBIS 0x1E,5
	RJMP _0x10A
	CALL SUBOPT_0x10
; 0000 02E3        dsp_str(lcd.bf); //Ÿ 
_0x10A:
	CALL SUBOPT_0x11
; 0000 02E4    }
	SUBI R17,-LOW(1)
	RJMP _0x108
_0x109:
; 0000 02E5     bf2=bf1*2;  //2°  ũ 
	MOV  R30,R16
	LSL  R30
	MOV  R19,R30
; 0000 02E6     ++lcd.y; //lcd y adrees 0xb9 2°  
	CALL SUBOPT_0x12
; 0000 02E7     dsp_addr(); /// ǥ Ȯ
; 0000 02E8    for(i=bf1; i<bf2; ++i) {
	MOV  R17,R16
_0x10C:
	CP   R17,R19
	BRSH _0x10D
; 0000 02E9       lcd.bf=p[i];
	CALL SUBOPT_0x14
; 0000 02EA       if(lcd_blk)
	SBIS 0x1E,5
	RJMP _0x10E
; 0000 02EB        { lcd.bf=~lcd.bf; lcd.bf&=~0x80; }
	CALL SUBOPT_0x10
	LDS  R30,_lcd
	ANDI R30,0x7F
	STS  _lcd,R30
; 0000 02EC         dsp_str(lcd.bf);
_0x10E:
	CALL SUBOPT_0x11
; 0000 02ED    }
	SUBI R17,-LOW(1)
	RJMP _0x10C
_0x10D:
; 0000 02EE 
; 0000 02EF    lcd.x+=bf1; //lcd y address  0x4c مd ,   ǥ  
	__GETB1MN _lcd,1
	ADD  R30,R16
	CALL SUBOPT_0x13
; 0000 02F0    lcd.y=lcd.ty; //lcd xǥ 0xb8 
; 0000 02F1 }
	CALL __LOADLOCR4
	ADIW R28,7
	RET
;void first()
; 0000 02F3 {
_first:
; 0000 02F4     set_page0();
	RCALL _set_page0
; 0000 02F5     lcd.ty=lcd.y=0xb8;///ù° 
	CALL SUBOPT_0x15
; 0000 02F6     lcd_blk=1;
; 0000 02F7     dsp_nul2(28);
	CALL SUBOPT_0x16
; 0000 02F8     dsp_han(han[0],1);
	LDI  R30,LOW(_han*2)
	LDI  R31,HIGH(_han*2)
	CALL SUBOPT_0x17
; 0000 02F9     dsp_han(han[1],1);
	__POINTW1FN _han,24
	CALL SUBOPT_0x17
; 0000 02FA     dsp_han(han[2],1);
	__POINTW1FN _han,48
	CALL SUBOPT_0x17
; 0000 02FB 
; 0000 02FC     set_page1();
	RCALL _set_page1
; 0000 02FD     lcd.ty=lcd.y=0xb8;
	CALL SUBOPT_0x15
; 0000 02FE     lcd_blk=1;
; 0000 02FF     dsp_han(han[3],1);
	__POINTW1FN _han,72
	CALL SUBOPT_0x17
; 0000 0300     dsp_han(han[4],1);
	__POINTW1FN _han,96
	CALL SUBOPT_0x17
; 0000 0301     dsp_han(han[5],1); dsp_nul2(28);
	__POINTW1FN _han,120
	CALL SUBOPT_0x17
	CALL SUBOPT_0x16
; 0000 0302 
; 0000 0303 }
	RET
;void second()
; 0000 0305 {
_second:
; 0000 0306     switch(SecCnt)
	CALL SUBOPT_0x18
; 0000 0307     {
; 0000 0308     case 0: //avr
	BRNE _0x116
; 0000 0309     set_page0();
	CALL SUBOPT_0x19
; 0000 030A     lcd.ty=lcd.y=0xba; //2° 
; 0000 030B     lcd_blk=0;
; 0000 030C     dsp_nul2(16);
; 0000 030D     dsp_han(han[30],1);
	__POINTW1FN _han,720
	CALL SUBOPT_0x17
; 0000 030E     dsp_han(han[31],1);
	__POINTW1FN _han,744
	CALL SUBOPT_0x17
; 0000 030F     dsp_han(han[32],1);
	__POINTW1FN _han,768
	CALL SUBOPT_0x17
; 0000 0310     dsp_han(han[33],1);
	__POINTW1FN _han,792
	CALL SUBOPT_0x17
; 0000 0311     set_page1();
	CALL SUBOPT_0x1A
; 0000 0312     lcd.ty=lcd.y=0xba;
; 0000 0313     lcd_blk=0;
; 0000 0314     dsp_han(han[34],1);
	__POINTW1FN _han,816
	CALL SUBOPT_0x17
; 0000 0315     dsp_han(han[35],1);
	__POINTW1FN _han,840
	CALL SUBOPT_0x17
; 0000 0316     dsp_han(han[26],1);
	CALL SUBOPT_0x1B
; 0000 0317     dsp_han(han[27],1);
	CALL SUBOPT_0x1C
; 0000 0318     dsp_nul2(16);
	LDI  R30,LOW(16)
	RJMP _0x168
; 0000 0319     break;
; 0000 031A     case 5:
_0x116:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0x115
; 0000 031B     set_page0();
	CALL SUBOPT_0x19
; 0000 031C     lcd.ty=lcd.y=0xba; //2° 
; 0000 031D     lcd_blk=0;
; 0000 031E     dsp_nul2(16);
; 0000 031F     dsp_han(han[36],1);
	__POINTW1FN _han,864
	CALL SUBOPT_0x17
; 0000 0320     dsp_han(han[37],1);
	__POINTW1FN _han,888
	CALL SUBOPT_0x17
; 0000 0321     dsp_han(han[38],1);
	__POINTW1FN _han,912
	CALL SUBOPT_0x17
; 0000 0322     dsp_han(han[39],1);
	__POINTW1FN _han,936
	CALL SUBOPT_0x17
; 0000 0323     set_page1();
	CALL SUBOPT_0x1A
; 0000 0324     lcd.ty=lcd.y=0xba;
; 0000 0325     lcd_blk=0;
; 0000 0326      dsp_han(han[40],1);
	__POINTW1FN _han,960
	CALL SUBOPT_0x17
; 0000 0327     dsp_han(han[60],1);
	__POINTW1FN _han,1440
	CALL SUBOPT_0x17
; 0000 0328     dsp_han(han[61],1);
	__POINTW1FN _han,1464
	CALL SUBOPT_0x17
; 0000 0329     dsp_han(han[44],1);
	__POINTW1FN _han,1056
	CALL SUBOPT_0x17
; 0000 032A     dsp_han(han[45],1);
	__POINTW1FN _han,1080
	CALL SUBOPT_0x17
; 0000 032B     dsp_nul2(3);
	LDI  R30,LOW(3)
_0x168:
	ST   -Y,R30
	RCALL _dsp_nul2
; 0000 032C     break;
; 0000 032D     }
_0x115:
; 0000 032E 
; 0000 032F 
; 0000 0330 }
	RET
;
;void third()
; 0000 0333 {
_third:
; 0000 0334     switch(SecCnt)
	CALL SUBOPT_0x18
; 0000 0335     {
; 0000 0336     case 0: //avr
	BRNE _0x123
; 0000 0337     set_page0();
	CALL SUBOPT_0x1D
; 0000 0338     lcd.ty=lcd.y=0xbc; //3° 
; 0000 0339     lcd_blk=1;
; 0000 033A      dsp_nul2(4);
; 0000 033B     dsp_han(han[13],1);
	__POINTW1FN _han,312
	CALL SUBOPT_0x17
; 0000 033C     dsp_han(han[14],1);
	__POINTW1FN _han,336
	CALL SUBOPT_0x17
; 0000 033D     dsp_han(han[15],1);
	__POINTW1FN _han,360
	CALL SUBOPT_0x17
; 0000 033E     dsp_han(han[52],1);
	CALL SUBOPT_0x1E
; 0000 033F     dsp_han(han[53],1);
	CALL SUBOPT_0x1F
; 0000 0340     set_page1();
	CALL SUBOPT_0x20
; 0000 0341     lcd.ty=lcd.y=0xbc;
; 0000 0342     lcd_blk=1;
; 0000 0343 
; 0000 0344     dsp_han(han[54],1);
; 0000 0345     dsp_han(han[26],1);
	CALL SUBOPT_0x1B
; 0000 0346     dsp_han(han[27],1);
	CALL SUBOPT_0x1C
; 0000 0347     dsp_han(han[24],1);
	CALL SUBOPT_0x21
; 0000 0348     dsp_han(han[25],1);
	CALL SUBOPT_0x22
; 0000 0349     dsp_nul2(5);
	CALL SUBOPT_0x23
; 0000 034A     break;
	RJMP _0x122
; 0000 034B 
; 0000 034C     case 2: //pic
_0x123:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x128
; 0000 034D     set_page0();
	CALL SUBOPT_0x1D
; 0000 034E     lcd.ty=lcd.y=0xbc; //3° 
; 0000 034F     lcd_blk=1;
; 0000 0350      dsp_nul2(4);
; 0000 0351     dsp_han(han[16],1);
	__POINTW1FN _han,384
	CALL SUBOPT_0x17
; 0000 0352     dsp_han(han[17],1);
	__POINTW1FN _han,408
	CALL SUBOPT_0x17
; 0000 0353     dsp_han(han[18],1);
	__POINTW1FN _han,432
	CALL SUBOPT_0x17
; 0000 0354     dsp_han(han[52],1);
	CALL SUBOPT_0x1E
; 0000 0355     dsp_han(han[53],1);
	CALL SUBOPT_0x1F
; 0000 0356     set_page1();
	CALL SUBOPT_0x20
; 0000 0357     lcd.ty=lcd.y=0xbc;
; 0000 0358     lcd_blk=1;
; 0000 0359 
; 0000 035A     dsp_han(han[54],1);
; 0000 035B     dsp_han(han[26],1);
	CALL SUBOPT_0x1B
; 0000 035C     dsp_han(han[27],1);
	CALL SUBOPT_0x1C
; 0000 035D     dsp_han(han[24],1);
	CALL SUBOPT_0x21
; 0000 035E     dsp_han(han[25],1);
	CALL SUBOPT_0x22
; 0000 035F     dsp_nul2(5);
	CALL SUBOPT_0x23
; 0000 0360     break;
	RJMP _0x122
; 0000 0361     case 4: //arm
_0x128:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x12D
; 0000 0362     set_page0();
	CALL SUBOPT_0x1D
; 0000 0363     lcd.ty=lcd.y=0xbc; //3° 
; 0000 0364     lcd_blk=1;
; 0000 0365      dsp_nul2(4);
; 0000 0366     dsp_han(han[21],1);
	__POINTW1FN _han,504
	CALL SUBOPT_0x17
; 0000 0367     dsp_han(han[46],1);
	__POINTW1FN _han,1104
	CALL SUBOPT_0x17
; 0000 0368     dsp_han(han[47],1);
	__POINTW1FN _han,1128
	CALL SUBOPT_0x17
; 0000 0369     dsp_han(han[52],1);
	CALL SUBOPT_0x1E
; 0000 036A     dsp_han(han[53],1);
	CALL SUBOPT_0x1F
; 0000 036B     set_page1();
	CALL SUBOPT_0x20
; 0000 036C     lcd.ty=lcd.y=0xbc;
; 0000 036D     lcd_blk=1;
; 0000 036E 
; 0000 036F     dsp_han(han[54],1);
; 0000 0370     dsp_han(han[26],1);
	CALL SUBOPT_0x1B
; 0000 0371     dsp_han(han[27],1);
	CALL SUBOPT_0x1C
; 0000 0372     dsp_han(han[24],1);
	CALL SUBOPT_0x21
; 0000 0373     dsp_han(han[25],1);
	CALL SUBOPT_0x22
; 0000 0374     dsp_nul2(5);
	CALL SUBOPT_0x23
; 0000 0375     break;
	RJMP _0x122
; 0000 0376 
; 0000 0377     case 6: //pcb
_0x12D:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0x132
; 0000 0378     set_page0();
	CALL SUBOPT_0x1D
; 0000 0379     lcd.ty=lcd.y=0xbc; //3° 
; 0000 037A     lcd_blk=1;
; 0000 037B      dsp_nul2(4);
; 0000 037C     dsp_han(han[55],1);
	__POINTW1FN _han,1320
	CALL SUBOPT_0x17
; 0000 037D     dsp_han(han[56],1);
	__POINTW1FN _han,1344
	CALL SUBOPT_0x17
; 0000 037E     dsp_han(han[57],1);
	__POINTW1FN _han,1368
	CALL SUBOPT_0x17
; 0000 037F     dsp_han(han[50],1);
	__POINTW1FN _han,1200
	CALL SUBOPT_0x17
; 0000 0380     dsp_han(han[51],1);
	__POINTW1FN _han,1224
	CALL SUBOPT_0x17
; 0000 0381     set_page1();
	CALL SUBOPT_0x24
; 0000 0382     lcd.ty=lcd.y=0xbc;
; 0000 0383     lcd_blk=1;
; 0000 0384 
; 0000 0385     dsp_han(han[26],1);
	CALL SUBOPT_0x1B
; 0000 0386     dsp_han(han[27],1);
	CALL SUBOPT_0x1C
; 0000 0387     dsp_han(han[24],1);
	CALL SUBOPT_0x21
; 0000 0388     dsp_han(han[25],1);
	CALL SUBOPT_0x22
; 0000 0389  //   dsp_han(han[25],1);
; 0000 038A     dsp_nul2(15);
	LDI  R30,LOW(15)
	ST   -Y,R30
	RCALL _dsp_nul2
; 0000 038B     break;
	RJMP _0x122
; 0000 038C 
; 0000 038D      case 8: //pcb
_0x132:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0x122
; 0000 038E     set_page0();
	CALL SUBOPT_0x1D
; 0000 038F     lcd.ty=lcd.y=0xbc; //3° 
; 0000 0390     lcd_blk=1;
; 0000 0391      dsp_nul2(4);
; 0000 0392     dsp_han(han[30],1);
	__POINTW1FN _han,720
	CALL SUBOPT_0x17
; 0000 0393     dsp_han(han[31],1);
	__POINTW1FN _han,744
	CALL SUBOPT_0x17
; 0000 0394     dsp_han(han[48],1);
	__POINTW1FN _han,1152
	CALL SUBOPT_0x17
; 0000 0395     dsp_han(han[49],1);
	__POINTW1FN _han,1176
	CALL SUBOPT_0x17
; 0000 0396     dsp_han(han[50],1);
	__POINTW1FN _han,1200
	CALL SUBOPT_0x17
; 0000 0397     set_page1();
	CALL SUBOPT_0x24
; 0000 0398     lcd.ty=lcd.y=0xbc;
; 0000 0399     lcd_blk=1;
; 0000 039A 
; 0000 039B     dsp_han(han[51],1);
	__POINTW1FN _han,1224
	CALL SUBOPT_0x17
; 0000 039C     dsp_han(han[26],1);
	CALL SUBOPT_0x1B
; 0000 039D     dsp_han(han[27],1);
	CALL SUBOPT_0x1C
; 0000 039E     dsp_han(han[24],1);
	CALL SUBOPT_0x21
; 0000 039F     dsp_han(han[25],1);
	CALL SUBOPT_0x22
; 0000 03A0     //dsp_nul2(15);
; 0000 03A1     break;
; 0000 03A2     }
_0x122:
; 0000 03A3 
; 0000 03A4 }
	RET
;
;void fourth()
; 0000 03A7 {
_fourth:
; 0000 03A8 
; 0000 03A9 
; 0000 03AA    switch(SecFlag)
	LDI  R30,0
	SBIC 0x1E,6
	LDI  R30,1
; 0000 03AB    {
; 0000 03AC    case 0:
	CPI  R30,0
	BRNE _0x13F
; 0000 03AD     set_page0();
	CALL SUBOPT_0x25
; 0000 03AE     lcd.ty=lcd.y=0xbe; //4° 
; 0000 03AF     lcd_blk=1;
	SBI  0x1E,5
; 0000 03B0     dsp_nul2(40);
	CALL SUBOPT_0x26
; 0000 03B1     dsp_han(han[10],1);
; 0000 03B2     dsp_han(han[11],1);
	__POINTW1FN _han,264
	CALL SUBOPT_0x17
; 0000 03B3 
; 0000 03B4     set_page1();
	CALL SUBOPT_0x27
; 0000 03B5     lcd.ty=lcd.y=0xbe;
; 0000 03B6     lcd_blk=1;
	SBI  0x1E,5
; 0000 03B7 
; 0000 03B8     dsp_han(han[12],1);
	RJMP _0x169
; 0000 03B9     dsp_nul2(1);
; 0000 03BA     dsp_han(han[28],1);
; 0000 03BB     dsp_han(han[29],1);
; 0000 03BC     dsp_nul2(28);
; 0000 03BD     break;
; 0000 03BE     case 1:
_0x13F:
	CPI  R30,LOW(0x1)
	BRNE _0x13E
; 0000 03BF     set_page0();
	CALL SUBOPT_0x25
; 0000 03C0     lcd.ty=lcd.y=0xbe; //4° 
; 0000 03C1     lcd_blk=0;
	CBI  0x1E,5
; 0000 03C2     dsp_nul2(40);
	CALL SUBOPT_0x26
; 0000 03C3     dsp_han(han[10],1);
; 0000 03C4     dsp_han(han[11],1);
	__POINTW1FN _han,264
	CALL SUBOPT_0x17
; 0000 03C5 
; 0000 03C6     set_page1();
	CALL SUBOPT_0x27
; 0000 03C7     lcd.ty=lcd.y=0xbe;
; 0000 03C8     lcd_blk=0;
	CBI  0x1E,5
; 0000 03C9     dsp_han(han[12],1);
_0x169:
	__POINTW1FN _han,288
	CALL SUBOPT_0x17
; 0000 03CA     dsp_nul2(1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _dsp_nul2
; 0000 03CB     dsp_han(han[28],1);
	__POINTW1FN _han,672
	CALL SUBOPT_0x17
; 0000 03CC     dsp_han(han[29],1);
	__POINTW1FN _han,696
	CALL SUBOPT_0x17
; 0000 03CD     dsp_nul2(28);
	CALL SUBOPT_0x16
; 0000 03CE     break;
; 0000 03CF     }
_0x13E:
; 0000 03D0 
; 0000 03D1 
; 0000 03D2 }
	RET
;void main(void)
; 0000 03D4 {
_main:
; 0000 03D5 // Declare your local variables here
; 0000 03D6 
; 0000 03D7 // Crystal Oscillator division factor: 1
; 0000 03D8 #pragma optsize-
; 0000 03D9 CLKPR=0x80;
	LDI  R30,LOW(128)
	STS  97,R30
; 0000 03DA CLKPR=0x00;
	LDI  R30,LOW(0)
	STS  97,R30
; 0000 03DB #ifdef _OPTIMIZE_SIZE_
; 0000 03DC #pragma optsize+
; 0000 03DD #endif
; 0000 03DE 
; 0000 03DF // Input/Output Ports initialization
; 0000 03E0 // Port A initialization
; 0000 03E1 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 03E2 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 03E3 PORTA=0x00;
	OUT  0x2,R30
; 0000 03E4 DDRA=0xFF;
	LDI  R30,LOW(255)
	OUT  0x1,R30
; 0000 03E5 
; 0000 03E6 // Port B initialization
; 0000 03E7 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 03E8 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 03E9 PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x5,R30
; 0000 03EA DDRB=0xff;
	LDI  R30,LOW(255)
	OUT  0x4,R30
; 0000 03EB 
; 0000 03EC // Port D initialization
; 0000 03ED // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 03EE // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 03EF PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
; 0000 03F0 DDRD=0xFF;
	LDI  R30,LOW(255)
	OUT  0xA,R30
; 0000 03F1 
; 0000 03F2 // Port E initialization
; 0000 03F3 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 03F4 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 03F5 PORTE=0x00;
	LDI  R30,LOW(0)
	OUT  0xE,R30
; 0000 03F6 DDRE=0xFF;
	LDI  R30,LOW(255)
	OUT  0xD,R30
; 0000 03F7 
; 0000 03F8 // Port F initialization
; 0000 03F9 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 03FA // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 03FB PORTF=0x00;
	LDI  R30,LOW(0)
	OUT  0x11,R30
; 0000 03FC DDRF=0x00;
	OUT  0x10,R30
; 0000 03FD 
; 0000 03FE // Port G initialization
; 0000 03FF // Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0400 // State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 0401 PORTG=0x00;
	OUT  0x14,R30
; 0000 0402 DDRG=0x00;
	OUT  0x13,R30
; 0000 0403 
; 0000 0404 // Port H initialization
; 0000 0405 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0406 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 0407 PORTH=0xFF;
	LDI  R30,LOW(255)
	STS  258,R30
; 0000 0408 DDRH=0xFF;
	STS  257,R30
; 0000 0409 
; 0000 040A // Port J initialization
; 0000 040B // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 040C // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 040D PORTJ=0x00;
	LDI  R30,LOW(0)
	STS  261,R30
; 0000 040E DDRJ=0xFF;
	LDI  R30,LOW(255)
	STS  260,R30
; 0000 040F 
; 0000 0410 // Port K initialization
; 0000 0411 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0412 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 0413 PORTK=0x00;
	LDI  R30,LOW(0)
	STS  264,R30
; 0000 0414 DDRK=0xFF;
	LDI  R30,LOW(255)
	STS  263,R30
; 0000 0415 
; 0000 0416 // Port L initialization
; 0000 0417 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0418 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
; 0000 0419 PORTL=0x00;
	LDI  R30,LOW(0)
	STS  267,R30
; 0000 041A DDRL=0xff;
	LDI  R30,LOW(255)
	STS  266,R30
; 0000 041B 
; 0000 041C TCCR0A=0x00;//Normal Mode Operation(Overflow Interrupt Enable)
	LDI  R30,LOW(0)
	OUT  0x24,R30
; 0000 041D TCCR0B=0x03;//64Prescale Select
	LDI  R30,LOW(3)
	OUT  0x25,R30
; 0000 041E TCNT0=0x06;// Timer/Count Register initialization
	LDI  R30,LOW(6)
	OUT  0x26,R30
; 0000 041F 
; 0000 0420 // Timer/Counter 1 initialization
; 0000 0421 // Clock source: System Clock
; 0000 0422 // Clock value: Timer1 Stopped
; 0000 0423 // Mode: Normal top=0xFFFF
; 0000 0424 // OC1A output: Discon.
; 0000 0425 // OC1B output: Discon.
; 0000 0426 // OC1C output: Discon.
; 0000 0427 // Noise Canceler: Off
; 0000 0428 // Input Capture on Falling Edge
; 0000 0429 // Timer1 Overflow Interrupt: Off
; 0000 042A // Input Capture Interrupt: Off
; 0000 042B // Compare A Match Interrupt: Off
; 0000 042C // Compare B Match Interrupt: Off
; 0000 042D // Compare C Match Interrupt: Off
; 0000 042E TCCR1A=0x00;
	LDI  R30,LOW(0)
	STS  128,R30
; 0000 042F TCCR1B=0x00;
	STS  129,R30
; 0000 0430 TCNT1H=0x00;
	STS  133,R30
; 0000 0431 TCNT1L=0x00;
	STS  132,R30
; 0000 0432 ICR1H=0x00;
	STS  135,R30
; 0000 0433 ICR1L=0x00;
	STS  134,R30
; 0000 0434 OCR1AH=0x00;
	STS  137,R30
; 0000 0435 OCR1AL=0x00;
	STS  136,R30
; 0000 0436 OCR1BH=0x00;
	STS  139,R30
; 0000 0437 OCR1BL=0x00;
	STS  138,R30
; 0000 0438 OCR1CH=0x00;
	STS  141,R30
; 0000 0439 OCR1CL=0x00;
	STS  140,R30
; 0000 043A 
; 0000 043B // Timer/Counter 2 initialization
; 0000 043C // Clock source: System Clock
; 0000 043D // Clock value: Timer2 Stopped
; 0000 043E // Mode: Normal top=0xFF
; 0000 043F // OC2A output: Disconnected
; 0000 0440 // OC2B output: Disconnected
; 0000 0441 ASSR=0x00;
	STS  182,R30
; 0000 0442 TCCR2A=0x00;
	STS  176,R30
; 0000 0443 TCCR2B=0x04;
	LDI  R30,LOW(4)
	STS  177,R30
; 0000 0444 TCNT2=0xe7;
	LDI  R30,LOW(231)
	STS  178,R30
; 0000 0445 OCR2A=0x00;
	LDI  R30,LOW(0)
	STS  179,R30
; 0000 0446 OCR2B=0x00;
	STS  180,R30
; 0000 0447 
; 0000 0448 // Timer/Counter 3 initialization
; 0000 0449 // Clock source: System Clock
; 0000 044A // Clock value: Timer3 Stopped
; 0000 044B // Mode: Normal top=0xFFFF
; 0000 044C // OC3A output: Discon.
; 0000 044D // OC3B output: Discon.
; 0000 044E // OC3C output: Discon.
; 0000 044F // Noise Canceler: Off
; 0000 0450 // Input Capture on Falling Edge
; 0000 0451 // Timer3 Overflow Interrupt: Off
; 0000 0452 // Input Capture Interrupt: Off
; 0000 0453 // Compare A Match Interrupt: Off
; 0000 0454 // Compare B Match Interrupt: Off
; 0000 0455 // Compare C Match Interrupt: Off
; 0000 0456 TCCR3A=0x00;
	STS  144,R30
; 0000 0457 TCCR3B=0x00;
	STS  145,R30
; 0000 0458 TCNT3H=0x00;
	STS  149,R30
; 0000 0459 TCNT3L=0x00;
	STS  148,R30
; 0000 045A ICR3H=0x00;
	STS  151,R30
; 0000 045B ICR3L=0x00;
	STS  150,R30
; 0000 045C OCR3AH=0x00;
	STS  153,R30
; 0000 045D OCR3AL=0x00;
	STS  152,R30
; 0000 045E OCR3BH=0x00;
	STS  155,R30
; 0000 045F OCR3BL=0x00;
	STS  154,R30
; 0000 0460 OCR3CH=0x00;
	STS  157,R30
; 0000 0461 OCR3CL=0x00;
	STS  156,R30
; 0000 0462 
; 0000 0463 // Timer/Counter 4 initialization
; 0000 0464 // Clock source: System Clock
; 0000 0465 // Clock value: Timer4 Stopped
; 0000 0466 // Mode: Normal top=0xFFFF
; 0000 0467 // OC4A output: Discon.
; 0000 0468 // OC4B output: Discon.
; 0000 0469 // OC4C output: Discon.
; 0000 046A // Noise Canceler: Off
; 0000 046B // Input Capture on Falling Edge
; 0000 046C // Timer4 Overflow Interrupt: Off
; 0000 046D // Input Capture Interrupt: Off
; 0000 046E // Compare A Match Interrupt: Off
; 0000 046F // Compare B Match Interrupt: Off
; 0000 0470 // Compare C Match Interrupt: Off
; 0000 0471 TCCR4A=0x00;
	STS  160,R30
; 0000 0472 TCCR4B=0x00;
	STS  161,R30
; 0000 0473 TCNT4H=0x00;
	STS  165,R30
; 0000 0474 TCNT4L=0x00;
	STS  164,R30
; 0000 0475 ICR4H=0x00;
	STS  167,R30
; 0000 0476 ICR4L=0x00;
	STS  166,R30
; 0000 0477 OCR4AH=0x00;
	STS  169,R30
; 0000 0478 OCR4AL=0x00;
	STS  168,R30
; 0000 0479 OCR4BH=0x00;
	STS  171,R30
; 0000 047A OCR4BL=0x00;
	STS  170,R30
; 0000 047B OCR4CH=0x00;
	STS  173,R30
; 0000 047C OCR4CL=0x00;
	STS  172,R30
; 0000 047D 
; 0000 047E // Timer/Counter 5 initialization
; 0000 047F // Clock source: System Clock
; 0000 0480 // Clock value: Timer5 Stopped
; 0000 0481 // Mode: Normal top=0xFFFF
; 0000 0482 // OC5A output: Discon.
; 0000 0483 // OC5B output: Discon.
; 0000 0484 // OC5C output: Discon.
; 0000 0485 // Noise Canceler: Off
; 0000 0486 // Input Capture on Falling Edge
; 0000 0487 // Timer5 Overflow Interrupt: Off
; 0000 0488 // Input Capture Interrupt: Off
; 0000 0489 // Compare A Match Interrupt: Off
; 0000 048A // Compare B Match Interrupt: Off
; 0000 048B // Compare C Match Interrupt: Off
; 0000 048C TCCR5A=0x00;
	STS  288,R30
; 0000 048D TCCR5B=0x00;
	STS  289,R30
; 0000 048E TCNT5H=0x00;
	STS  293,R30
; 0000 048F TCNT5L=0x00;
	STS  292,R30
; 0000 0490 ICR5H=0x00;
	STS  295,R30
; 0000 0491 ICR5L=0x00;
	STS  294,R30
; 0000 0492 OCR5AH=0x00;
	STS  297,R30
; 0000 0493 OCR5AL=0x00;
	STS  296,R30
; 0000 0494 OCR5BH=0x00;
	STS  299,R30
; 0000 0495 OCR5BL=0x00;
	STS  298,R30
; 0000 0496 OCR5CH=0x00;
	STS  301,R30
; 0000 0497 OCR5CL=0x00;
	STS  300,R30
; 0000 0498 
; 0000 0499 // External Interrupt(s) initialization
; 0000 049A // INT0: Off
; 0000 049B // INT1: Off
; 0000 049C // INT2: Off
; 0000 049D // INT3: Off
; 0000 049E // INT4: Off
; 0000 049F // INT5: Off
; 0000 04A0 // INT6: Off
; 0000 04A1 // INT7: Off
; 0000 04A2 EICRA=0x00;
	STS  105,R30
; 0000 04A3 EICRB=0x00;
	STS  106,R30
; 0000 04A4 EIMSK=0x00;
	OUT  0x1D,R30
; 0000 04A5 // PCINT0 interrupt: Off
; 0000 04A6 // PCINT1 interrupt: Off
; 0000 04A7 // PCINT2 interrupt: Off
; 0000 04A8 // PCINT3 interrupt: Off
; 0000 04A9 // PCINT4 interrupt: Off
; 0000 04AA // PCINT5 interrupt: Off
; 0000 04AB // PCINT6 interrupt: Off
; 0000 04AC // PCINT7 interrupt: Off
; 0000 04AD // PCINT8 interrupt: Off
; 0000 04AE // PCINT9 interrupt: Off
; 0000 04AF // PCINT10 interrupt: Off
; 0000 04B0 // PCINT11 interrupt: Off
; 0000 04B1 // PCINT12 interrupt: Off
; 0000 04B2 // PCINT13 interrupt: Off
; 0000 04B3 // PCINT14 interrupt: Off
; 0000 04B4 // PCINT15 interrupt: Off
; 0000 04B5 // PCINT16 interrupt: Off
; 0000 04B6 // PCINT17 interrupt: Off
; 0000 04B7 // PCINT18 interrupt: Off
; 0000 04B8 // PCINT19 interrupt: Off
; 0000 04B9 // PCINT20 interrupt: Off
; 0000 04BA // PCINT21 interrupt: Off
; 0000 04BB // PCINT22 interrupt: Off
; 0000 04BC // PCINT23 interrupt: Off
; 0000 04BD PCMSK0=0x00;
	STS  107,R30
; 0000 04BE PCMSK1=0x00;
	STS  108,R30
; 0000 04BF PCMSK2=0x00;
	STS  109,R30
; 0000 04C0 PCICR=0x00;
	STS  104,R30
; 0000 04C1 
; 0000 04C2 // Timer/Counter 0 Interrupt(s) initialization
; 0000 04C3 TIMSK0=0x01;
	LDI  R30,LOW(1)
	STS  110,R30
; 0000 04C4 
; 0000 04C5 // Timer/Counter 1 Interrupt(s) initialization
; 0000 04C6 TIMSK1=0x00;
	LDI  R30,LOW(0)
	STS  111,R30
; 0000 04C7 
; 0000 04C8 // Timer/Counter 2 Interrupt(s) initialization
; 0000 04C9 TIMSK2=0x01;
	LDI  R30,LOW(1)
	STS  112,R30
; 0000 04CA 
; 0000 04CB // Timer/Counter 3 Interrupt(s) initialization
; 0000 04CC TIMSK3=0x00;
	LDI  R30,LOW(0)
	STS  113,R30
; 0000 04CD 
; 0000 04CE // Timer/Counter 4 Interrupt(s) initialization
; 0000 04CF TIMSK4=0x00;
	STS  114,R30
; 0000 04D0 
; 0000 04D1 // Timer/Counter 5 Interrupt(s) initialization
; 0000 04D2 TIMSK5=0x00;
	STS  115,R30
; 0000 04D3 
; 0000 04D4 // USART0 initialization
; 0000 04D5 // Communication Parameters: 8 Data, 1 Stop, No Parity
; 0000 04D6 // USART0 Receiver: Off
; 0000 04D7 // USART0 Transmitter: On
; 0000 04D8 // USART0 Mode: Asynchronous
; 0000 04D9 // USART0 Baud Rate: 9600
; 0000 04DA UCSR0A=0x00;
	STS  192,R30
; 0000 04DB UCSR0B=0x08;
	LDI  R30,LOW(8)
	STS  193,R30
; 0000 04DC UCSR0C=0x06;
	LDI  R30,LOW(6)
	STS  194,R30
; 0000 04DD UBRR0H=0x00;
	LDI  R30,LOW(0)
	STS  197,R30
; 0000 04DE UBRR0L=0x67;
	LDI  R30,LOW(103)
	STS  196,R30
; 0000 04DF 
; 0000 04E0 // USART1 initialization
; 0000 04E1 // USART1 disabled
; 0000 04E2 UCSR1B=0x00;
	LDI  R30,LOW(0)
	STS  201,R30
; 0000 04E3 
; 0000 04E4 // USART2 initialization
; 0000 04E5 // USART2 disabled
; 0000 04E6 UCSR2B=0x00;
	STS  209,R30
; 0000 04E7 
; 0000 04E8 // USART3 initialization
; 0000 04E9 // USART3 disabled
; 0000 04EA UCSR3B=0x00;
	STS  305,R30
; 0000 04EB 
; 0000 04EC // Analog Comparator initialization
; 0000 04ED // Analog Comparator: Off
; 0000 04EE // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 04EF ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x30,R30
; 0000 04F0 ADCSRB=0x00;
	LDI  R30,LOW(0)
	STS  123,R30
; 0000 04F1 DIDR1=0x00;
	STS  127,R30
; 0000 04F2 
; 0000 04F3 // ADC initialization
; 0000 04F4 // ADC Clock frequency: 1000.000 kHz
; 0000 04F5 // ADC Voltage Reference: AVCC pin
; 0000 04F6 // ADC Auto Trigger Source: ADC Stopped
; 0000 04F7 // Digital input buffers on ADC0: On, ADC1: On, ADC2: On, ADC3: On
; 0000 04F8 // ADC4: On, ADC5: On, ADC6: On, ADC7: On
; 0000 04F9 DIDR0=0x00;
	STS  126,R30
; 0000 04FA // Digital input buffers on ADC8: On, ADC9: On, ADC10: On, ADC11: On
; 0000 04FB // ADC12: On, ADC13: On, ADC14: On, ADC15: On
; 0000 04FC DIDR2=0x00;
	STS  125,R30
; 0000 04FD ADMUX=ADC_VREF_TYPE & 0xff;
	LDI  R30,LOW(64)
	STS  124,R30
; 0000 04FE ADCSRA=0x84;
	LDI  R30,LOW(132)
	STS  122,R30
; 0000 04FF 
; 0000 0500 // SPI initialization
; 0000 0501 // SPI disabled
; 0000 0502 SPCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x2C,R30
; 0000 0503 
; 0000 0504 // TWI initialization
; 0000 0505 // TWI disabled
; 0000 0506 TWCR=0x00;
	STS  188,R30
; 0000 0507 rst=1;
	SBI  0x2,6
; 0000 0508  lcd_init();     //׷LCD Ȯ庸 ʱȭ
	RCALL _lcd_init
; 0000 0509 // Global enable interrupts
; 0000 050A #asm("sei")
	sei
; 0000 050B first();     //׷LCD ù° 
	RCALL _first
; 0000 050C second();    //׷LCD ι° 
	RCALL _second
; 0000 050D  third();     //׷LCD ׹° 
	RCALL _third
; 0000 050E while (1)
_0x14B:
; 0000 050F       {
; 0000 0510          printf("UART0 Serial Output Test\r\n");
	__POINTW1FN _0x0,0
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	RCALL _printf
	ADIW R28,2
; 0000 0511       reverse_dis(); // ϸ鼭  Ʈ
	RCALL _reverse_dis
; 0000 0512 
; 0000 0513         switch(MotorDir)
	__GETW1R 11,12
; 0000 0514         {
; 0000 0515         case 0: CW1=1;CWC1=0;CW2=1;CCW2=0;break; //forward direction
	SBIW R30,0
	BRNE _0x151
	SBI  0xB,0
	CBI  0xB,1
	SBI  0xB,2
	CBI  0xB,3
	RJMP _0x150
; 0000 0516         case 1: CW1=0;CWC1=1;CW2=0;CCW2=1;break; //reverse direction
_0x151:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x150
	CBI  0xB,0
	SBI  0xB,1
	CBI  0xB,2
	SBI  0xB,3
; 0000 0517         }
_0x150:
; 0000 0518 
; 0000 0519        fourth();    //׷LCD ° 
	RCALL _fourth
; 0000 051A 
; 0000 051B 
; 0000 051C       }
	RJMP _0x14B
; 0000 051D }
_0x163:
	RJMP _0x163
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x01
	.EQU __sm_mask=0x0E
	.EQU __sm_powerdown=0x04
	.EQU __sm_powersave=0x06
	.EQU __sm_standby=0x0C
	.EQU __sm_ext_standby=0x0E
	.EQU __sm_adc_noise_red=0x02
	.SET power_ctrl_reg=smcr
	#endif

	.CSEG
_putchar:
_0x2000006:
	LDS  R30,192
	ANDI R30,LOW(0x20)
	BREQ _0x2000006
	LD   R30,Y
	STS  198,R30
_0x2060001:
	ADIW R28,1
	RET
_put_usart_G100:
	LDD  R30,Y+2
	ST   -Y,R30
	RCALL _putchar
	LD   R26,Y
	LDD  R27,Y+1
	CALL SUBOPT_0x0
	ADIW R28,3
	RET
__print_G100:
	SBIW R28,6
	CALL __SAVELOCR6
	LDI  R17,0
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   X+,R30
	ST   X,R31
_0x200001C:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ADIW R30,1
	STD  Y+18,R30
	STD  Y+18+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R18,R30
	CPI  R30,0
	BRNE PC+3
	JMP _0x200001E
	MOV  R30,R17
	CPI  R30,0
	BRNE _0x2000022
	CPI  R18,37
	BRNE _0x2000023
	LDI  R17,LOW(1)
	RJMP _0x2000024
_0x2000023:
	CALL SUBOPT_0x28
_0x2000024:
	RJMP _0x2000021
_0x2000022:
	CPI  R30,LOW(0x1)
	BRNE _0x2000025
	CPI  R18,37
	BRNE _0x2000026
	CALL SUBOPT_0x28
	RJMP _0x20000CF
_0x2000026:
	LDI  R17,LOW(2)
	LDI  R20,LOW(0)
	LDI  R16,LOW(0)
	CPI  R18,45
	BRNE _0x2000027
	LDI  R16,LOW(1)
	RJMP _0x2000021
_0x2000027:
	CPI  R18,43
	BRNE _0x2000028
	LDI  R20,LOW(43)
	RJMP _0x2000021
_0x2000028:
	CPI  R18,32
	BRNE _0x2000029
	LDI  R20,LOW(32)
	RJMP _0x2000021
_0x2000029:
	RJMP _0x200002A
_0x2000025:
	CPI  R30,LOW(0x2)
	BRNE _0x200002B
_0x200002A:
	LDI  R21,LOW(0)
	LDI  R17,LOW(3)
	CPI  R18,48
	BRNE _0x200002C
	ORI  R16,LOW(128)
	RJMP _0x2000021
_0x200002C:
	RJMP _0x200002D
_0x200002B:
	CPI  R30,LOW(0x3)
	BREQ PC+3
	JMP _0x2000021
_0x200002D:
	CPI  R18,48
	BRLO _0x2000030
	CPI  R18,58
	BRLO _0x2000031
_0x2000030:
	RJMP _0x200002F
_0x2000031:
	LDI  R26,LOW(10)
	MUL  R21,R26
	MOV  R21,R0
	MOV  R30,R18
	SUBI R30,LOW(48)
	ADD  R21,R30
	RJMP _0x2000021
_0x200002F:
	MOV  R30,R18
	CPI  R30,LOW(0x63)
	BRNE _0x2000035
	CALL SUBOPT_0x29
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	LDD  R26,Z+4
	ST   -Y,R26
	CALL SUBOPT_0x2A
	RJMP _0x2000036
_0x2000035:
	CPI  R30,LOW(0x73)
	BRNE _0x2000038
	CALL SUBOPT_0x29
	CALL SUBOPT_0x2B
	CALL _strlen
	MOV  R17,R30
	RJMP _0x2000039
_0x2000038:
	CPI  R30,LOW(0x70)
	BRNE _0x200003B
	CALL SUBOPT_0x29
	CALL SUBOPT_0x2B
	CALL _strlenf
	MOV  R17,R30
	ORI  R16,LOW(8)
_0x2000039:
	ORI  R16,LOW(2)
	ANDI R16,LOW(127)
	LDI  R19,LOW(0)
	RJMP _0x200003C
_0x200003B:
	CPI  R30,LOW(0x64)
	BREQ _0x200003F
	CPI  R30,LOW(0x69)
	BRNE _0x2000040
_0x200003F:
	ORI  R16,LOW(4)
	RJMP _0x2000041
_0x2000040:
	CPI  R30,LOW(0x75)
	BRNE _0x2000042
_0x2000041:
	LDI  R30,LOW(_tbl10_G100*2)
	LDI  R31,HIGH(_tbl10_G100*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(5)
	RJMP _0x2000043
_0x2000042:
	CPI  R30,LOW(0x58)
	BRNE _0x2000045
	ORI  R16,LOW(8)
	RJMP _0x2000046
_0x2000045:
	CPI  R30,LOW(0x78)
	BREQ PC+3
	JMP _0x2000077
_0x2000046:
	LDI  R30,LOW(_tbl16_G100*2)
	LDI  R31,HIGH(_tbl16_G100*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R17,LOW(4)
_0x2000043:
	SBRS R16,2
	RJMP _0x2000048
	CALL SUBOPT_0x29
	CALL SUBOPT_0x2C
	LDD  R26,Y+11
	TST  R26
	BRPL _0x2000049
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	CALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R20,LOW(45)
_0x2000049:
	CPI  R20,0
	BREQ _0x200004A
	SUBI R17,-LOW(1)
	RJMP _0x200004B
_0x200004A:
	ANDI R16,LOW(251)
_0x200004B:
	RJMP _0x200004C
_0x2000048:
	CALL SUBOPT_0x29
	CALL SUBOPT_0x2C
_0x200004C:
_0x200003C:
	SBRC R16,0
	RJMP _0x200004D
_0x200004E:
	CP   R17,R21
	BRSH _0x2000050
	SBRS R16,7
	RJMP _0x2000051
	SBRS R16,2
	RJMP _0x2000052
	ANDI R16,LOW(251)
	MOV  R18,R20
	SUBI R17,LOW(1)
	RJMP _0x2000053
_0x2000052:
	LDI  R18,LOW(48)
_0x2000053:
	RJMP _0x2000054
_0x2000051:
	LDI  R18,LOW(32)
_0x2000054:
	CALL SUBOPT_0x28
	SUBI R21,LOW(1)
	RJMP _0x200004E
_0x2000050:
_0x200004D:
	MOV  R19,R17
	SBRS R16,1
	RJMP _0x2000055
_0x2000056:
	CPI  R19,0
	BREQ _0x2000058
	SBRS R16,3
	RJMP _0x2000059
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LPM  R18,Z+
	STD  Y+6,R30
	STD  Y+6+1,R31
	RJMP _0x200005A
_0x2000059:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R18,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x200005A:
	CALL SUBOPT_0x28
	CPI  R21,0
	BREQ _0x200005B
	SUBI R21,LOW(1)
_0x200005B:
	SUBI R19,LOW(1)
	RJMP _0x2000056
_0x2000058:
	RJMP _0x200005C
_0x2000055:
_0x200005E:
	LDI  R18,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
_0x2000060:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	CP   R26,R30
	CPC  R27,R31
	BRLO _0x2000062
	SUBI R18,-LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	SUB  R30,R26
	SBC  R31,R27
	STD  Y+10,R30
	STD  Y+10+1,R31
	RJMP _0x2000060
_0x2000062:
	CPI  R18,58
	BRLO _0x2000063
	SBRS R16,3
	RJMP _0x2000064
	SUBI R18,-LOW(7)
	RJMP _0x2000065
_0x2000064:
	SUBI R18,-LOW(39)
_0x2000065:
_0x2000063:
	SBRC R16,4
	RJMP _0x2000067
	CPI  R18,49
	BRSH _0x2000069
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,1
	BRNE _0x2000068
_0x2000069:
	RJMP _0x20000D0
_0x2000068:
	CP   R21,R19
	BRLO _0x200006D
	SBRS R16,0
	RJMP _0x200006E
_0x200006D:
	RJMP _0x200006C
_0x200006E:
	LDI  R18,LOW(32)
	SBRS R16,7
	RJMP _0x200006F
	LDI  R18,LOW(48)
_0x20000D0:
	ORI  R16,LOW(16)
	SBRS R16,2
	RJMP _0x2000070
	ANDI R16,LOW(251)
	ST   -Y,R20
	CALL SUBOPT_0x2A
	CPI  R21,0
	BREQ _0x2000071
	SUBI R21,LOW(1)
_0x2000071:
_0x2000070:
_0x200006F:
_0x2000067:
	CALL SUBOPT_0x28
	CPI  R21,0
	BREQ _0x2000072
	SUBI R21,LOW(1)
_0x2000072:
_0x200006C:
	SUBI R19,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	SBIW R26,2
	BRLO _0x200005F
	RJMP _0x200005E
_0x200005F:
_0x200005C:
	SBRS R16,0
	RJMP _0x2000073
_0x2000074:
	CPI  R21,0
	BREQ _0x2000076
	SUBI R21,LOW(1)
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL SUBOPT_0x2A
	RJMP _0x2000074
_0x2000076:
_0x2000073:
_0x2000077:
_0x2000036:
_0x20000CF:
	LDI  R17,LOW(0)
_0x2000021:
	RJMP _0x200001C
_0x200001E:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	CALL __GETW1P
	CALL __LOADLOCR6
	ADIW R28,20
	RET
_printf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,6
	ST   -Y,R17
	ST   -Y,R16
	MOVW R26,R28
	ADIW R26,4
	CALL __ADDW2R15
	MOVW R16,R26
	LDI  R30,LOW(0)
	STD  Y+4,R30
	STD  Y+4+1,R30
	STD  Y+6,R30
	STD  Y+6+1,R30
	MOVW R26,R28
	ADIW R26,8
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	LDI  R30,LOW(_put_usart_G100)
	LDI  R31,HIGH(_put_usart_G100)
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,8
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G100
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,8
	POP  R15
	RET

	.CSEG

	.CSEG
_strlen:
    ld   r26,y+
    ld   r27,y+
    clr  r30
    clr  r31
strlen0:
    ld   r22,x+
    tst  r22
    breq strlen1
    adiw r30,1
    rjmp strlen0
strlen1:
    ret
_strlenf:
    clr  r26
    clr  r27
    ld   r30,y+
    ld   r31,y+
strlenf0:
	lpm  r0,z+
    tst  r0
    breq strlenf1
    adiw r26,1
    rjmp strlenf0
strlenf1:
    movw r30,r26
    ret

	.DSEG
_cw:
	.BYTE 0x4
_ccw:
	.BYTE 0x4
_lcd:
	.BYTE 0x4
_SecCnt:
	.BYTE 0x1
_cnt_S0000000000:
	.BYTE 0x2
_cnt2_S0000000000:
	.BYTE 0x2
_cnt3_S0000000000:
	.BYTE 0x2
_cnt4_S0000000000:
	.BYTE 0x2
_cnt5_S0000000000:
	.BYTE 0x2
_cnt_S0000001000:
	.BYTE 0x2
_cnt2_S0000001000:
	.BYTE 0x2
_sum_S0000003000:
	.BYTE 0x2
_rowsum_S0000003000:
	.BYTE 0x2
_buff_S0000003000:
	.BYTE 0x2

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x0:
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x1:
	MOVW R30,R16
	LDI  R26,LOW(_buff_S0000003000)
	LDI  R27,HIGH(_buff_S0000003000)
	LSL  R30
	ROL  R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x2:
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	__GETW1R 13,14
	LSL  R30
	ROL  R31
	CALL __LSLW4
	SUBI R30,LOW(-_str5*2)
	SBCI R31,HIGH(-_str5*2)
	MOVW R26,R30
	MOVW R30,R16
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW2PF
	MOV  R30,R18
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3:
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
	MOVW R30,R18
	CPI  R30,LOW(0xF)
	LDI  R26,HIGH(0xF)
	CPC  R31,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 23 TIMES, CODE SIZE REDUCTION:173 WORDS
SUBOPT_0x4:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LDI  R26,LOW(_buff_S0000003000)
	LDI  R27,HIGH(_buff_S0000003000)
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X+
	LD   R31,X+
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 31 TIMES, CODE SIZE REDUCTION:87 WORDS
SUBOPT_0x5:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,1
	STD  Y+6,R30
	STD  Y+6+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x6:
	LDI  R30,LOW(255)
	STS  258,R30
	LDI  R30,LOW(254)
	STS  264,R30
	LDI  R30,LOW(255)
	STS  264,R30
	STS  258,R30
	LDI  R30,LOW(253)
	STS  264,R30
	LDI  R30,LOW(255)
	STS  264,R30
	RJMP SUBOPT_0x1

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:27 WORDS
SUBOPT_0x7:
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	STS  _sum_S0000003000,R30
	STS  _sum_S0000003000+1,R31
	LDS  R30,_sum_S0000003000
	STS  258,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x8:
	LDI  R30,LOW(251)
	STS  264,R30
	LDI  R30,LOW(255)
	STS  264,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x9:
	LDS  R30,_sum_S0000003000
	LDS  R31,_sum_S0000003000+1
	CALL __ASRW8
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xA:
	LDI  R30,LOW(254)
	STS  264,R30
	LDI  R30,LOW(255)
	STS  264,R30
	RJMP SUBOPT_0x9

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0xB:
	STS  264,R30
	LDI  R30,LOW(255)
	STS  264,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0xC:
	MOVW R30,R16
	LDI  R26,LOW(_row*2)
	LDI  R27,HIGH(_row*2)
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW1PF
	STS  _rowsum_S0000003000,R30
	STS  _rowsum_S0000003000+1,R31
	LDS  R30,_rowsum_S0000003000
	STS  258,R30
	LDI  R30,LOW(239)
	RJMP SUBOPT_0xB

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0xD:
	LDS  R30,_rowsum_S0000003000
	LDS  R31,_rowsum_S0000003000+1
	CALL __ASRW8
	STS  258,R30
	LDI  R30,LOW(223)
	RJMP SUBOPT_0xB

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xE:
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0xF:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LDI  R26,LOW(_buff_S0000003000)
	LDI  R27,HIGH(_buff_S0000003000)
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x10:
	LDS  R30,_lcd
	COM  R30
	STS  _lcd,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x11:
	LDS  R30,_lcd
	ST   -Y,R30
	JMP  _dsp_str

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x12:
	__GETB1MN _lcd,2
	SUBI R30,-LOW(1)
	__PUTB1MN _lcd,2
	JMP  _dsp_addr

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x13:
	__PUTB1MN _lcd,1
	__GETB1MN _lcd,3
	__PUTB1MN _lcd,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x14:
	MOV  R30,R17
	LDD  R26,Y+5
	LDD  R27,Y+5+1
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R0,Z
	STS  _lcd,R0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x15:
	LDI  R30,LOW(184)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x16:
	LDI  R30,LOW(28)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 79 TIMES, CODE SIZE REDUCTION:309 WORDS
SUBOPT_0x17:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	JMP  _dsp_han

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x18:
	LDS  R30,_SecCnt
	LDI  R31,0
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x19:
	CALL _set_page0
	LDI  R30,LOW(186)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	CBI  0x1E,5
	LDI  R30,LOW(16)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x1A:
	CALL _set_page1
	LDI  R30,LOW(186)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	CBI  0x1E,5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x1B:
	__POINTW1FN _han,624
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x1C:
	__POINTW1FN _han,648
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:37 WORDS
SUBOPT_0x1D:
	CALL _set_page0
	LDI  R30,LOW(188)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,5
	LDI  R30,LOW(4)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1E:
	__POINTW1FN _han,1248
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1F:
	__POINTW1FN _han,1272
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x20:
	CALL _set_page1
	LDI  R30,LOW(188)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,5
	__POINTW1FN _han,1296
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x21:
	__POINTW1FN _han,576
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x22:
	__POINTW1FN _han,600
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x23:
	LDI  R30,LOW(5)
	ST   -Y,R30
	JMP  _dsp_nul2

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x24:
	CALL _set_page1
	LDI  R30,LOW(188)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	SBI  0x1E,5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x25:
	CALL _set_page0
	LDI  R30,LOW(190)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x26:
	LDI  R30,LOW(40)
	ST   -Y,R30
	CALL _dsp_nul2
	__POINTW1FN _han,240
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x27:
	CALL _set_page1
	LDI  R30,LOW(190)
	__PUTB1MN _lcd,2
	__PUTB1MN _lcd,3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:21 WORDS
SUBOPT_0x28:
	ST   -Y,R18
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x29:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	SBIW R30,4
	STD  Y+16,R30
	STD  Y+16+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x2A:
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+17
	LDD  R31,Y+17+1
	ICALL
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x2B:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x2C:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,4
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	RET


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xFA0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__LSLW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __LSLW12R
__LSLW12L:
	LSL  R30
	ROL  R31
	DEC  R0
	BRNE __LSLW12L
__LSLW12R:
	RET

__LSRW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __LSRW12R
__LSRW12L:
	LSR  R31
	ROR  R30
	DEC  R0
	BRNE __LSRW12L
__LSRW12R:
	RET

__LSLW4:
	LSL  R30
	ROL  R31
__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__ASRW8:
	MOV  R30,R31
	CLR  R31
	SBRC R30,7
	SER  R31
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__GETW2PF:
	LPM  R26,Z+
	LPM  R27,Z
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
